/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterConnectorRequest extends AppflowRequest implements
        ToCopyableBuilder<RegisterConnectorRequest.Builder, RegisterConnectorRequest> {
    private static final SdkField<String> CONNECTOR_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorLabel").getter(getter(RegisterConnectorRequest::connectorLabel))
            .setter(setter(Builder::connectorLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorLabel").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(RegisterConnectorRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> CONNECTOR_PROVISIONING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorProvisioningType").getter(getter(RegisterConnectorRequest::connectorProvisioningTypeAsString))
            .setter(setter(Builder::connectorProvisioningType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProvisioningType").build())
            .build();

    private static final SdkField<ConnectorProvisioningConfig> CONNECTOR_PROVISIONING_CONFIG_FIELD = SdkField
            .<ConnectorProvisioningConfig> builder(MarshallingType.SDK_POJO)
            .memberName("connectorProvisioningConfig")
            .getter(getter(RegisterConnectorRequest::connectorProvisioningConfig))
            .setter(setter(Builder::connectorProvisioningConfig))
            .constructor(ConnectorProvisioningConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProvisioningConfig")
                    .build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(RegisterConnectorRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_LABEL_FIELD,
            DESCRIPTION_FIELD, CONNECTOR_PROVISIONING_TYPE_FIELD, CONNECTOR_PROVISIONING_CONFIG_FIELD, CLIENT_TOKEN_FIELD));

    private final String connectorLabel;

    private final String description;

    private final String connectorProvisioningType;

    private final ConnectorProvisioningConfig connectorProvisioningConfig;

    private final String clientToken;

    private RegisterConnectorRequest(BuilderImpl builder) {
        super(builder);
        this.connectorLabel = builder.connectorLabel;
        this.description = builder.description;
        this.connectorProvisioningType = builder.connectorProvisioningType;
        this.connectorProvisioningConfig = builder.connectorProvisioningConfig;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The name of the connector. The name is unique for each <code>ConnectorRegistration</code> in your Amazon Web
     * Services account.
     * </p>
     * 
     * @return The name of the connector. The name is unique for each <code>ConnectorRegistration</code> in your Amazon
     *         Web Services account.
     */
    public final String connectorLabel() {
        return connectorLabel;
    }

    /**
     * <p>
     * A description about the connector that's being registered.
     * </p>
     * 
     * @return A description about the connector that's being registered.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The provisioning type of the connector. Currently the only supported value is LAMBDA.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #connectorProvisioningType} will return {@link ConnectorProvisioningType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #connectorProvisioningTypeAsString}.
     * </p>
     * 
     * @return The provisioning type of the connector. Currently the only supported value is LAMBDA.
     * @see ConnectorProvisioningType
     */
    public final ConnectorProvisioningType connectorProvisioningType() {
        return ConnectorProvisioningType.fromValue(connectorProvisioningType);
    }

    /**
     * <p>
     * The provisioning type of the connector. Currently the only supported value is LAMBDA.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #connectorProvisioningType} will return {@link ConnectorProvisioningType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #connectorProvisioningTypeAsString}.
     * </p>
     * 
     * @return The provisioning type of the connector. Currently the only supported value is LAMBDA.
     * @see ConnectorProvisioningType
     */
    public final String connectorProvisioningTypeAsString() {
        return connectorProvisioningType;
    }

    /**
     * <p>
     * The provisioning type of the connector. Currently the only supported value is LAMBDA.
     * </p>
     * 
     * @return The provisioning type of the connector. Currently the only supported value is LAMBDA.
     */
    public final ConnectorProvisioningConfig connectorProvisioningConfig() {
        return connectorProvisioningConfig;
    }

    /**
     * <p>
     * The <code>clientToken</code> parameter is an idempotency token. It ensures that your
     * <code>RegisterConnector</code> request completes only once. You choose the value to pass. For example, if you
     * don't receive a response from your request, you can safely retry the request with the same
     * <code>clientToken</code> parameter value.
     * </p>
     * <p>
     * If you omit a <code>clientToken</code> value, the Amazon Web Services SDK that you are using inserts a value for
     * you. This way, the SDK can safely retry requests multiple times after a network error. You must provide your own
     * value for other use cases.
     * </p>
     * <p>
     * If you specify input parameters that differ from your first request, an error occurs. If you use a different
     * value for <code>clientToken</code>, Amazon AppFlow considers it a new call to <code>RegisterConnector</code>. The
     * token is active for 8 hours.
     * </p>
     * 
     * @return The <code>clientToken</code> parameter is an idempotency token. It ensures that your
     *         <code>RegisterConnector</code> request completes only once. You choose the value to pass. For example, if
     *         you don't receive a response from your request, you can safely retry the request with the same
     *         <code>clientToken</code> parameter value.</p>
     *         <p>
     *         If you omit a <code>clientToken</code> value, the Amazon Web Services SDK that you are using inserts a
     *         value for you. This way, the SDK can safely retry requests multiple times after a network error. You must
     *         provide your own value for other use cases.
     *         </p>
     *         <p>
     *         If you specify input parameters that differ from your first request, an error occurs. If you use a
     *         different value for <code>clientToken</code>, Amazon AppFlow considers it a new call to
     *         <code>RegisterConnector</code>. The token is active for 8 hours.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectorLabel());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(connectorProvisioningTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(connectorProvisioningConfig());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterConnectorRequest)) {
            return false;
        }
        RegisterConnectorRequest other = (RegisterConnectorRequest) obj;
        return Objects.equals(connectorLabel(), other.connectorLabel()) && Objects.equals(description(), other.description())
                && Objects.equals(connectorProvisioningTypeAsString(), other.connectorProvisioningTypeAsString())
                && Objects.equals(connectorProvisioningConfig(), other.connectorProvisioningConfig())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterConnectorRequest").add("ConnectorLabel", connectorLabel())
                .add("Description", description()).add("ConnectorProvisioningType", connectorProvisioningTypeAsString())
                .add("ConnectorProvisioningConfig", connectorProvisioningConfig()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectorLabel":
            return Optional.ofNullable(clazz.cast(connectorLabel()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "connectorProvisioningType":
            return Optional.ofNullable(clazz.cast(connectorProvisioningTypeAsString()));
        case "connectorProvisioningConfig":
            return Optional.ofNullable(clazz.cast(connectorProvisioningConfig()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterConnectorRequest, T> g) {
        return obj -> g.apply((RegisterConnectorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppflowRequest.Builder, SdkPojo, CopyableBuilder<Builder, RegisterConnectorRequest> {
        /**
         * <p>
         * The name of the connector. The name is unique for each <code>ConnectorRegistration</code> in your Amazon Web
         * Services account.
         * </p>
         * 
         * @param connectorLabel
         *        The name of the connector. The name is unique for each <code>ConnectorRegistration</code> in your
         *        Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorLabel(String connectorLabel);

        /**
         * <p>
         * A description about the connector that's being registered.
         * </p>
         * 
         * @param description
         *        A description about the connector that's being registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The provisioning type of the connector. Currently the only supported value is LAMBDA.
         * </p>
         * 
         * @param connectorProvisioningType
         *        The provisioning type of the connector. Currently the only supported value is LAMBDA.
         * @see ConnectorProvisioningType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorProvisioningType
         */
        Builder connectorProvisioningType(String connectorProvisioningType);

        /**
         * <p>
         * The provisioning type of the connector. Currently the only supported value is LAMBDA.
         * </p>
         * 
         * @param connectorProvisioningType
         *        The provisioning type of the connector. Currently the only supported value is LAMBDA.
         * @see ConnectorProvisioningType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorProvisioningType
         */
        Builder connectorProvisioningType(ConnectorProvisioningType connectorProvisioningType);

        /**
         * <p>
         * The provisioning type of the connector. Currently the only supported value is LAMBDA.
         * </p>
         * 
         * @param connectorProvisioningConfig
         *        The provisioning type of the connector. Currently the only supported value is LAMBDA.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorProvisioningConfig(ConnectorProvisioningConfig connectorProvisioningConfig);

        /**
         * <p>
         * The provisioning type of the connector. Currently the only supported value is LAMBDA.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectorProvisioningConfig.Builder}
         * avoiding the need to create one manually via {@link ConnectorProvisioningConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectorProvisioningConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #connectorProvisioningConfig(ConnectorProvisioningConfig)}.
         * 
         * @param connectorProvisioningConfig
         *        a consumer that will call methods on {@link ConnectorProvisioningConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectorProvisioningConfig(ConnectorProvisioningConfig)
         */
        default Builder connectorProvisioningConfig(Consumer<ConnectorProvisioningConfig.Builder> connectorProvisioningConfig) {
            return connectorProvisioningConfig(ConnectorProvisioningConfig.builder().applyMutation(connectorProvisioningConfig)
                    .build());
        }

        /**
         * <p>
         * The <code>clientToken</code> parameter is an idempotency token. It ensures that your
         * <code>RegisterConnector</code> request completes only once. You choose the value to pass. For example, if you
         * don't receive a response from your request, you can safely retry the request with the same
         * <code>clientToken</code> parameter value.
         * </p>
         * <p>
         * If you omit a <code>clientToken</code> value, the Amazon Web Services SDK that you are using inserts a value
         * for you. This way, the SDK can safely retry requests multiple times after a network error. You must provide
         * your own value for other use cases.
         * </p>
         * <p>
         * If you specify input parameters that differ from your first request, an error occurs. If you use a different
         * value for <code>clientToken</code>, Amazon AppFlow considers it a new call to <code>RegisterConnector</code>.
         * The token is active for 8 hours.
         * </p>
         * 
         * @param clientToken
         *        The <code>clientToken</code> parameter is an idempotency token. It ensures that your
         *        <code>RegisterConnector</code> request completes only once. You choose the value to pass. For example,
         *        if you don't receive a response from your request, you can safely retry the request with the same
         *        <code>clientToken</code> parameter value.</p>
         *        <p>
         *        If you omit a <code>clientToken</code> value, the Amazon Web Services SDK that you are using inserts a
         *        value for you. This way, the SDK can safely retry requests multiple times after a network error. You
         *        must provide your own value for other use cases.
         *        </p>
         *        <p>
         *        If you specify input parameters that differ from your first request, an error occurs. If you use a
         *        different value for <code>clientToken</code>, Amazon AppFlow considers it a new call to
         *        <code>RegisterConnector</code>. The token is active for 8 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppflowRequest.BuilderImpl implements Builder {
        private String connectorLabel;

        private String description;

        private String connectorProvisioningType;

        private ConnectorProvisioningConfig connectorProvisioningConfig;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterConnectorRequest model) {
            super(model);
            connectorLabel(model.connectorLabel);
            description(model.description);
            connectorProvisioningType(model.connectorProvisioningType);
            connectorProvisioningConfig(model.connectorProvisioningConfig);
            clientToken(model.clientToken);
        }

        public final String getConnectorLabel() {
            return connectorLabel;
        }

        public final void setConnectorLabel(String connectorLabel) {
            this.connectorLabel = connectorLabel;
        }

        @Override
        public final Builder connectorLabel(String connectorLabel) {
            this.connectorLabel = connectorLabel;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getConnectorProvisioningType() {
            return connectorProvisioningType;
        }

        public final void setConnectorProvisioningType(String connectorProvisioningType) {
            this.connectorProvisioningType = connectorProvisioningType;
        }

        @Override
        public final Builder connectorProvisioningType(String connectorProvisioningType) {
            this.connectorProvisioningType = connectorProvisioningType;
            return this;
        }

        @Override
        public final Builder connectorProvisioningType(ConnectorProvisioningType connectorProvisioningType) {
            this.connectorProvisioningType(connectorProvisioningType == null ? null : connectorProvisioningType.toString());
            return this;
        }

        public final ConnectorProvisioningConfig.Builder getConnectorProvisioningConfig() {
            return connectorProvisioningConfig != null ? connectorProvisioningConfig.toBuilder() : null;
        }

        public final void setConnectorProvisioningConfig(ConnectorProvisioningConfig.BuilderImpl connectorProvisioningConfig) {
            this.connectorProvisioningConfig = connectorProvisioningConfig != null ? connectorProvisioningConfig.build() : null;
        }

        @Override
        public final Builder connectorProvisioningConfig(ConnectorProvisioningConfig connectorProvisioningConfig) {
            this.connectorProvisioningConfig = connectorProvisioningConfig;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterConnectorRequest build() {
            return new RegisterConnectorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
