/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appflow.model.AggregationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AggregationConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AggregationConfig> {
    private static final SdkField<String> AGGREGATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aggregationType").getter(AggregationConfig.getter(AggregationConfig::aggregationTypeAsString)).setter(AggregationConfig.setter(Builder::aggregationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationType").build()}).build();
    private static final SdkField<Long> TARGET_FILE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("targetFileSize").getter(AggregationConfig.getter(AggregationConfig::targetFileSize)).setter(AggregationConfig.setter(Builder::targetFileSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetFileSize").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATION_TYPE_FIELD, TARGET_FILE_SIZE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AggregationConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String aggregationType;
    private final Long targetFileSize;

    private AggregationConfig(BuilderImpl builder) {
        this.aggregationType = builder.aggregationType;
        this.targetFileSize = builder.targetFileSize;
    }

    public final AggregationType aggregationType() {
        return AggregationType.fromValue(this.aggregationType);
    }

    public final String aggregationTypeAsString() {
        return this.aggregationType;
    }

    public final Long targetFileSize() {
        return this.targetFileSize;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetFileSize());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregationConfig)) {
            return false;
        }
        AggregationConfig other = (AggregationConfig)obj;
        return Objects.equals(this.aggregationTypeAsString(), other.aggregationTypeAsString()) && Objects.equals(this.targetFileSize(), other.targetFileSize());
    }

    public final String toString() {
        return ToString.builder((String)"AggregationConfig").add("AggregationType", (Object)this.aggregationTypeAsString()).add("TargetFileSize", (Object)this.targetFileSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "aggregationType": {
                return Optional.ofNullable(clazz.cast(this.aggregationTypeAsString()));
            }
            case "targetFileSize": {
                return Optional.ofNullable(clazz.cast(this.targetFileSize()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("aggregationType", AGGREGATION_TYPE_FIELD);
        map.put("targetFileSize", TARGET_FILE_SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AggregationConfig, T> g) {
        return obj -> g.apply((AggregationConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String aggregationType;
        private Long targetFileSize;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregationConfig model) {
            this.aggregationType(model.aggregationType);
            this.targetFileSize(model.targetFileSize);
        }

        public final String getAggregationType() {
            return this.aggregationType;
        }

        public final void setAggregationType(String aggregationType) {
            this.aggregationType = aggregationType;
        }

        @Override
        public final Builder aggregationType(String aggregationType) {
            this.aggregationType = aggregationType;
            return this;
        }

        @Override
        public final Builder aggregationType(AggregationType aggregationType) {
            this.aggregationType(aggregationType == null ? null : aggregationType.toString());
            return this;
        }

        public final Long getTargetFileSize() {
            return this.targetFileSize;
        }

        public final void setTargetFileSize(Long targetFileSize) {
            this.targetFileSize = targetFileSize;
        }

        @Override
        public final Builder targetFileSize(Long targetFileSize) {
            this.targetFileSize = targetFileSize;
            return this;
        }

        public AggregationConfig build() {
            return new AggregationConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AggregationConfig> {
        public Builder aggregationType(String var1);

        public Builder aggregationType(AggregationType var1);

        public Builder targetFileSize(Long var1);
    }
}

