/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApiKeyCredentials
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApiKeyCredentials> {
    private static final SdkField<String> API_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("apiKey").getter(ApiKeyCredentials.getter(ApiKeyCredentials::apiKey)).setter(ApiKeyCredentials.setter(Builder::apiKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiKey").build()}).build();
    private static final SdkField<String> API_SECRET_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("apiSecretKey").getter(ApiKeyCredentials.getter(ApiKeyCredentials::apiSecretKey)).setter(ApiKeyCredentials.setter(Builder::apiSecretKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiSecretKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_KEY_FIELD, API_SECRET_KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ApiKeyCredentials.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String apiKey;
    private final String apiSecretKey;

    private ApiKeyCredentials(BuilderImpl builder) {
        this.apiKey = builder.apiKey;
        this.apiSecretKey = builder.apiSecretKey;
    }

    public final String apiKey() {
        return this.apiKey;
    }

    public final String apiSecretKey() {
        return this.apiSecretKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.apiKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiSecretKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApiKeyCredentials)) {
            return false;
        }
        ApiKeyCredentials other = (ApiKeyCredentials)obj;
        return Objects.equals(this.apiKey(), other.apiKey()) && Objects.equals(this.apiSecretKey(), other.apiSecretKey());
    }

    public final String toString() {
        return ToString.builder((String)"ApiKeyCredentials").add("ApiKey", (Object)(this.apiKey() == null ? null : "*** Sensitive Data Redacted ***")).add("ApiSecretKey", (Object)(this.apiSecretKey() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "apiKey": {
                return Optional.ofNullable(clazz.cast(this.apiKey()));
            }
            case "apiSecretKey": {
                return Optional.ofNullable(clazz.cast(this.apiSecretKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("apiKey", API_KEY_FIELD);
        map.put("apiSecretKey", API_SECRET_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApiKeyCredentials, T> g) {
        return obj -> g.apply((ApiKeyCredentials)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String apiKey;
        private String apiSecretKey;

        private BuilderImpl() {
        }

        private BuilderImpl(ApiKeyCredentials model) {
            this.apiKey(model.apiKey);
            this.apiSecretKey(model.apiSecretKey);
        }

        public final String getApiKey() {
            return this.apiKey;
        }

        public final void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }

        @Override
        public final Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public final String getApiSecretKey() {
            return this.apiSecretKey;
        }

        public final void setApiSecretKey(String apiSecretKey) {
            this.apiSecretKey = apiSecretKey;
        }

        @Override
        public final Builder apiSecretKey(String apiSecretKey) {
            this.apiSecretKey = apiSecretKey;
            return this;
        }

        public ApiKeyCredentials build() {
            return new ApiKeyCredentials(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApiKeyCredentials> {
        public Builder apiKey(String var1);

        public Builder apiSecretKey(String var1);
    }
}

