/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appintegrations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appintegrations.AppIntegrationsClient;
import software.amazon.awssdk.services.appintegrations.internal.UserAgentUtils;
import software.amazon.awssdk.services.appintegrations.model.DataIntegrationAssociationSummary;
import software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsRequest;
import software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsResponse;

public class ListDataIntegrationAssociationsIterable
implements SdkIterable<ListDataIntegrationAssociationsResponse> {
    private final AppIntegrationsClient client;
    private final ListDataIntegrationAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDataIntegrationAssociationsIterable(AppIntegrationsClient client, ListDataIntegrationAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDataIntegrationAssociationsResponseFetcher();
    }

    public Iterator<ListDataIntegrationAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DataIntegrationAssociationSummary> dataIntegrationAssociations() {
        Function<ListDataIntegrationAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataIntegrationAssociations() != null) {
                return response.dataIntegrationAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDataIntegrationAssociationsResponseFetcher
    implements SyncPageFetcher<ListDataIntegrationAssociationsResponse> {
        private ListDataIntegrationAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataIntegrationAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDataIntegrationAssociationsResponse nextPage(ListDataIntegrationAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListDataIntegrationAssociationsIterable.this.client.listDataIntegrationAssociations(ListDataIntegrationAssociationsIterable.this.firstRequest);
            }
            return ListDataIntegrationAssociationsIterable.this.client.listDataIntegrationAssociations((ListDataIntegrationAssociationsRequest)((Object)ListDataIntegrationAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

