/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationautoscaling.model.ApplicationAutoScalingResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivitiesCopier;
import software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeScalingActivitiesResponse
extends ApplicationAutoScalingResponse
implements ToCopyableBuilder<Builder, DescribeScalingActivitiesResponse> {
    private static final SdkField<List<ScalingActivity>> SCALING_ACTIVITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ScalingActivities").getter(DescribeScalingActivitiesResponse.getter(DescribeScalingActivitiesResponse::scalingActivities)).setter(DescribeScalingActivitiesResponse.setter(Builder::scalingActivities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingActivities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScalingActivity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeScalingActivitiesResponse.getter(DescribeScalingActivitiesResponse::nextToken)).setter(DescribeScalingActivitiesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALING_ACTIVITIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeScalingActivitiesResponse.memberNameToFieldInitializer();
    private final List<ScalingActivity> scalingActivities;
    private final String nextToken;

    private DescribeScalingActivitiesResponse(BuilderImpl builder) {
        super(builder);
        this.scalingActivities = builder.scalingActivities;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasScalingActivities() {
        return this.scalingActivities != null && !(this.scalingActivities instanceof SdkAutoConstructList);
    }

    public final List<ScalingActivity> scalingActivities() {
        return this.scalingActivities;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScalingActivities() ? this.scalingActivities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScalingActivitiesResponse)) {
            return false;
        }
        DescribeScalingActivitiesResponse other = (DescribeScalingActivitiesResponse)((Object)obj);
        return this.hasScalingActivities() == other.hasScalingActivities() && Objects.equals(this.scalingActivities(), other.scalingActivities()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeScalingActivitiesResponse").add("ScalingActivities", this.hasScalingActivities() ? this.scalingActivities() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScalingActivities": {
                return Optional.ofNullable(clazz.cast(this.scalingActivities()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ScalingActivities", SCALING_ACTIVITIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeScalingActivitiesResponse, T> g) {
        return obj -> g.apply((DescribeScalingActivitiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationAutoScalingResponse.BuilderImpl
    implements Builder {
        private List<ScalingActivity> scalingActivities = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScalingActivitiesResponse model) {
            super(model);
            this.scalingActivities(model.scalingActivities);
            this.nextToken(model.nextToken);
        }

        public final List<ScalingActivity.Builder> getScalingActivities() {
            List<ScalingActivity.Builder> result = ScalingActivitiesCopier.copyToBuilder(this.scalingActivities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScalingActivities(Collection<ScalingActivity.BuilderImpl> scalingActivities) {
            this.scalingActivities = ScalingActivitiesCopier.copyFromBuilder(scalingActivities);
        }

        @Override
        public final Builder scalingActivities(Collection<ScalingActivity> scalingActivities) {
            this.scalingActivities = ScalingActivitiesCopier.copy(scalingActivities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingActivities(ScalingActivity ... scalingActivities) {
            this.scalingActivities(Arrays.asList(scalingActivities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingActivities(Consumer<ScalingActivity.Builder> ... scalingActivities) {
            this.scalingActivities(Stream.of(scalingActivities).map(c -> (ScalingActivity)((ScalingActivity.Builder)ScalingActivity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeScalingActivitiesResponse build() {
            return new DescribeScalingActivitiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApplicationAutoScalingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeScalingActivitiesResponse> {
        public Builder scalingActivities(Collection<ScalingActivity> var1);

        public Builder scalingActivities(ScalingActivity ... var1);

        public Builder scalingActivities(Consumer<ScalingActivity.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

