/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationinsights;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.applicationinsights.model.AccessDeniedException;
import software.amazon.awssdk.services.applicationinsights.model.AddWorkloadRequest;
import software.amazon.awssdk.services.applicationinsights.model.AddWorkloadResponse;
import software.amazon.awssdk.services.applicationinsights.model.ApplicationInsightsException;
import software.amazon.awssdk.services.applicationinsights.model.BadRequestException;
import software.amazon.awssdk.services.applicationinsights.model.CreateApplicationRequest;
import software.amazon.awssdk.services.applicationinsights.model.CreateApplicationResponse;
import software.amazon.awssdk.services.applicationinsights.model.CreateComponentRequest;
import software.amazon.awssdk.services.applicationinsights.model.CreateComponentResponse;
import software.amazon.awssdk.services.applicationinsights.model.CreateLogPatternRequest;
import software.amazon.awssdk.services.applicationinsights.model.CreateLogPatternResponse;
import software.amazon.awssdk.services.applicationinsights.model.DeleteApplicationRequest;
import software.amazon.awssdk.services.applicationinsights.model.DeleteApplicationResponse;
import software.amazon.awssdk.services.applicationinsights.model.DeleteComponentRequest;
import software.amazon.awssdk.services.applicationinsights.model.DeleteComponentResponse;
import software.amazon.awssdk.services.applicationinsights.model.DeleteLogPatternRequest;
import software.amazon.awssdk.services.applicationinsights.model.DeleteLogPatternResponse;
import software.amazon.awssdk.services.applicationinsights.model.DescribeApplicationRequest;
import software.amazon.awssdk.services.applicationinsights.model.DescribeApplicationResponse;
import software.amazon.awssdk.services.applicationinsights.model.DescribeComponentConfigurationRecommendationRequest;
import software.amazon.awssdk.services.applicationinsights.model.DescribeComponentConfigurationRecommendationResponse;
import software.amazon.awssdk.services.applicationinsights.model.DescribeComponentConfigurationRequest;
import software.amazon.awssdk.services.applicationinsights.model.DescribeComponentConfigurationResponse;
import software.amazon.awssdk.services.applicationinsights.model.DescribeComponentRequest;
import software.amazon.awssdk.services.applicationinsights.model.DescribeComponentResponse;
import software.amazon.awssdk.services.applicationinsights.model.DescribeLogPatternRequest;
import software.amazon.awssdk.services.applicationinsights.model.DescribeLogPatternResponse;
import software.amazon.awssdk.services.applicationinsights.model.DescribeObservationRequest;
import software.amazon.awssdk.services.applicationinsights.model.DescribeObservationResponse;
import software.amazon.awssdk.services.applicationinsights.model.DescribeProblemObservationsRequest;
import software.amazon.awssdk.services.applicationinsights.model.DescribeProblemObservationsResponse;
import software.amazon.awssdk.services.applicationinsights.model.DescribeProblemRequest;
import software.amazon.awssdk.services.applicationinsights.model.DescribeProblemResponse;
import software.amazon.awssdk.services.applicationinsights.model.DescribeWorkloadRequest;
import software.amazon.awssdk.services.applicationinsights.model.DescribeWorkloadResponse;
import software.amazon.awssdk.services.applicationinsights.model.InternalServerException;
import software.amazon.awssdk.services.applicationinsights.model.ListApplicationsRequest;
import software.amazon.awssdk.services.applicationinsights.model.ListApplicationsResponse;
import software.amazon.awssdk.services.applicationinsights.model.ListComponentsRequest;
import software.amazon.awssdk.services.applicationinsights.model.ListComponentsResponse;
import software.amazon.awssdk.services.applicationinsights.model.ListConfigurationHistoryRequest;
import software.amazon.awssdk.services.applicationinsights.model.ListConfigurationHistoryResponse;
import software.amazon.awssdk.services.applicationinsights.model.ListLogPatternSetsRequest;
import software.amazon.awssdk.services.applicationinsights.model.ListLogPatternSetsResponse;
import software.amazon.awssdk.services.applicationinsights.model.ListLogPatternsRequest;
import software.amazon.awssdk.services.applicationinsights.model.ListLogPatternsResponse;
import software.amazon.awssdk.services.applicationinsights.model.ListProblemsRequest;
import software.amazon.awssdk.services.applicationinsights.model.ListProblemsResponse;
import software.amazon.awssdk.services.applicationinsights.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.applicationinsights.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.applicationinsights.model.ListWorkloadsRequest;
import software.amazon.awssdk.services.applicationinsights.model.ListWorkloadsResponse;
import software.amazon.awssdk.services.applicationinsights.model.RemoveWorkloadRequest;
import software.amazon.awssdk.services.applicationinsights.model.RemoveWorkloadResponse;
import software.amazon.awssdk.services.applicationinsights.model.ResourceInUseException;
import software.amazon.awssdk.services.applicationinsights.model.ResourceNotFoundException;
import software.amazon.awssdk.services.applicationinsights.model.TagResourceRequest;
import software.amazon.awssdk.services.applicationinsights.model.TagResourceResponse;
import software.amazon.awssdk.services.applicationinsights.model.TagsAlreadyExistException;
import software.amazon.awssdk.services.applicationinsights.model.TooManyTagsException;
import software.amazon.awssdk.services.applicationinsights.model.UntagResourceRequest;
import software.amazon.awssdk.services.applicationinsights.model.UntagResourceResponse;
import software.amazon.awssdk.services.applicationinsights.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.applicationinsights.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.applicationinsights.model.UpdateComponentConfigurationRequest;
import software.amazon.awssdk.services.applicationinsights.model.UpdateComponentConfigurationResponse;
import software.amazon.awssdk.services.applicationinsights.model.UpdateComponentRequest;
import software.amazon.awssdk.services.applicationinsights.model.UpdateComponentResponse;
import software.amazon.awssdk.services.applicationinsights.model.UpdateLogPatternRequest;
import software.amazon.awssdk.services.applicationinsights.model.UpdateLogPatternResponse;
import software.amazon.awssdk.services.applicationinsights.model.UpdateProblemRequest;
import software.amazon.awssdk.services.applicationinsights.model.UpdateProblemResponse;
import software.amazon.awssdk.services.applicationinsights.model.UpdateWorkloadRequest;
import software.amazon.awssdk.services.applicationinsights.model.UpdateWorkloadResponse;
import software.amazon.awssdk.services.applicationinsights.model.ValidationException;
import software.amazon.awssdk.services.applicationinsights.paginators.ListApplicationsIterable;
import software.amazon.awssdk.services.applicationinsights.paginators.ListComponentsIterable;
import software.amazon.awssdk.services.applicationinsights.paginators.ListConfigurationHistoryIterable;
import software.amazon.awssdk.services.applicationinsights.paginators.ListLogPatternSetsIterable;
import software.amazon.awssdk.services.applicationinsights.paginators.ListLogPatternsIterable;
import software.amazon.awssdk.services.applicationinsights.paginators.ListProblemsIterable;
import software.amazon.awssdk.services.applicationinsights.paginators.ListWorkloadsIterable;

/**
 * Service client for accessing Application Insights. This can be created using the static {@link #builder()} method.
 *
 * <fullname>Amazon CloudWatch Application Insights</fullname>
 * <p>
 * Amazon CloudWatch Application Insights is a service that helps you detect common problems with your applications. It
 * enables you to pinpoint the source of issues in your applications (built with technologies such as Microsoft IIS,
 * .NET, and Microsoft SQL Server), by providing key insights into detected problems.
 * </p>
 * <p>
 * After you onboard your application, CloudWatch Application Insights identifies, recommends, and sets up metrics and
 * logs. It continuously analyzes and correlates your metrics and logs for unusual behavior to surface actionable
 * problems with your application. For example, if your application is slow and unresponsive and leading to HTTP 500
 * errors in your Application Load Balancer (ALB), Application Insights informs you that a memory pressure problem with
 * your SQL Server database is occurring. It bases this analysis on impactful metrics and log errors.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ApplicationInsightsClient extends AwsClient {
    String SERVICE_NAME = "applicationinsights";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "applicationinsights";

    /**
     * <p>
     * Adds a workload to a component. Each component can have at most five workloads.
     * </p>
     *
     * @param addWorkloadRequest
     * @return Result of the AddWorkload operation returned by the service.
     * @throws ResourceInUseException
     *         The resource is already created or in use.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.AddWorkload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/AddWorkload"
     *      target="_top">AWS API Documentation</a>
     */
    default AddWorkloadResponse addWorkload(AddWorkloadRequest addWorkloadRequest) throws ResourceInUseException,
            ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            ApplicationInsightsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a workload to a component. Each component can have at most five workloads.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddWorkloadRequest.Builder} avoiding the need to
     * create one manually via {@link AddWorkloadRequest#builder()}
     * </p>
     *
     * @param addWorkloadRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationinsights.model.AddWorkloadRequest.Builder} to create a
     *        request.
     * @return Result of the AddWorkload operation returned by the service.
     * @throws ResourceInUseException
     *         The resource is already created or in use.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.AddWorkload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/AddWorkload"
     *      target="_top">AWS API Documentation</a>
     */
    default AddWorkloadResponse addWorkload(Consumer<AddWorkloadRequest.Builder> addWorkloadRequest)
            throws ResourceInUseException, ResourceNotFoundException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, ApplicationInsightsException {
        return addWorkload(AddWorkloadRequest.builder().applyMutation(addWorkloadRequest).build());
    }

    /**
     * <p>
     * Adds an application that is created from a resource group.
     * </p>
     *
     * @param createApplicationRequest
     * @return Result of the CreateApplication operation returned by the service.
     * @throws ResourceInUseException
     *         The resource is already created or in use.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws TagsAlreadyExistException
     *         Tags are already registered for the specified application ARN.
     * @throws AccessDeniedException
     *         User does not have permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/CreateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateApplicationResponse createApplication(CreateApplicationRequest createApplicationRequest)
            throws ResourceInUseException, ResourceNotFoundException, ValidationException, InternalServerException,
            TagsAlreadyExistException, AccessDeniedException, AwsServiceException, SdkClientException,
            ApplicationInsightsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an application that is created from a resource group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateApplicationRequest#builder()}
     * </p>
     *
     * @param createApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationinsights.model.CreateApplicationRequest.Builder} to
     *        create a request.
     * @return Result of the CreateApplication operation returned by the service.
     * @throws ResourceInUseException
     *         The resource is already created or in use.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws TagsAlreadyExistException
     *         Tags are already registered for the specified application ARN.
     * @throws AccessDeniedException
     *         User does not have permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/CreateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateApplicationResponse createApplication(Consumer<CreateApplicationRequest.Builder> createApplicationRequest)
            throws ResourceInUseException, ResourceNotFoundException, ValidationException, InternalServerException,
            TagsAlreadyExistException, AccessDeniedException, AwsServiceException, SdkClientException,
            ApplicationInsightsException {
        return createApplication(CreateApplicationRequest.builder().applyMutation(createApplicationRequest).build());
    }

    /**
     * <p>
     * Creates a custom component by grouping similar standalone instances to monitor.
     * </p>
     *
     * @param createComponentRequest
     * @return Result of the CreateComponent operation returned by the service.
     * @throws ResourceInUseException
     *         The resource is already created or in use.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.CreateComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/CreateComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateComponentResponse createComponent(CreateComponentRequest createComponentRequest) throws ResourceInUseException,
            ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            ApplicationInsightsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom component by grouping similar standalone instances to monitor.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateComponentRequest.Builder} avoiding the need
     * to create one manually via {@link CreateComponentRequest#builder()}
     * </p>
     *
     * @param createComponentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationinsights.model.CreateComponentRequest.Builder} to create
     *        a request.
     * @return Result of the CreateComponent operation returned by the service.
     * @throws ResourceInUseException
     *         The resource is already created or in use.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.CreateComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/CreateComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateComponentResponse createComponent(Consumer<CreateComponentRequest.Builder> createComponentRequest)
            throws ResourceInUseException, ResourceNotFoundException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, ApplicationInsightsException {
        return createComponent(CreateComponentRequest.builder().applyMutation(createComponentRequest).build());
    }

    /**
     * <p>
     * Adds an log pattern to a <code>LogPatternSet</code>.
     * </p>
     *
     * @param createLogPatternRequest
     * @return Result of the CreateLogPattern operation returned by the service.
     * @throws ResourceInUseException
     *         The resource is already created or in use.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.CreateLogPattern
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/CreateLogPattern"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLogPatternResponse createLogPattern(CreateLogPatternRequest createLogPatternRequest)
            throws ResourceInUseException, ResourceNotFoundException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, ApplicationInsightsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an log pattern to a <code>LogPatternSet</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLogPatternRequest.Builder} avoiding the need
     * to create one manually via {@link CreateLogPatternRequest#builder()}
     * </p>
     *
     * @param createLogPatternRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationinsights.model.CreateLogPatternRequest.Builder} to
     *        create a request.
     * @return Result of the CreateLogPattern operation returned by the service.
     * @throws ResourceInUseException
     *         The resource is already created or in use.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.CreateLogPattern
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/CreateLogPattern"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLogPatternResponse createLogPattern(Consumer<CreateLogPatternRequest.Builder> createLogPatternRequest)
            throws ResourceInUseException, ResourceNotFoundException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, ApplicationInsightsException {
        return createLogPattern(CreateLogPatternRequest.builder().applyMutation(createLogPatternRequest).build());
    }

    /**
     * <p>
     * Removes the specified application from monitoring. Does not delete the application.
     * </p>
     *
     * @param deleteApplicationRequest
     * @return Result of the DeleteApplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws BadRequestException
     *         The request is not understood by the server.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DeleteApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteApplicationResponse deleteApplication(DeleteApplicationRequest deleteApplicationRequest)
            throws ResourceNotFoundException, ValidationException, BadRequestException, InternalServerException,
            AwsServiceException, SdkClientException, ApplicationInsightsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified application from monitoring. Does not delete the application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteApplicationRequest#builder()}
     * </p>
     *
     * @param deleteApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationinsights.model.DeleteApplicationRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteApplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws BadRequestException
     *         The request is not understood by the server.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DeleteApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteApplicationResponse deleteApplication(Consumer<DeleteApplicationRequest.Builder> deleteApplicationRequest)
            throws ResourceNotFoundException, ValidationException, BadRequestException, InternalServerException,
            AwsServiceException, SdkClientException, ApplicationInsightsException {
        return deleteApplication(DeleteApplicationRequest.builder().applyMutation(deleteApplicationRequest).build());
    }

    /**
     * <p>
     * Ungroups a custom component. When you ungroup custom components, all applicable monitors that are set up for the
     * component are removed and the instances revert to their standalone status.
     * </p>
     *
     * @param deleteComponentRequest
     * @return Result of the DeleteComponent operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.DeleteComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DeleteComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteComponentResponse deleteComponent(DeleteComponentRequest deleteComponentRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ApplicationInsightsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Ungroups a custom component. When you ungroup custom components, all applicable monitors that are set up for the
     * component are removed and the instances revert to their standalone status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteComponentRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteComponentRequest#builder()}
     * </p>
     *
     * @param deleteComponentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationinsights.model.DeleteComponentRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteComponent operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.DeleteComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DeleteComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteComponentResponse deleteComponent(Consumer<DeleteComponentRequest.Builder> deleteComponentRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ApplicationInsightsException {
        return deleteComponent(DeleteComponentRequest.builder().applyMutation(deleteComponentRequest).build());
    }

    /**
     * <p>
     * Removes the specified log pattern from a <code>LogPatternSet</code>.
     * </p>
     *
     * @param deleteLogPatternRequest
     * @return Result of the DeleteLogPattern operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws BadRequestException
     *         The request is not understood by the server.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.DeleteLogPattern
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DeleteLogPattern"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLogPatternResponse deleteLogPattern(DeleteLogPatternRequest deleteLogPatternRequest)
            throws ResourceNotFoundException, ValidationException, BadRequestException, InternalServerException,
            AwsServiceException, SdkClientException, ApplicationInsightsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified log pattern from a <code>LogPatternSet</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLogPatternRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteLogPatternRequest#builder()}
     * </p>
     *
     * @param deleteLogPatternRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationinsights.model.DeleteLogPatternRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteLogPattern operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws BadRequestException
     *         The request is not understood by the server.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.DeleteLogPattern
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DeleteLogPattern"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLogPatternResponse deleteLogPattern(Consumer<DeleteLogPatternRequest.Builder> deleteLogPatternRequest)
            throws ResourceNotFoundException, ValidationException, BadRequestException, InternalServerException,
            AwsServiceException, SdkClientException, ApplicationInsightsException {
        return deleteLogPattern(DeleteLogPatternRequest.builder().applyMutation(deleteLogPatternRequest).build());
    }

    /**
     * <p>
     * Describes the application.
     * </p>
     *
     * @param describeApplicationRequest
     * @return Result of the DescribeApplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.DescribeApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicationResponse describeApplication(DescribeApplicationRequest describeApplicationRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ApplicationInsightsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeApplicationRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeApplicationRequest#builder()}
     * </p>
     *
     * @param describeApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationinsights.model.DescribeApplicationRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeApplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.DescribeApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicationResponse describeApplication(
            Consumer<DescribeApplicationRequest.Builder> describeApplicationRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, ApplicationInsightsException {
        return describeApplication(DescribeApplicationRequest.builder().applyMutation(describeApplicationRequest).build());
    }

    /**
     * <p>
     * Describes a component and lists the resources that are grouped together in a component.
     * </p>
     *
     * @param describeComponentRequest
     * @return Result of the DescribeComponent operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.DescribeComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeComponentResponse describeComponent(DescribeComponentRequest describeComponentRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ApplicationInsightsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a component and lists the resources that are grouped together in a component.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeComponentRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeComponentRequest#builder()}
     * </p>
     *
     * @param describeComponentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationinsights.model.DescribeComponentRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeComponent operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.DescribeComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeComponentResponse describeComponent(Consumer<DescribeComponentRequest.Builder> describeComponentRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ApplicationInsightsException {
        return describeComponent(DescribeComponentRequest.builder().applyMutation(describeComponentRequest).build());
    }

    /**
     * <p>
     * Describes the monitoring configuration of the component.
     * </p>
     *
     * @param describeComponentConfigurationRequest
     * @return Result of the DescribeComponentConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.DescribeComponentConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeComponentConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeComponentConfigurationResponse describeComponentConfiguration(
            DescribeComponentConfigurationRequest describeComponentConfigurationRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, ApplicationInsightsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the monitoring configuration of the component.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeComponentConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeComponentConfigurationRequest#builder()}
     * </p>
     *
     * @param describeComponentConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationinsights.model.DescribeComponentConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeComponentConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.DescribeComponentConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeComponentConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeComponentConfigurationResponse describeComponentConfiguration(
            Consumer<DescribeComponentConfigurationRequest.Builder> describeComponentConfigurationRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ApplicationInsightsException {
        return describeComponentConfiguration(DescribeComponentConfigurationRequest.builder()
                .applyMutation(describeComponentConfigurationRequest).build());
    }

    /**
     * <p>
     * Describes the recommended monitoring configuration of the component.
     * </p>
     *
     * @param describeComponentConfigurationRecommendationRequest
     * @return Result of the DescribeComponentConfigurationRecommendation operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.DescribeComponentConfigurationRecommendation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeComponentConfigurationRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeComponentConfigurationRecommendationResponse describeComponentConfigurationRecommendation(
            DescribeComponentConfigurationRecommendationRequest describeComponentConfigurationRecommendationRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ApplicationInsightsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the recommended monitoring configuration of the component.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeComponentConfigurationRecommendationRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeComponentConfigurationRecommendationRequest#builder()}
     * </p>
     *
     * @param describeComponentConfigurationRecommendationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationinsights.model.DescribeComponentConfigurationRecommendationRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeComponentConfigurationRecommendation operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.DescribeComponentConfigurationRecommendation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeComponentConfigurationRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeComponentConfigurationRecommendationResponse describeComponentConfigurationRecommendation(
            Consumer<DescribeComponentConfigurationRecommendationRequest.Builder> describeComponentConfigurationRecommendationRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ApplicationInsightsException {
        return describeComponentConfigurationRecommendation(DescribeComponentConfigurationRecommendationRequest.builder()
                .applyMutation(describeComponentConfigurationRecommendationRequest).build());
    }

    /**
     * <p>
     * Describe a specific log pattern from a <code>LogPatternSet</code>.
     * </p>
     *
     * @param describeLogPatternRequest
     * @return Result of the DescribeLogPattern operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.DescribeLogPattern
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeLogPattern"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLogPatternResponse describeLogPattern(DescribeLogPatternRequest describeLogPatternRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ApplicationInsightsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe a specific log pattern from a <code>LogPatternSet</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLogPatternRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLogPatternRequest#builder()}
     * </p>
     *
     * @param describeLogPatternRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationinsights.model.DescribeLogPatternRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeLogPattern operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.DescribeLogPattern
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeLogPattern"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLogPatternResponse describeLogPattern(Consumer<DescribeLogPatternRequest.Builder> describeLogPatternRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ApplicationInsightsException {
        return describeLogPattern(DescribeLogPatternRequest.builder().applyMutation(describeLogPatternRequest).build());
    }

    /**
     * <p>
     * Describes an anomaly or error with the application.
     * </p>
     *
     * @param describeObservationRequest
     * @return Result of the DescribeObservation operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.DescribeObservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeObservation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeObservationResponse describeObservation(DescribeObservationRequest describeObservationRequest)
            throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ApplicationInsightsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an anomaly or error with the application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeObservationRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeObservationRequest#builder()}
     * </p>
     *
     * @param describeObservationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationinsights.model.DescribeObservationRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeObservation operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.DescribeObservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeObservation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeObservationResponse describeObservation(
            Consumer<DescribeObservationRequest.Builder> describeObservationRequest) throws InternalServerException,
            ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, ApplicationInsightsException {
        return describeObservation(DescribeObservationRequest.builder().applyMutation(describeObservationRequest).build());
    }

    /**
     * <p>
     * Describes an application problem.
     * </p>
     *
     * @param describeProblemRequest
     * @return Result of the DescribeProblem operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.DescribeProblem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeProblem"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProblemResponse describeProblem(DescribeProblemRequest describeProblemRequest)
            throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ApplicationInsightsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an application problem.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProblemRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeProblemRequest#builder()}
     * </p>
     *
     * @param describeProblemRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationinsights.model.DescribeProblemRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeProblem operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.DescribeProblem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeProblem"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProblemResponse describeProblem(Consumer<DescribeProblemRequest.Builder> describeProblemRequest)
            throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ApplicationInsightsException {
        return describeProblem(DescribeProblemRequest.builder().applyMutation(describeProblemRequest).build());
    }

    /**
     * <p>
     * Describes the anomalies or errors associated with the problem.
     * </p>
     *
     * @param describeProblemObservationsRequest
     * @return Result of the DescribeProblemObservations operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.DescribeProblemObservations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeProblemObservations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProblemObservationsResponse describeProblemObservations(
            DescribeProblemObservationsRequest describeProblemObservationsRequest) throws InternalServerException,
            ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, ApplicationInsightsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the anomalies or errors associated with the problem.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProblemObservationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeProblemObservationsRequest#builder()}
     * </p>
     *
     * @param describeProblemObservationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationinsights.model.DescribeProblemObservationsRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeProblemObservations operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.DescribeProblemObservations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeProblemObservations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProblemObservationsResponse describeProblemObservations(
            Consumer<DescribeProblemObservationsRequest.Builder> describeProblemObservationsRequest)
            throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ApplicationInsightsException {
        return describeProblemObservations(DescribeProblemObservationsRequest.builder()
                .applyMutation(describeProblemObservationsRequest).build());
    }

    /**
     * <p>
     * Describes a workload and its configuration.
     * </p>
     *
     * @param describeWorkloadRequest
     * @return Result of the DescribeWorkload operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.DescribeWorkload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeWorkload"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkloadResponse describeWorkload(DescribeWorkloadRequest describeWorkloadRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ApplicationInsightsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a workload and its configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkloadRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeWorkloadRequest#builder()}
     * </p>
     *
     * @param describeWorkloadRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationinsights.model.DescribeWorkloadRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeWorkload operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.DescribeWorkload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeWorkload"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkloadResponse describeWorkload(Consumer<DescribeWorkloadRequest.Builder> describeWorkloadRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ApplicationInsightsException {
        return describeWorkload(DescribeWorkloadRequest.builder().applyMutation(describeWorkloadRequest).build());
    }

    /**
     * <p>
     * Lists the IDs of the applications that you are monitoring.
     * </p>
     *
     * @param listApplicationsRequest
     * @return Result of the ListApplications operation returned by the service.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationsResponse listApplications(ListApplicationsRequest listApplicationsRequest)
            throws ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            ApplicationInsightsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the IDs of the applications that you are monitoring.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApplicationsRequest#builder()}
     * </p>
     *
     * @param listApplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationinsights.model.ListApplicationsRequest.Builder} to
     *        create a request.
     * @return Result of the ListApplications operation returned by the service.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationsResponse listApplications(Consumer<ListApplicationsRequest.Builder> listApplicationsRequest)
            throws ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            ApplicationInsightsException {
        return listApplications(ListApplicationsRequest.builder().applyMutation(listApplicationsRequest).build());
    }

    /**
     * <p>
     * Lists the IDs of the applications that you are monitoring.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApplications(software.amazon.awssdk.services.applicationinsights.model.ListApplicationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationinsights.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.applicationinsights.paginators.ListApplicationsIterable responses = client
     *             .listApplicationsPaginator(request);
     *     for (software.amazon.awssdk.services.applicationinsights.model.ListApplicationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationinsights.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.applicationinsights.model.ListApplicationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApplicationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationsIterable listApplicationsPaginator(ListApplicationsRequest listApplicationsRequest)
            throws ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            ApplicationInsightsException {
        return new ListApplicationsIterable(this, listApplicationsRequest);
    }

    /**
     * <p>
     * Lists the IDs of the applications that you are monitoring.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApplications(software.amazon.awssdk.services.applicationinsights.model.ListApplicationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationinsights.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.applicationinsights.paginators.ListApplicationsIterable responses = client
     *             .listApplicationsPaginator(request);
     *     for (software.amazon.awssdk.services.applicationinsights.model.ListApplicationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationinsights.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.applicationinsights.model.ListApplicationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApplicationsRequest#builder()}
     * </p>
     *
     * @param listApplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationinsights.model.ListApplicationsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationsIterable listApplicationsPaginator(Consumer<ListApplicationsRequest.Builder> listApplicationsRequest)
            throws ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            ApplicationInsightsException {
        return listApplicationsPaginator(ListApplicationsRequest.builder().applyMutation(listApplicationsRequest).build());
    }

    /**
     * <p>
     * Lists the auto-grouped, standalone, and custom components of the application.
     * </p>
     *
     * @param listComponentsRequest
     * @return Result of the ListComponents operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListComponents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListComponentsResponse listComponents(ListComponentsRequest listComponentsRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, ApplicationInsightsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the auto-grouped, standalone, and custom components of the application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComponentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListComponentsRequest#builder()}
     * </p>
     *
     * @param listComponentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationinsights.model.ListComponentsRequest.Builder} to create
     *        a request.
     * @return Result of the ListComponents operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListComponents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListComponentsResponse listComponents(Consumer<ListComponentsRequest.Builder> listComponentsRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ApplicationInsightsException {
        return listComponents(ListComponentsRequest.builder().applyMutation(listComponentsRequest).build());
    }

    /**
     * <p>
     * Lists the auto-grouped, standalone, and custom components of the application.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listComponents(software.amazon.awssdk.services.applicationinsights.model.ListComponentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationinsights.paginators.ListComponentsIterable responses = client.listComponentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.applicationinsights.paginators.ListComponentsIterable responses = client
     *             .listComponentsPaginator(request);
     *     for (software.amazon.awssdk.services.applicationinsights.model.ListComponentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationinsights.paginators.ListComponentsIterable responses = client.listComponentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComponents(software.amazon.awssdk.services.applicationinsights.model.ListComponentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listComponentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListComponents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListComponentsIterable listComponentsPaginator(ListComponentsRequest listComponentsRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ApplicationInsightsException {
        return new ListComponentsIterable(this, listComponentsRequest);
    }

    /**
     * <p>
     * Lists the auto-grouped, standalone, and custom components of the application.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listComponents(software.amazon.awssdk.services.applicationinsights.model.ListComponentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationinsights.paginators.ListComponentsIterable responses = client.listComponentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.applicationinsights.paginators.ListComponentsIterable responses = client
     *             .listComponentsPaginator(request);
     *     for (software.amazon.awssdk.services.applicationinsights.model.ListComponentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationinsights.paginators.ListComponentsIterable responses = client.listComponentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComponents(software.amazon.awssdk.services.applicationinsights.model.ListComponentsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComponentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListComponentsRequest#builder()}
     * </p>
     *
     * @param listComponentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationinsights.model.ListComponentsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListComponents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListComponentsIterable listComponentsPaginator(Consumer<ListComponentsRequest.Builder> listComponentsRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ApplicationInsightsException {
        return listComponentsPaginator(ListComponentsRequest.builder().applyMutation(listComponentsRequest).build());
    }

    /**
     * <p>
     * Lists the INFO, WARN, and ERROR events for periodic configuration updates performed by Application Insights.
     * Examples of events represented are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * INFO: creating a new alarm or updating an alarm threshold.
     * </p>
     * </li>
     * <li>
     * <p>
     * WARN: alarm not created due to insufficient data points used to predict thresholds.
     * </p>
     * </li>
     * <li>
     * <p>
     * ERROR: alarm not created due to permission errors or exceeding quotas.
     * </p>
     * </li>
     * </ul>
     *
     * @param listConfigurationHistoryRequest
     * @return Result of the ListConfigurationHistory operation returned by the service.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.ListConfigurationHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListConfigurationHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfigurationHistoryResponse listConfigurationHistory(
            ListConfigurationHistoryRequest listConfigurationHistoryRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            ApplicationInsightsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the INFO, WARN, and ERROR events for periodic configuration updates performed by Application Insights.
     * Examples of events represented are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * INFO: creating a new alarm or updating an alarm threshold.
     * </p>
     * </li>
     * <li>
     * <p>
     * WARN: alarm not created due to insufficient data points used to predict thresholds.
     * </p>
     * </li>
     * <li>
     * <p>
     * ERROR: alarm not created due to permission errors or exceeding quotas.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigurationHistoryRequest.Builder} avoiding
     * the need to create one manually via {@link ListConfigurationHistoryRequest#builder()}
     * </p>
     *
     * @param listConfigurationHistoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationinsights.model.ListConfigurationHistoryRequest.Builder}
     *        to create a request.
     * @return Result of the ListConfigurationHistory operation returned by the service.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.ListConfigurationHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListConfigurationHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfigurationHistoryResponse listConfigurationHistory(
            Consumer<ListConfigurationHistoryRequest.Builder> listConfigurationHistoryRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            ApplicationInsightsException {
        return listConfigurationHistory(ListConfigurationHistoryRequest.builder().applyMutation(listConfigurationHistoryRequest)
                .build());
    }

    /**
     * <p>
     * Lists the INFO, WARN, and ERROR events for periodic configuration updates performed by Application Insights.
     * Examples of events represented are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * INFO: creating a new alarm or updating an alarm threshold.
     * </p>
     * </li>
     * <li>
     * <p>
     * WARN: alarm not created due to insufficient data points used to predict thresholds.
     * </p>
     * </li>
     * <li>
     * <p>
     * ERROR: alarm not created due to permission errors or exceeding quotas.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listConfigurationHistory(software.amazon.awssdk.services.applicationinsights.model.ListConfigurationHistoryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationinsights.paginators.ListConfigurationHistoryIterable responses = client.listConfigurationHistoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.applicationinsights.paginators.ListConfigurationHistoryIterable responses = client
     *             .listConfigurationHistoryPaginator(request);
     *     for (software.amazon.awssdk.services.applicationinsights.model.ListConfigurationHistoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationinsights.paginators.ListConfigurationHistoryIterable responses = client.listConfigurationHistoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfigurationHistory(software.amazon.awssdk.services.applicationinsights.model.ListConfigurationHistoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConfigurationHistoryRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.ListConfigurationHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListConfigurationHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfigurationHistoryIterable listConfigurationHistoryPaginator(
            ListConfigurationHistoryRequest listConfigurationHistoryRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            ApplicationInsightsException {
        return new ListConfigurationHistoryIterable(this, listConfigurationHistoryRequest);
    }

    /**
     * <p>
     * Lists the INFO, WARN, and ERROR events for periodic configuration updates performed by Application Insights.
     * Examples of events represented are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * INFO: creating a new alarm or updating an alarm threshold.
     * </p>
     * </li>
     * <li>
     * <p>
     * WARN: alarm not created due to insufficient data points used to predict thresholds.
     * </p>
     * </li>
     * <li>
     * <p>
     * ERROR: alarm not created due to permission errors or exceeding quotas.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listConfigurationHistory(software.amazon.awssdk.services.applicationinsights.model.ListConfigurationHistoryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationinsights.paginators.ListConfigurationHistoryIterable responses = client.listConfigurationHistoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.applicationinsights.paginators.ListConfigurationHistoryIterable responses = client
     *             .listConfigurationHistoryPaginator(request);
     *     for (software.amazon.awssdk.services.applicationinsights.model.ListConfigurationHistoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationinsights.paginators.ListConfigurationHistoryIterable responses = client.listConfigurationHistoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfigurationHistory(software.amazon.awssdk.services.applicationinsights.model.ListConfigurationHistoryRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigurationHistoryRequest.Builder} avoiding
     * the need to create one manually via {@link ListConfigurationHistoryRequest#builder()}
     * </p>
     *
     * @param listConfigurationHistoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationinsights.model.ListConfigurationHistoryRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.ListConfigurationHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListConfigurationHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfigurationHistoryIterable listConfigurationHistoryPaginator(
            Consumer<ListConfigurationHistoryRequest.Builder> listConfigurationHistoryRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            ApplicationInsightsException {
        return listConfigurationHistoryPaginator(ListConfigurationHistoryRequest.builder()
                .applyMutation(listConfigurationHistoryRequest).build());
    }

    /**
     * <p>
     * Lists the log pattern sets in the specific application.
     * </p>
     *
     * @param listLogPatternSetsRequest
     * @return Result of the ListLogPatternSets operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.ListLogPatternSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListLogPatternSets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLogPatternSetsResponse listLogPatternSets(ListLogPatternSetsRequest listLogPatternSetsRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ApplicationInsightsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the log pattern sets in the specific application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLogPatternSetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListLogPatternSetsRequest#builder()}
     * </p>
     *
     * @param listLogPatternSetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationinsights.model.ListLogPatternSetsRequest.Builder} to
     *        create a request.
     * @return Result of the ListLogPatternSets operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.ListLogPatternSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListLogPatternSets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLogPatternSetsResponse listLogPatternSets(Consumer<ListLogPatternSetsRequest.Builder> listLogPatternSetsRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ApplicationInsightsException {
        return listLogPatternSets(ListLogPatternSetsRequest.builder().applyMutation(listLogPatternSetsRequest).build());
    }

    /**
     * <p>
     * Lists the log pattern sets in the specific application.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLogPatternSets(software.amazon.awssdk.services.applicationinsights.model.ListLogPatternSetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationinsights.paginators.ListLogPatternSetsIterable responses = client.listLogPatternSetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.applicationinsights.paginators.ListLogPatternSetsIterable responses = client
     *             .listLogPatternSetsPaginator(request);
     *     for (software.amazon.awssdk.services.applicationinsights.model.ListLogPatternSetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationinsights.paginators.ListLogPatternSetsIterable responses = client.listLogPatternSetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLogPatternSets(software.amazon.awssdk.services.applicationinsights.model.ListLogPatternSetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLogPatternSetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.ListLogPatternSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListLogPatternSets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLogPatternSetsIterable listLogPatternSetsPaginator(ListLogPatternSetsRequest listLogPatternSetsRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ApplicationInsightsException {
        return new ListLogPatternSetsIterable(this, listLogPatternSetsRequest);
    }

    /**
     * <p>
     * Lists the log pattern sets in the specific application.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLogPatternSets(software.amazon.awssdk.services.applicationinsights.model.ListLogPatternSetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationinsights.paginators.ListLogPatternSetsIterable responses = client.listLogPatternSetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.applicationinsights.paginators.ListLogPatternSetsIterable responses = client
     *             .listLogPatternSetsPaginator(request);
     *     for (software.amazon.awssdk.services.applicationinsights.model.ListLogPatternSetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationinsights.paginators.ListLogPatternSetsIterable responses = client.listLogPatternSetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLogPatternSets(software.amazon.awssdk.services.applicationinsights.model.ListLogPatternSetsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLogPatternSetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListLogPatternSetsRequest#builder()}
     * </p>
     *
     * @param listLogPatternSetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationinsights.model.ListLogPatternSetsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.ListLogPatternSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListLogPatternSets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLogPatternSetsIterable listLogPatternSetsPaginator(
            Consumer<ListLogPatternSetsRequest.Builder> listLogPatternSetsRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, ApplicationInsightsException {
        return listLogPatternSetsPaginator(ListLogPatternSetsRequest.builder().applyMutation(listLogPatternSetsRequest).build());
    }

    /**
     * <p>
     * Lists the log patterns in the specific log <code>LogPatternSet</code>.
     * </p>
     *
     * @param listLogPatternsRequest
     * @return Result of the ListLogPatterns operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.ListLogPatterns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListLogPatterns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLogPatternsResponse listLogPatterns(ListLogPatternsRequest listLogPatternsRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ApplicationInsightsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the log patterns in the specific log <code>LogPatternSet</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLogPatternsRequest.Builder} avoiding the need
     * to create one manually via {@link ListLogPatternsRequest#builder()}
     * </p>
     *
     * @param listLogPatternsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationinsights.model.ListLogPatternsRequest.Builder} to create
     *        a request.
     * @return Result of the ListLogPatterns operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.ListLogPatterns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListLogPatterns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLogPatternsResponse listLogPatterns(Consumer<ListLogPatternsRequest.Builder> listLogPatternsRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ApplicationInsightsException {
        return listLogPatterns(ListLogPatternsRequest.builder().applyMutation(listLogPatternsRequest).build());
    }

    /**
     * <p>
     * Lists the log patterns in the specific log <code>LogPatternSet</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLogPatterns(software.amazon.awssdk.services.applicationinsights.model.ListLogPatternsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationinsights.paginators.ListLogPatternsIterable responses = client.listLogPatternsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.applicationinsights.paginators.ListLogPatternsIterable responses = client
     *             .listLogPatternsPaginator(request);
     *     for (software.amazon.awssdk.services.applicationinsights.model.ListLogPatternsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationinsights.paginators.ListLogPatternsIterable responses = client.listLogPatternsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLogPatterns(software.amazon.awssdk.services.applicationinsights.model.ListLogPatternsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLogPatternsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.ListLogPatterns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListLogPatterns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLogPatternsIterable listLogPatternsPaginator(ListLogPatternsRequest listLogPatternsRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ApplicationInsightsException {
        return new ListLogPatternsIterable(this, listLogPatternsRequest);
    }

    /**
     * <p>
     * Lists the log patterns in the specific log <code>LogPatternSet</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLogPatterns(software.amazon.awssdk.services.applicationinsights.model.ListLogPatternsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationinsights.paginators.ListLogPatternsIterable responses = client.listLogPatternsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.applicationinsights.paginators.ListLogPatternsIterable responses = client
     *             .listLogPatternsPaginator(request);
     *     for (software.amazon.awssdk.services.applicationinsights.model.ListLogPatternsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationinsights.paginators.ListLogPatternsIterable responses = client.listLogPatternsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLogPatterns(software.amazon.awssdk.services.applicationinsights.model.ListLogPatternsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLogPatternsRequest.Builder} avoiding the need
     * to create one manually via {@link ListLogPatternsRequest#builder()}
     * </p>
     *
     * @param listLogPatternsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationinsights.model.ListLogPatternsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.ListLogPatterns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListLogPatterns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLogPatternsIterable listLogPatternsPaginator(Consumer<ListLogPatternsRequest.Builder> listLogPatternsRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ApplicationInsightsException {
        return listLogPatternsPaginator(ListLogPatternsRequest.builder().applyMutation(listLogPatternsRequest).build());
    }

    /**
     * <p>
     * Lists the problems with your application.
     * </p>
     *
     * @param listProblemsRequest
     * @return Result of the ListProblems operation returned by the service.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.ListProblems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListProblems"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProblemsResponse listProblems(ListProblemsRequest listProblemsRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            ApplicationInsightsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the problems with your application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProblemsRequest.Builder} avoiding the need to
     * create one manually via {@link ListProblemsRequest#builder()}
     * </p>
     *
     * @param listProblemsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationinsights.model.ListProblemsRequest.Builder} to create a
     *        request.
     * @return Result of the ListProblems operation returned by the service.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.ListProblems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListProblems"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProblemsResponse listProblems(Consumer<ListProblemsRequest.Builder> listProblemsRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ApplicationInsightsException {
        return listProblems(ListProblemsRequest.builder().applyMutation(listProblemsRequest).build());
    }

    /**
     * <p>
     * Lists the problems with your application.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProblems(software.amazon.awssdk.services.applicationinsights.model.ListProblemsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationinsights.paginators.ListProblemsIterable responses = client.listProblemsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.applicationinsights.paginators.ListProblemsIterable responses = client
     *             .listProblemsPaginator(request);
     *     for (software.amazon.awssdk.services.applicationinsights.model.ListProblemsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationinsights.paginators.ListProblemsIterable responses = client.listProblemsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProblems(software.amazon.awssdk.services.applicationinsights.model.ListProblemsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProblemsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.ListProblems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListProblems"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProblemsIterable listProblemsPaginator(ListProblemsRequest listProblemsRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            ApplicationInsightsException {
        return new ListProblemsIterable(this, listProblemsRequest);
    }

    /**
     * <p>
     * Lists the problems with your application.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProblems(software.amazon.awssdk.services.applicationinsights.model.ListProblemsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationinsights.paginators.ListProblemsIterable responses = client.listProblemsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.applicationinsights.paginators.ListProblemsIterable responses = client
     *             .listProblemsPaginator(request);
     *     for (software.amazon.awssdk.services.applicationinsights.model.ListProblemsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationinsights.paginators.ListProblemsIterable responses = client.listProblemsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProblems(software.amazon.awssdk.services.applicationinsights.model.ListProblemsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProblemsRequest.Builder} avoiding the need to
     * create one manually via {@link ListProblemsRequest#builder()}
     * </p>
     *
     * @param listProblemsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationinsights.model.ListProblemsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.ListProblems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListProblems"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProblemsIterable listProblemsPaginator(Consumer<ListProblemsRequest.Builder> listProblemsRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ApplicationInsightsException {
        return listProblemsPaginator(ListProblemsRequest.builder().applyMutation(listProblemsRequest).build());
    }

    /**
     * <p>
     * Retrieve a list of the tags (keys and values) that are associated with a specified application. A <i>tag</i> is a
     * label that you optionally define and associate with an application. Each tag consists of a required <i>tag
     * key</i> and an optional associated <i>tag value</i>. A tag key is a general label that acts as a category for
     * more specific tag values. A tag value acts as a descriptor within a tag key.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            ApplicationInsightsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve a list of the tags (keys and values) that are associated with a specified application. A <i>tag</i> is a
     * label that you optionally define and associate with an application. Each tag consists of a required <i>tag
     * key</i> and an optional associated <i>tag value</i>. A tag key is a general label that acts as a category for
     * more specific tag values. A tag value acts as a descriptor within a tag key.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationinsights.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            ValidationException, AwsServiceException, SdkClientException, ApplicationInsightsException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists the workloads that are configured on a given component.
     * </p>
     *
     * @param listWorkloadsRequest
     * @return Result of the ListWorkloads operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.ListWorkloads
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListWorkloads"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkloadsResponse listWorkloads(ListWorkloadsRequest listWorkloadsRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, ApplicationInsightsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the workloads that are configured on a given component.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkloadsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkloadsRequest#builder()}
     * </p>
     *
     * @param listWorkloadsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationinsights.model.ListWorkloadsRequest.Builder} to create a
     *        request.
     * @return Result of the ListWorkloads operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.ListWorkloads
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListWorkloads"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkloadsResponse listWorkloads(Consumer<ListWorkloadsRequest.Builder> listWorkloadsRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ApplicationInsightsException {
        return listWorkloads(ListWorkloadsRequest.builder().applyMutation(listWorkloadsRequest).build());
    }

    /**
     * <p>
     * Lists the workloads that are configured on a given component.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorkloads(software.amazon.awssdk.services.applicationinsights.model.ListWorkloadsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationinsights.paginators.ListWorkloadsIterable responses = client.listWorkloadsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.applicationinsights.paginators.ListWorkloadsIterable responses = client
     *             .listWorkloadsPaginator(request);
     *     for (software.amazon.awssdk.services.applicationinsights.model.ListWorkloadsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationinsights.paginators.ListWorkloadsIterable responses = client.listWorkloadsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkloads(software.amazon.awssdk.services.applicationinsights.model.ListWorkloadsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWorkloadsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.ListWorkloads
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListWorkloads"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkloadsIterable listWorkloadsPaginator(ListWorkloadsRequest listWorkloadsRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ApplicationInsightsException {
        return new ListWorkloadsIterable(this, listWorkloadsRequest);
    }

    /**
     * <p>
     * Lists the workloads that are configured on a given component.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorkloads(software.amazon.awssdk.services.applicationinsights.model.ListWorkloadsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationinsights.paginators.ListWorkloadsIterable responses = client.listWorkloadsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.applicationinsights.paginators.ListWorkloadsIterable responses = client
     *             .listWorkloadsPaginator(request);
     *     for (software.amazon.awssdk.services.applicationinsights.model.ListWorkloadsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationinsights.paginators.ListWorkloadsIterable responses = client.listWorkloadsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkloads(software.amazon.awssdk.services.applicationinsights.model.ListWorkloadsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkloadsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkloadsRequest#builder()}
     * </p>
     *
     * @param listWorkloadsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationinsights.model.ListWorkloadsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.ListWorkloads
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListWorkloads"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkloadsIterable listWorkloadsPaginator(Consumer<ListWorkloadsRequest.Builder> listWorkloadsRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ApplicationInsightsException {
        return listWorkloadsPaginator(ListWorkloadsRequest.builder().applyMutation(listWorkloadsRequest).build());
    }

    /**
     * <p>
     * Remove workload from a component.
     * </p>
     *
     * @param removeWorkloadRequest
     * @return Result of the RemoveWorkload operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.RemoveWorkload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/RemoveWorkload"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveWorkloadResponse removeWorkload(RemoveWorkloadRequest removeWorkloadRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, ApplicationInsightsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove workload from a component.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveWorkloadRequest.Builder} avoiding the need to
     * create one manually via {@link RemoveWorkloadRequest#builder()}
     * </p>
     *
     * @param removeWorkloadRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationinsights.model.RemoveWorkloadRequest.Builder} to create
     *        a request.
     * @return Result of the RemoveWorkload operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.RemoveWorkload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/RemoveWorkload"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveWorkloadResponse removeWorkload(Consumer<RemoveWorkloadRequest.Builder> removeWorkloadRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ApplicationInsightsException {
        return removeWorkload(RemoveWorkloadRequest.builder().applyMutation(removeWorkloadRequest).build());
    }

    /**
     * <p>
     * Add one or more tags (keys and values) to a specified application. A <i>tag</i> is a label that you optionally
     * define and associate with an application. Tags can help you categorize and manage application in different ways,
     * such as by purpose, owner, environment, or other criteria.
     * </p>
     * <p>
     * Each tag consists of a required <i>tag key</i> and an associated <i>tag value</i>, both of which you define. A
     * tag key is a general label that acts as a category for more specific tag values. A tag value acts as a descriptor
     * within a tag key.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws TooManyTagsException
     *         The number of the provided tags is beyond the limit, or the number of total tags you are trying to attach
     *         to the specified resource exceeds the limit.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            TooManyTagsException, ValidationException, AwsServiceException, SdkClientException, ApplicationInsightsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add one or more tags (keys and values) to a specified application. A <i>tag</i> is a label that you optionally
     * define and associate with an application. Tags can help you categorize and manage application in different ways,
     * such as by purpose, owner, environment, or other criteria.
     * </p>
     * <p>
     * Each tag consists of a required <i>tag key</i> and an associated <i>tag value</i>, both of which you define. A
     * tag key is a general label that acts as a category for more specific tag values. A tag value acts as a descriptor
     * within a tag key.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationinsights.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws TooManyTagsException
     *         The number of the provided tags is beyond the limit, or the number of total tags you are trying to attach
     *         to the specified resource exceeds the limit.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ResourceNotFoundException, TooManyTagsException, ValidationException, AwsServiceException, SdkClientException,
            ApplicationInsightsException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Remove one or more tags (keys and values) from a specified application.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            ValidationException, AwsServiceException, SdkClientException, ApplicationInsightsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove one or more tags (keys and values) from a specified application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationinsights.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            ApplicationInsightsException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the application.
     * </p>
     *
     * @param updateApplicationRequest
     * @return Result of the UpdateApplication operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/UpdateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateApplicationResponse updateApplication(UpdateApplicationRequest updateApplicationRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, ApplicationInsightsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateApplicationRequest#builder()}
     * </p>
     *
     * @param updateApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationinsights.model.UpdateApplicationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateApplication operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/UpdateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateApplicationResponse updateApplication(Consumer<UpdateApplicationRequest.Builder> updateApplicationRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, ApplicationInsightsException {
        return updateApplication(UpdateApplicationRequest.builder().applyMutation(updateApplicationRequest).build());
    }

    /**
     * <p>
     * Updates the custom component name and/or the list of resources that make up the component.
     * </p>
     *
     * @param updateComponentRequest
     * @return Result of the UpdateComponent operation returned by the service.
     * @throws ResourceInUseException
     *         The resource is already created or in use.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.UpdateComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/UpdateComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateComponentResponse updateComponent(UpdateComponentRequest updateComponentRequest) throws ResourceInUseException,
            ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            ApplicationInsightsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the custom component name and/or the list of resources that make up the component.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateComponentRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateComponentRequest#builder()}
     * </p>
     *
     * @param updateComponentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationinsights.model.UpdateComponentRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateComponent operation returned by the service.
     * @throws ResourceInUseException
     *         The resource is already created or in use.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.UpdateComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/UpdateComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateComponentResponse updateComponent(Consumer<UpdateComponentRequest.Builder> updateComponentRequest)
            throws ResourceInUseException, ResourceNotFoundException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, ApplicationInsightsException {
        return updateComponent(UpdateComponentRequest.builder().applyMutation(updateComponentRequest).build());
    }

    /**
     * <p>
     * Updates the monitoring configurations for the component. The configuration input parameter is an escaped JSON of
     * the configuration and should match the schema of what is returned by
     * <code>DescribeComponentConfigurationRecommendation</code>.
     * </p>
     *
     * @param updateComponentConfigurationRequest
     * @return Result of the UpdateComponentConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.UpdateComponentConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/UpdateComponentConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateComponentConfigurationResponse updateComponentConfiguration(
            UpdateComponentConfigurationRequest updateComponentConfigurationRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, ApplicationInsightsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the monitoring configurations for the component. The configuration input parameter is an escaped JSON of
     * the configuration and should match the schema of what is returned by
     * <code>DescribeComponentConfigurationRecommendation</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateComponentConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateComponentConfigurationRequest#builder()}
     * </p>
     *
     * @param updateComponentConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationinsights.model.UpdateComponentConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateComponentConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.UpdateComponentConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/UpdateComponentConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateComponentConfigurationResponse updateComponentConfiguration(
            Consumer<UpdateComponentConfigurationRequest.Builder> updateComponentConfigurationRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ApplicationInsightsException {
        return updateComponentConfiguration(UpdateComponentConfigurationRequest.builder()
                .applyMutation(updateComponentConfigurationRequest).build());
    }

    /**
     * <p>
     * Adds a log pattern to a <code>LogPatternSet</code>.
     * </p>
     *
     * @param updateLogPatternRequest
     * @return Result of the UpdateLogPattern operation returned by the service.
     * @throws ResourceInUseException
     *         The resource is already created or in use.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.UpdateLogPattern
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/UpdateLogPattern"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLogPatternResponse updateLogPattern(UpdateLogPatternRequest updateLogPatternRequest)
            throws ResourceInUseException, ResourceNotFoundException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, ApplicationInsightsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a log pattern to a <code>LogPatternSet</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLogPatternRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateLogPatternRequest#builder()}
     * </p>
     *
     * @param updateLogPatternRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationinsights.model.UpdateLogPatternRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateLogPattern operation returned by the service.
     * @throws ResourceInUseException
     *         The resource is already created or in use.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.UpdateLogPattern
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/UpdateLogPattern"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLogPatternResponse updateLogPattern(Consumer<UpdateLogPatternRequest.Builder> updateLogPatternRequest)
            throws ResourceInUseException, ResourceNotFoundException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, ApplicationInsightsException {
        return updateLogPattern(UpdateLogPatternRequest.builder().applyMutation(updateLogPatternRequest).build());
    }

    /**
     * <p>
     * Updates the visibility of the problem or specifies the problem as <code>RESOLVED</code>.
     * </p>
     *
     * @param updateProblemRequest
     * @return Result of the UpdateProblem operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.UpdateProblem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/UpdateProblem"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateProblemResponse updateProblem(UpdateProblemRequest updateProblemRequest) throws InternalServerException,
            ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, ApplicationInsightsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the visibility of the problem or specifies the problem as <code>RESOLVED</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProblemRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateProblemRequest#builder()}
     * </p>
     *
     * @param updateProblemRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationinsights.model.UpdateProblemRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateProblem operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.UpdateProblem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/UpdateProblem"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateProblemResponse updateProblem(Consumer<UpdateProblemRequest.Builder> updateProblemRequest)
            throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ApplicationInsightsException {
        return updateProblem(UpdateProblemRequest.builder().applyMutation(updateProblemRequest).build());
    }

    /**
     * <p>
     * Adds a workload to a component. Each component can have at most five workloads.
     * </p>
     *
     * @param updateWorkloadRequest
     * @return Result of the UpdateWorkload operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.UpdateWorkload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/UpdateWorkload"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateWorkloadResponse updateWorkload(UpdateWorkloadRequest updateWorkloadRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, ApplicationInsightsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a workload to a component. Each component can have at most five workloads.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorkloadRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateWorkloadRequest#builder()}
     * </p>
     *
     * @param updateWorkloadRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationinsights.model.UpdateWorkloadRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateWorkload operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource does not exist in the customer account.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationInsightsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationInsightsClient.UpdateWorkload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/UpdateWorkload"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateWorkloadResponse updateWorkload(Consumer<UpdateWorkloadRequest.Builder> updateWorkloadRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ApplicationInsightsException {
        return updateWorkload(UpdateWorkloadRequest.builder().applyMutation(updateWorkloadRequest).build());
    }

    /**
     * Create a {@link ApplicationInsightsClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ApplicationInsightsClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ApplicationInsightsClient}.
     */
    static ApplicationInsightsClientBuilder builder() {
        return new DefaultApplicationInsightsClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default ApplicationInsightsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
