/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appmesh.AppMeshClient;
import software.amazon.awssdk.services.appmesh.internal.UserAgentUtils;
import software.amazon.awssdk.services.appmesh.model.ListVirtualRoutersRequest;
import software.amazon.awssdk.services.appmesh.model.ListVirtualRoutersResponse;
import software.amazon.awssdk.services.appmesh.model.VirtualRouterRef;

public class ListVirtualRoutersIterable
implements SdkIterable<ListVirtualRoutersResponse> {
    private final AppMeshClient client;
    private final ListVirtualRoutersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListVirtualRoutersIterable(AppMeshClient client, ListVirtualRoutersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListVirtualRoutersResponseFetcher();
    }

    public Iterator<ListVirtualRoutersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<VirtualRouterRef> virtualRouters() {
        Function<ListVirtualRoutersResponse, Iterator> getIterator = response -> {
            if (response != null && response.virtualRouters() != null) {
                return response.virtualRouters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListVirtualRoutersResponseFetcher
    implements SyncPageFetcher<ListVirtualRoutersResponse> {
        private ListVirtualRoutersResponseFetcher() {
        }

        public boolean hasNextPage(ListVirtualRoutersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListVirtualRoutersResponse nextPage(ListVirtualRoutersResponse previousPage) {
            if (previousPage == null) {
                return ListVirtualRoutersIterable.this.client.listVirtualRouters(ListVirtualRoutersIterable.this.firstRequest);
            }
            return ListVirtualRoutersIterable.this.client.listVirtualRouters((ListVirtualRoutersRequest)((Object)ListVirtualRoutersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

