/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appmesh.model.Duration;
import software.amazon.awssdk.services.appmesh.model.GrpcRetryPolicyEvent;
import software.amazon.awssdk.services.appmesh.model.GrpcRetryPolicyEventsCopier;
import software.amazon.awssdk.services.appmesh.model.HttpRetryPolicyEventsCopier;
import software.amazon.awssdk.services.appmesh.model.TcpRetryPolicyEvent;
import software.amazon.awssdk.services.appmesh.model.TcpRetryPolicyEventsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GrpcRetryPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GrpcRetryPolicy> {
    private static final SdkField<List<String>> GRPC_RETRY_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("grpcRetryEvents").getter(GrpcRetryPolicy.getter(GrpcRetryPolicy::grpcRetryEventsAsStrings)).setter(GrpcRetryPolicy.setter(Builder::grpcRetryEventsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grpcRetryEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> HTTP_RETRY_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("httpRetryEvents").getter(GrpcRetryPolicy.getter(GrpcRetryPolicy::httpRetryEvents)).setter(GrpcRetryPolicy.setter(Builder::httpRetryEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpRetryEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> MAX_RETRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("maxRetries").getter(GrpcRetryPolicy.getter(GrpcRetryPolicy::maxRetries)).setter(GrpcRetryPolicy.setter(Builder::maxRetries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxRetries").build()}).build();
    private static final SdkField<Duration> PER_RETRY_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("perRetryTimeout").getter(GrpcRetryPolicy.getter(GrpcRetryPolicy::perRetryTimeout)).setter(GrpcRetryPolicy.setter(Builder::perRetryTimeout)).constructor(Duration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("perRetryTimeout").build()}).build();
    private static final SdkField<List<String>> TCP_RETRY_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tcpRetryEvents").getter(GrpcRetryPolicy.getter(GrpcRetryPolicy::tcpRetryEventsAsStrings)).setter(GrpcRetryPolicy.setter(Builder::tcpRetryEventsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tcpRetryEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRPC_RETRY_EVENTS_FIELD, HTTP_RETRY_EVENTS_FIELD, MAX_RETRIES_FIELD, PER_RETRY_TIMEOUT_FIELD, TCP_RETRY_EVENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GrpcRetryPolicy.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> grpcRetryEvents;
    private final List<String> httpRetryEvents;
    private final Long maxRetries;
    private final Duration perRetryTimeout;
    private final List<String> tcpRetryEvents;

    private GrpcRetryPolicy(BuilderImpl builder) {
        this.grpcRetryEvents = builder.grpcRetryEvents;
        this.httpRetryEvents = builder.httpRetryEvents;
        this.maxRetries = builder.maxRetries;
        this.perRetryTimeout = builder.perRetryTimeout;
        this.tcpRetryEvents = builder.tcpRetryEvents;
    }

    public final List<GrpcRetryPolicyEvent> grpcRetryEvents() {
        return GrpcRetryPolicyEventsCopier.copyStringToEnum(this.grpcRetryEvents);
    }

    public final boolean hasGrpcRetryEvents() {
        return this.grpcRetryEvents != null && !(this.grpcRetryEvents instanceof SdkAutoConstructList);
    }

    public final List<String> grpcRetryEventsAsStrings() {
        return this.grpcRetryEvents;
    }

    public final boolean hasHttpRetryEvents() {
        return this.httpRetryEvents != null && !(this.httpRetryEvents instanceof SdkAutoConstructList);
    }

    public final List<String> httpRetryEvents() {
        return this.httpRetryEvents;
    }

    public final Long maxRetries() {
        return this.maxRetries;
    }

    public final Duration perRetryTimeout() {
        return this.perRetryTimeout;
    }

    public final List<TcpRetryPolicyEvent> tcpRetryEvents() {
        return TcpRetryPolicyEventsCopier.copyStringToEnum(this.tcpRetryEvents);
    }

    public final boolean hasTcpRetryEvents() {
        return this.tcpRetryEvents != null && !(this.tcpRetryEvents instanceof SdkAutoConstructList);
    }

    public final List<String> tcpRetryEventsAsStrings() {
        return this.tcpRetryEvents;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGrpcRetryEvents() ? this.grpcRetryEventsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHttpRetryEvents() ? this.httpRetryEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRetries());
        hashCode = 31 * hashCode + Objects.hashCode(this.perRetryTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTcpRetryEvents() ? this.tcpRetryEventsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrpcRetryPolicy)) {
            return false;
        }
        GrpcRetryPolicy other = (GrpcRetryPolicy)obj;
        return this.hasGrpcRetryEvents() == other.hasGrpcRetryEvents() && Objects.equals(this.grpcRetryEventsAsStrings(), other.grpcRetryEventsAsStrings()) && this.hasHttpRetryEvents() == other.hasHttpRetryEvents() && Objects.equals(this.httpRetryEvents(), other.httpRetryEvents()) && Objects.equals(this.maxRetries(), other.maxRetries()) && Objects.equals(this.perRetryTimeout(), other.perRetryTimeout()) && this.hasTcpRetryEvents() == other.hasTcpRetryEvents() && Objects.equals(this.tcpRetryEventsAsStrings(), other.tcpRetryEventsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"GrpcRetryPolicy").add("GrpcRetryEvents", this.hasGrpcRetryEvents() ? this.grpcRetryEventsAsStrings() : null).add("HttpRetryEvents", this.hasHttpRetryEvents() ? this.httpRetryEvents() : null).add("MaxRetries", (Object)this.maxRetries()).add("PerRetryTimeout", (Object)this.perRetryTimeout()).add("TcpRetryEvents", this.hasTcpRetryEvents() ? this.tcpRetryEventsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "grpcRetryEvents": {
                return Optional.ofNullable(clazz.cast(this.grpcRetryEventsAsStrings()));
            }
            case "httpRetryEvents": {
                return Optional.ofNullable(clazz.cast(this.httpRetryEvents()));
            }
            case "maxRetries": {
                return Optional.ofNullable(clazz.cast(this.maxRetries()));
            }
            case "perRetryTimeout": {
                return Optional.ofNullable(clazz.cast(this.perRetryTimeout()));
            }
            case "tcpRetryEvents": {
                return Optional.ofNullable(clazz.cast(this.tcpRetryEventsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("grpcRetryEvents", GRPC_RETRY_EVENTS_FIELD);
        map.put("httpRetryEvents", HTTP_RETRY_EVENTS_FIELD);
        map.put("maxRetries", MAX_RETRIES_FIELD);
        map.put("perRetryTimeout", PER_RETRY_TIMEOUT_FIELD);
        map.put("tcpRetryEvents", TCP_RETRY_EVENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GrpcRetryPolicy, T> g) {
        return obj -> g.apply((GrpcRetryPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> grpcRetryEvents = DefaultSdkAutoConstructList.getInstance();
        private List<String> httpRetryEvents = DefaultSdkAutoConstructList.getInstance();
        private Long maxRetries;
        private Duration perRetryTimeout;
        private List<String> tcpRetryEvents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GrpcRetryPolicy model) {
            this.grpcRetryEventsWithStrings(model.grpcRetryEvents);
            this.httpRetryEvents(model.httpRetryEvents);
            this.maxRetries(model.maxRetries);
            this.perRetryTimeout(model.perRetryTimeout);
            this.tcpRetryEventsWithStrings(model.tcpRetryEvents);
        }

        public final Collection<String> getGrpcRetryEvents() {
            if (this.grpcRetryEvents instanceof SdkAutoConstructList) {
                return null;
            }
            return this.grpcRetryEvents;
        }

        public final void setGrpcRetryEvents(Collection<String> grpcRetryEvents) {
            this.grpcRetryEvents = GrpcRetryPolicyEventsCopier.copy(grpcRetryEvents);
        }

        @Override
        public final Builder grpcRetryEventsWithStrings(Collection<String> grpcRetryEvents) {
            this.grpcRetryEvents = GrpcRetryPolicyEventsCopier.copy(grpcRetryEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grpcRetryEventsWithStrings(String ... grpcRetryEvents) {
            this.grpcRetryEventsWithStrings(Arrays.asList(grpcRetryEvents));
            return this;
        }

        @Override
        public final Builder grpcRetryEvents(Collection<GrpcRetryPolicyEvent> grpcRetryEvents) {
            this.grpcRetryEvents = GrpcRetryPolicyEventsCopier.copyEnumToString(grpcRetryEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grpcRetryEvents(GrpcRetryPolicyEvent ... grpcRetryEvents) {
            this.grpcRetryEvents(Arrays.asList(grpcRetryEvents));
            return this;
        }

        public final Collection<String> getHttpRetryEvents() {
            if (this.httpRetryEvents instanceof SdkAutoConstructList) {
                return null;
            }
            return this.httpRetryEvents;
        }

        public final void setHttpRetryEvents(Collection<String> httpRetryEvents) {
            this.httpRetryEvents = HttpRetryPolicyEventsCopier.copy(httpRetryEvents);
        }

        @Override
        public final Builder httpRetryEvents(Collection<String> httpRetryEvents) {
            this.httpRetryEvents = HttpRetryPolicyEventsCopier.copy(httpRetryEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder httpRetryEvents(String ... httpRetryEvents) {
            this.httpRetryEvents(Arrays.asList(httpRetryEvents));
            return this;
        }

        public final Long getMaxRetries() {
            return this.maxRetries;
        }

        public final void setMaxRetries(Long maxRetries) {
            this.maxRetries = maxRetries;
        }

        @Override
        public final Builder maxRetries(Long maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public final Duration.Builder getPerRetryTimeout() {
            return this.perRetryTimeout != null ? this.perRetryTimeout.toBuilder() : null;
        }

        public final void setPerRetryTimeout(Duration.BuilderImpl perRetryTimeout) {
            this.perRetryTimeout = perRetryTimeout != null ? perRetryTimeout.build() : null;
        }

        @Override
        public final Builder perRetryTimeout(Duration perRetryTimeout) {
            this.perRetryTimeout = perRetryTimeout;
            return this;
        }

        public final Collection<String> getTcpRetryEvents() {
            if (this.tcpRetryEvents instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tcpRetryEvents;
        }

        public final void setTcpRetryEvents(Collection<String> tcpRetryEvents) {
            this.tcpRetryEvents = TcpRetryPolicyEventsCopier.copy(tcpRetryEvents);
        }

        @Override
        public final Builder tcpRetryEventsWithStrings(Collection<String> tcpRetryEvents) {
            this.tcpRetryEvents = TcpRetryPolicyEventsCopier.copy(tcpRetryEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tcpRetryEventsWithStrings(String ... tcpRetryEvents) {
            this.tcpRetryEventsWithStrings(Arrays.asList(tcpRetryEvents));
            return this;
        }

        @Override
        public final Builder tcpRetryEvents(Collection<TcpRetryPolicyEvent> tcpRetryEvents) {
            this.tcpRetryEvents = TcpRetryPolicyEventsCopier.copyEnumToString(tcpRetryEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tcpRetryEvents(TcpRetryPolicyEvent ... tcpRetryEvents) {
            this.tcpRetryEvents(Arrays.asList(tcpRetryEvents));
            return this;
        }

        public GrpcRetryPolicy build() {
            return new GrpcRetryPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GrpcRetryPolicy> {
        public Builder grpcRetryEventsWithStrings(Collection<String> var1);

        public Builder grpcRetryEventsWithStrings(String ... var1);

        public Builder grpcRetryEvents(Collection<GrpcRetryPolicyEvent> var1);

        public Builder grpcRetryEvents(GrpcRetryPolicyEvent ... var1);

        public Builder httpRetryEvents(Collection<String> var1);

        public Builder httpRetryEvents(String ... var1);

        public Builder maxRetries(Long var1);

        public Builder perRetryTimeout(Duration var1);

        default public Builder perRetryTimeout(Consumer<Duration.Builder> perRetryTimeout) {
            return this.perRetryTimeout((Duration)((Duration.Builder)Duration.builder().applyMutation(perRetryTimeout)).build());
        }

        public Builder tcpRetryEventsWithStrings(Collection<String> var1);

        public Builder tcpRetryEventsWithStrings(String ... var1);

        public Builder tcpRetryEvents(Collection<TcpRetryPolicyEvent> var1);

        public Builder tcpRetryEvents(TcpRetryPolicyEvent ... var1);
    }
}

