/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Runtime {
    PYTHON_3("PYTHON_3"),
    NODEJS_12("NODEJS_12"),
    NODEJS_14("NODEJS_14"),
    CORRETTO_8("CORRETTO_8"),
    CORRETTO_11("CORRETTO_11"),
    NODEJS_16("NODEJS_16"),
    GO_1("GO_1"),
    DOTNET_6("DOTNET_6"),
    PHP_81("PHP_81"),
    RUBY_31("RUBY_31"),
    PYTHON_311("PYTHON_311"),
    NODEJS_18("NODEJS_18"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Runtime> VALUE_MAP;
    private final String value;

    private Runtime(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Runtime fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Runtime> knownValues() {
        EnumSet<Runtime> knownValues = EnumSet.allOf(Runtime.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Runtime.class, Runtime::toString);
    }
}

