/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum VisibilityType {
    PUBLIC("PUBLIC"),
    PRIVATE("PRIVATE"),
    SHARED("SHARED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, VisibilityType> VALUE_MAP;
    private final String value;

    private VisibilityType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VisibilityType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VisibilityType> knownValues() {
        EnumSet<VisibilityType> knownValues = EnumSet.allOf(VisibilityType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(VisibilityType.class, VisibilityType::toString);
    }
}

