/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appstream.model.AppBlockState;
import software.amazon.awssdk.services.appstream.model.ErrorDetails;
import software.amazon.awssdk.services.appstream.model.ErrorDetailsListCopier;
import software.amazon.awssdk.services.appstream.model.PackagingType;
import software.amazon.awssdk.services.appstream.model.S3Location;
import software.amazon.awssdk.services.appstream.model.ScriptDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AppBlock
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AppBlock> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AppBlock.getter(AppBlock::name)).setter(AppBlock.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(AppBlock.getter(AppBlock::arn)).setter(AppBlock.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(AppBlock.getter(AppBlock::description)).setter(AppBlock.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(AppBlock.getter(AppBlock::displayName)).setter(AppBlock.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<S3Location> SOURCE_S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceS3Location").getter(AppBlock.getter(AppBlock::sourceS3Location)).setter(AppBlock.setter(Builder::sourceS3Location)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceS3Location").build()}).build();
    private static final SdkField<ScriptDetails> SETUP_SCRIPT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SetupScriptDetails").getter(AppBlock.getter(AppBlock::setupScriptDetails)).setter(AppBlock.setter(Builder::setupScriptDetails)).constructor(ScriptDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SetupScriptDetails").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(AppBlock.getter(AppBlock::createdTime)).setter(AppBlock.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<ScriptDetails> POST_SETUP_SCRIPT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PostSetupScriptDetails").getter(AppBlock.getter(AppBlock::postSetupScriptDetails)).setter(AppBlock.setter(Builder::postSetupScriptDetails)).constructor(ScriptDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostSetupScriptDetails").build()}).build();
    private static final SdkField<String> PACKAGING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackagingType").getter(AppBlock.getter(AppBlock::packagingTypeAsString)).setter(AppBlock.setter(Builder::packagingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackagingType").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(AppBlock.getter(AppBlock::stateAsString)).setter(AppBlock.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<List<ErrorDetails>> APP_BLOCK_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AppBlockErrors").getter(AppBlock.getter(AppBlock::appBlockErrors)).setter(AppBlock.setter(Builder::appBlockErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppBlockErrors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ErrorDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, SOURCE_S3_LOCATION_FIELD, SETUP_SCRIPT_DETAILS_FIELD, CREATED_TIME_FIELD, POST_SETUP_SCRIPT_DETAILS_FIELD, PACKAGING_TYPE_FIELD, STATE_FIELD, APP_BLOCK_ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AppBlock.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final String description;
    private final String displayName;
    private final S3Location sourceS3Location;
    private final ScriptDetails setupScriptDetails;
    private final Instant createdTime;
    private final ScriptDetails postSetupScriptDetails;
    private final String packagingType;
    private final String state;
    private final List<ErrorDetails> appBlockErrors;

    private AppBlock(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.sourceS3Location = builder.sourceS3Location;
        this.setupScriptDetails = builder.setupScriptDetails;
        this.createdTime = builder.createdTime;
        this.postSetupScriptDetails = builder.postSetupScriptDetails;
        this.packagingType = builder.packagingType;
        this.state = builder.state;
        this.appBlockErrors = builder.appBlockErrors;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final String description() {
        return this.description;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final S3Location sourceS3Location() {
        return this.sourceS3Location;
    }

    public final ScriptDetails setupScriptDetails() {
        return this.setupScriptDetails;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final ScriptDetails postSetupScriptDetails() {
        return this.postSetupScriptDetails;
    }

    public final PackagingType packagingType() {
        return PackagingType.fromValue(this.packagingType);
    }

    public final String packagingTypeAsString() {
        return this.packagingType;
    }

    public final AppBlockState state() {
        return AppBlockState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final boolean hasAppBlockErrors() {
        return this.appBlockErrors != null && !(this.appBlockErrors instanceof SdkAutoConstructList);
    }

    public final List<ErrorDetails> appBlockErrors() {
        return this.appBlockErrors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(this.setupScriptDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.postSetupScriptDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.packagingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAppBlockErrors() ? this.appBlockErrors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppBlock)) {
            return false;
        }
        AppBlock other = (AppBlock)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.sourceS3Location(), other.sourceS3Location()) && Objects.equals(this.setupScriptDetails(), other.setupScriptDetails()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.postSetupScriptDetails(), other.postSetupScriptDetails()) && Objects.equals(this.packagingTypeAsString(), other.packagingTypeAsString()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasAppBlockErrors() == other.hasAppBlockErrors() && Objects.equals(this.appBlockErrors(), other.appBlockErrors());
    }

    public final String toString() {
        return ToString.builder((String)"AppBlock").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("Description", (Object)this.description()).add("DisplayName", (Object)this.displayName()).add("SourceS3Location", (Object)this.sourceS3Location()).add("SetupScriptDetails", (Object)this.setupScriptDetails()).add("CreatedTime", (Object)this.createdTime()).add("PostSetupScriptDetails", (Object)this.postSetupScriptDetails()).add("PackagingType", (Object)this.packagingTypeAsString()).add("State", (Object)this.stateAsString()).add("AppBlockErrors", this.hasAppBlockErrors() ? this.appBlockErrors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "SourceS3Location": {
                return Optional.ofNullable(clazz.cast(this.sourceS3Location()));
            }
            case "SetupScriptDetails": {
                return Optional.ofNullable(clazz.cast(this.setupScriptDetails()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "PostSetupScriptDetails": {
                return Optional.ofNullable(clazz.cast(this.postSetupScriptDetails()));
            }
            case "PackagingType": {
                return Optional.ofNullable(clazz.cast(this.packagingTypeAsString()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "AppBlockErrors": {
                return Optional.ofNullable(clazz.cast(this.appBlockErrors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("SourceS3Location", SOURCE_S3_LOCATION_FIELD);
        map.put("SetupScriptDetails", SETUP_SCRIPT_DETAILS_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("PostSetupScriptDetails", POST_SETUP_SCRIPT_DETAILS_FIELD);
        map.put("PackagingType", PACKAGING_TYPE_FIELD);
        map.put("State", STATE_FIELD);
        map.put("AppBlockErrors", APP_BLOCK_ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AppBlock, T> g) {
        return obj -> g.apply((AppBlock)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String description;
        private String displayName;
        private S3Location sourceS3Location;
        private ScriptDetails setupScriptDetails;
        private Instant createdTime;
        private ScriptDetails postSetupScriptDetails;
        private String packagingType;
        private String state;
        private List<ErrorDetails> appBlockErrors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AppBlock model) {
            this.name(model.name);
            this.arn(model.arn);
            this.description(model.description);
            this.displayName(model.displayName);
            this.sourceS3Location(model.sourceS3Location);
            this.setupScriptDetails(model.setupScriptDetails);
            this.createdTime(model.createdTime);
            this.postSetupScriptDetails(model.postSetupScriptDetails);
            this.packagingType(model.packagingType);
            this.state(model.state);
            this.appBlockErrors(model.appBlockErrors);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final S3Location.Builder getSourceS3Location() {
            return this.sourceS3Location != null ? this.sourceS3Location.toBuilder() : null;
        }

        public final void setSourceS3Location(S3Location.BuilderImpl sourceS3Location) {
            this.sourceS3Location = sourceS3Location != null ? sourceS3Location.build() : null;
        }

        @Override
        public final Builder sourceS3Location(S3Location sourceS3Location) {
            this.sourceS3Location = sourceS3Location;
            return this;
        }

        public final ScriptDetails.Builder getSetupScriptDetails() {
            return this.setupScriptDetails != null ? this.setupScriptDetails.toBuilder() : null;
        }

        public final void setSetupScriptDetails(ScriptDetails.BuilderImpl setupScriptDetails) {
            this.setupScriptDetails = setupScriptDetails != null ? setupScriptDetails.build() : null;
        }

        @Override
        @Transient
        public final Builder setupScriptDetails(ScriptDetails setupScriptDetails) {
            this.setupScriptDetails = setupScriptDetails;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final ScriptDetails.Builder getPostSetupScriptDetails() {
            return this.postSetupScriptDetails != null ? this.postSetupScriptDetails.toBuilder() : null;
        }

        public final void setPostSetupScriptDetails(ScriptDetails.BuilderImpl postSetupScriptDetails) {
            this.postSetupScriptDetails = postSetupScriptDetails != null ? postSetupScriptDetails.build() : null;
        }

        @Override
        public final Builder postSetupScriptDetails(ScriptDetails postSetupScriptDetails) {
            this.postSetupScriptDetails = postSetupScriptDetails;
            return this;
        }

        public final String getPackagingType() {
            return this.packagingType;
        }

        public final void setPackagingType(String packagingType) {
            this.packagingType = packagingType;
        }

        @Override
        public final Builder packagingType(String packagingType) {
            this.packagingType = packagingType;
            return this;
        }

        @Override
        public final Builder packagingType(PackagingType packagingType) {
            this.packagingType(packagingType == null ? null : packagingType.toString());
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AppBlockState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final List<ErrorDetails.Builder> getAppBlockErrors() {
            List<ErrorDetails.Builder> result = ErrorDetailsListCopier.copyToBuilder(this.appBlockErrors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppBlockErrors(Collection<ErrorDetails.BuilderImpl> appBlockErrors) {
            this.appBlockErrors = ErrorDetailsListCopier.copyFromBuilder(appBlockErrors);
        }

        @Override
        public final Builder appBlockErrors(Collection<ErrorDetails> appBlockErrors) {
            this.appBlockErrors = ErrorDetailsListCopier.copy(appBlockErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appBlockErrors(ErrorDetails ... appBlockErrors) {
            this.appBlockErrors(Arrays.asList(appBlockErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appBlockErrors(Consumer<ErrorDetails.Builder> ... appBlockErrors) {
            this.appBlockErrors(Stream.of(appBlockErrors).map(c -> (ErrorDetails)((ErrorDetails.Builder)ErrorDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AppBlock build() {
            return new AppBlock(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AppBlock> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder description(String var1);

        public Builder displayName(String var1);

        public Builder sourceS3Location(S3Location var1);

        default public Builder sourceS3Location(Consumer<S3Location.Builder> sourceS3Location) {
            return this.sourceS3Location((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(sourceS3Location)).build());
        }

        public Builder setupScriptDetails(ScriptDetails var1);

        default public Builder setupScriptDetails(Consumer<ScriptDetails.Builder> setupScriptDetails) {
            return this.setupScriptDetails((ScriptDetails)((ScriptDetails.Builder)ScriptDetails.builder().applyMutation(setupScriptDetails)).build());
        }

        public Builder createdTime(Instant var1);

        public Builder postSetupScriptDetails(ScriptDetails var1);

        default public Builder postSetupScriptDetails(Consumer<ScriptDetails.Builder> postSetupScriptDetails) {
            return this.postSetupScriptDetails((ScriptDetails)((ScriptDetails.Builder)ScriptDetails.builder().applyMutation(postSetupScriptDetails)).build());
        }

        public Builder packagingType(String var1);

        public Builder packagingType(PackagingType var1);

        public Builder state(String var1);

        public Builder state(AppBlockState var1);

        public Builder appBlockErrors(Collection<ErrorDetails> var1);

        public Builder appBlockErrors(ErrorDetails ... var1);

        public Builder appBlockErrors(Consumer<ErrorDetails.Builder> ... var1);
    }
}

