/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appstream.model.ErrorDetails;
import software.amazon.awssdk.services.appstream.model.ErrorDetailsListCopier;
import software.amazon.awssdk.services.appstream.model.ExportImageTaskState;
import software.amazon.awssdk.services.appstream.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportImageTask
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportImageTask> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskId").getter(ExportImageTask.getter(ExportImageTask::taskId)).setter(ExportImageTask.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskId").build()}).build();
    private static final SdkField<String> IMAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageArn").getter(ExportImageTask.getter(ExportImageTask::imageArn)).setter(ExportImageTask.setter(Builder::imageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageArn").build()}).build();
    private static final SdkField<String> AMI_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AmiName").getter(ExportImageTask.getter(ExportImageTask::amiName)).setter(ExportImageTask.setter(Builder::amiName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmiName").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedDate").getter(ExportImageTask.getter(ExportImageTask::createdDate)).setter(ExportImageTask.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()}).build();
    private static final SdkField<String> AMI_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AmiDescription").getter(ExportImageTask.getter(ExportImageTask::amiDescription)).setter(ExportImageTask.setter(Builder::amiDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmiDescription").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(ExportImageTask.getter(ExportImageTask::stateAsString)).setter(ExportImageTask.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> AMI_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AmiId").getter(ExportImageTask.getter(ExportImageTask::amiId)).setter(ExportImageTask.setter(Builder::amiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmiId").build()}).build();
    private static final SdkField<Map<String, String>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("TagSpecifications").getter(ExportImageTask.getter(ExportImageTask::tagSpecifications)).setter(ExportImageTask.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecifications").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<ErrorDetails>> ERROR_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ErrorDetails").getter(ExportImageTask.getter(ExportImageTask::errorDetails)).setter(ExportImageTask.setter(Builder::errorDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ErrorDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD, IMAGE_ARN_FIELD, AMI_NAME_FIELD, CREATED_DATE_FIELD, AMI_DESCRIPTION_FIELD, STATE_FIELD, AMI_ID_FIELD, TAG_SPECIFICATIONS_FIELD, ERROR_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExportImageTask.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String taskId;
    private final String imageArn;
    private final String amiName;
    private final Instant createdDate;
    private final String amiDescription;
    private final String state;
    private final String amiId;
    private final Map<String, String> tagSpecifications;
    private final List<ErrorDetails> errorDetails;

    private ExportImageTask(BuilderImpl builder) {
        this.taskId = builder.taskId;
        this.imageArn = builder.imageArn;
        this.amiName = builder.amiName;
        this.createdDate = builder.createdDate;
        this.amiDescription = builder.amiDescription;
        this.state = builder.state;
        this.amiId = builder.amiId;
        this.tagSpecifications = builder.tagSpecifications;
        this.errorDetails = builder.errorDetails;
    }

    public final String taskId() {
        return this.taskId;
    }

    public final String imageArn() {
        return this.imageArn;
    }

    public final String amiName() {
        return this.amiName;
    }

    public final Instant createdDate() {
        return this.createdDate;
    }

    public final String amiDescription() {
        return this.amiDescription;
    }

    public final ExportImageTaskState state() {
        return ExportImageTaskState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String amiId() {
        return this.amiId;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final boolean hasErrorDetails() {
        return this.errorDetails != null && !(this.errorDetails instanceof SdkAutoConstructList);
    }

    public final List<ErrorDetails> errorDetails() {
        return this.errorDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.amiName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.amiDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.amiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrorDetails() ? this.errorDetails() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportImageTask)) {
            return false;
        }
        ExportImageTask other = (ExportImageTask)obj;
        return Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.imageArn(), other.imageArn()) && Objects.equals(this.amiName(), other.amiName()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.amiDescription(), other.amiDescription()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.amiId(), other.amiId()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && this.hasErrorDetails() == other.hasErrorDetails() && Objects.equals(this.errorDetails(), other.errorDetails());
    }

    public final String toString() {
        return ToString.builder((String)"ExportImageTask").add("TaskId", (Object)this.taskId()).add("ImageArn", (Object)this.imageArn()).add("AmiName", (Object)this.amiName()).add("CreatedDate", (Object)this.createdDate()).add("AmiDescription", (Object)this.amiDescription()).add("State", (Object)this.stateAsString()).add("AmiId", (Object)this.amiId()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("ErrorDetails", this.hasErrorDetails() ? this.errorDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TaskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
            case "ImageArn": {
                return Optional.ofNullable(clazz.cast(this.imageArn()));
            }
            case "AmiName": {
                return Optional.ofNullable(clazz.cast(this.amiName()));
            }
            case "CreatedDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "AmiDescription": {
                return Optional.ofNullable(clazz.cast(this.amiDescription()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "AmiId": {
                return Optional.ofNullable(clazz.cast(this.amiId()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "ErrorDetails": {
                return Optional.ofNullable(clazz.cast(this.errorDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TaskId", TASK_ID_FIELD);
        map.put("ImageArn", IMAGE_ARN_FIELD);
        map.put("AmiName", AMI_NAME_FIELD);
        map.put("CreatedDate", CREATED_DATE_FIELD);
        map.put("AmiDescription", AMI_DESCRIPTION_FIELD);
        map.put("State", STATE_FIELD);
        map.put("AmiId", AMI_ID_FIELD);
        map.put("TagSpecifications", TAG_SPECIFICATIONS_FIELD);
        map.put("ErrorDetails", ERROR_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportImageTask, T> g) {
        return obj -> g.apply((ExportImageTask)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String taskId;
        private String imageArn;
        private String amiName;
        private Instant createdDate;
        private String amiDescription;
        private String state;
        private String amiId;
        private Map<String, String> tagSpecifications = DefaultSdkAutoConstructMap.getInstance();
        private List<ErrorDetails> errorDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExportImageTask model) {
            this.taskId(model.taskId);
            this.imageArn(model.imageArn);
            this.amiName(model.amiName);
            this.createdDate(model.createdDate);
            this.amiDescription(model.amiDescription);
            this.state(model.state);
            this.amiId(model.amiId);
            this.tagSpecifications(model.tagSpecifications);
            this.errorDetails(model.errorDetails);
        }

        public final String getTaskId() {
            return this.taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getImageArn() {
            return this.imageArn;
        }

        public final void setImageArn(String imageArn) {
            this.imageArn = imageArn;
        }

        @Override
        public final Builder imageArn(String imageArn) {
            this.imageArn = imageArn;
            return this;
        }

        public final String getAmiName() {
            return this.amiName;
        }

        public final void setAmiName(String amiName) {
            this.amiName = amiName;
        }

        @Override
        public final Builder amiName(String amiName) {
            this.amiName = amiName;
            return this;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final String getAmiDescription() {
            return this.amiDescription;
        }

        public final void setAmiDescription(String amiDescription) {
            this.amiDescription = amiDescription;
        }

        @Override
        public final Builder amiDescription(String amiDescription) {
            this.amiDescription = amiDescription;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ExportImageTaskState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getAmiId() {
            return this.amiId;
        }

        public final void setAmiId(String amiId) {
            this.amiId = amiId;
        }

        @Override
        public final Builder amiId(String amiId) {
            this.amiId = amiId;
            return this;
        }

        public final Map<String, String> getTagSpecifications() {
            if (this.tagSpecifications instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tagSpecifications;
        }

        public final void setTagSpecifications(Map<String, String> tagSpecifications) {
            this.tagSpecifications = TagsCopier.copy(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Map<String, String> tagSpecifications) {
            this.tagSpecifications = TagsCopier.copy(tagSpecifications);
            return this;
        }

        public final List<ErrorDetails.Builder> getErrorDetails() {
            List<ErrorDetails.Builder> result = ErrorDetailsListCopier.copyToBuilder(this.errorDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrorDetails(Collection<ErrorDetails.BuilderImpl> errorDetails) {
            this.errorDetails = ErrorDetailsListCopier.copyFromBuilder(errorDetails);
        }

        @Override
        public final Builder errorDetails(Collection<ErrorDetails> errorDetails) {
            this.errorDetails = ErrorDetailsListCopier.copy(errorDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorDetails(ErrorDetails ... errorDetails) {
            this.errorDetails(Arrays.asList(errorDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorDetails(Consumer<ErrorDetails.Builder> ... errorDetails) {
            this.errorDetails(Stream.of(errorDetails).map(c -> (ErrorDetails)((ErrorDetails.Builder)ErrorDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ExportImageTask build() {
            return new ExportImageTask(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportImageTask> {
        public Builder taskId(String var1);

        public Builder imageArn(String var1);

        public Builder amiName(String var1);

        public Builder createdDate(Instant var1);

        public Builder amiDescription(String var1);

        public Builder state(String var1);

        public Builder state(ExportImageTaskState var1);

        public Builder amiId(String var1);

        public Builder tagSpecifications(Map<String, String> var1);

        public Builder errorDetails(Collection<ErrorDetails> var1);

        public Builder errorDetails(ErrorDetails ... var1);

        public Builder errorDetails(Consumer<ErrorDetails.Builder> ... var1);
    }
}

