/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appstream.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkAccessConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkAccessConfiguration> {
    private static final SdkField<String> ENI_PRIVATE_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EniPrivateIpAddress").getter(NetworkAccessConfiguration.getter(NetworkAccessConfiguration::eniPrivateIpAddress)).setter(NetworkAccessConfiguration.setter(Builder::eniPrivateIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EniPrivateIpAddress").build()}).build();
    private static final SdkField<List<String>> ENI_IPV6_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EniIpv6Addresses").getter(NetworkAccessConfiguration.getter(NetworkAccessConfiguration::eniIpv6Addresses)).setter(NetworkAccessConfiguration.setter(Builder::eniIpv6Addresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EniIpv6Addresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ENI_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EniId").getter(NetworkAccessConfiguration.getter(NetworkAccessConfiguration::eniId)).setter(NetworkAccessConfiguration.setter(Builder::eniId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EniId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENI_PRIVATE_IP_ADDRESS_FIELD, ENI_IPV6_ADDRESSES_FIELD, ENI_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NetworkAccessConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String eniPrivateIpAddress;
    private final List<String> eniIpv6Addresses;
    private final String eniId;

    private NetworkAccessConfiguration(BuilderImpl builder) {
        this.eniPrivateIpAddress = builder.eniPrivateIpAddress;
        this.eniIpv6Addresses = builder.eniIpv6Addresses;
        this.eniId = builder.eniId;
    }

    public final String eniPrivateIpAddress() {
        return this.eniPrivateIpAddress;
    }

    public final boolean hasEniIpv6Addresses() {
        return this.eniIpv6Addresses != null && !(this.eniIpv6Addresses instanceof SdkAutoConstructList);
    }

    public final List<String> eniIpv6Addresses() {
        return this.eniIpv6Addresses;
    }

    public final String eniId() {
        return this.eniId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eniPrivateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEniIpv6Addresses() ? this.eniIpv6Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.eniId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkAccessConfiguration)) {
            return false;
        }
        NetworkAccessConfiguration other = (NetworkAccessConfiguration)obj;
        return Objects.equals(this.eniPrivateIpAddress(), other.eniPrivateIpAddress()) && this.hasEniIpv6Addresses() == other.hasEniIpv6Addresses() && Objects.equals(this.eniIpv6Addresses(), other.eniIpv6Addresses()) && Objects.equals(this.eniId(), other.eniId());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkAccessConfiguration").add("EniPrivateIpAddress", (Object)this.eniPrivateIpAddress()).add("EniIpv6Addresses", this.hasEniIpv6Addresses() ? this.eniIpv6Addresses() : null).add("EniId", (Object)this.eniId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EniPrivateIpAddress": {
                return Optional.ofNullable(clazz.cast(this.eniPrivateIpAddress()));
            }
            case "EniIpv6Addresses": {
                return Optional.ofNullable(clazz.cast(this.eniIpv6Addresses()));
            }
            case "EniId": {
                return Optional.ofNullable(clazz.cast(this.eniId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EniPrivateIpAddress", ENI_PRIVATE_IP_ADDRESS_FIELD);
        map.put("EniIpv6Addresses", ENI_IPV6_ADDRESSES_FIELD);
        map.put("EniId", ENI_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkAccessConfiguration, T> g) {
        return obj -> g.apply((NetworkAccessConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eniPrivateIpAddress;
        private List<String> eniIpv6Addresses = DefaultSdkAutoConstructList.getInstance();
        private String eniId;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkAccessConfiguration model) {
            this.eniPrivateIpAddress(model.eniPrivateIpAddress);
            this.eniIpv6Addresses(model.eniIpv6Addresses);
            this.eniId(model.eniId);
        }

        public final String getEniPrivateIpAddress() {
            return this.eniPrivateIpAddress;
        }

        public final void setEniPrivateIpAddress(String eniPrivateIpAddress) {
            this.eniPrivateIpAddress = eniPrivateIpAddress;
        }

        @Override
        public final Builder eniPrivateIpAddress(String eniPrivateIpAddress) {
            this.eniPrivateIpAddress = eniPrivateIpAddress;
            return this;
        }

        public final Collection<String> getEniIpv6Addresses() {
            if (this.eniIpv6Addresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.eniIpv6Addresses;
        }

        public final void setEniIpv6Addresses(Collection<String> eniIpv6Addresses) {
            this.eniIpv6Addresses = StringListCopier.copy(eniIpv6Addresses);
        }

        @Override
        public final Builder eniIpv6Addresses(Collection<String> eniIpv6Addresses) {
            this.eniIpv6Addresses = StringListCopier.copy(eniIpv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eniIpv6Addresses(String ... eniIpv6Addresses) {
            this.eniIpv6Addresses(Arrays.asList(eniIpv6Addresses));
            return this;
        }

        public final String getEniId() {
            return this.eniId;
        }

        public final void setEniId(String eniId) {
            this.eniId = eniId;
        }

        @Override
        public final Builder eniId(String eniId) {
            this.eniId = eniId;
            return this;
        }

        public NetworkAccessConfiguration build() {
            return new NetworkAccessConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkAccessConfiguration> {
        public Builder eniPrivateIpAddress(String var1);

        public Builder eniIpv6Addresses(Collection<String> var1);

        public Builder eniIpv6Addresses(String ... var1);

        public Builder eniId(String var1);
    }
}

