/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appstream.model.ErrorDetails;
import software.amazon.awssdk.services.appstream.model.ErrorDetailsListCopier;
import software.amazon.awssdk.services.appstream.model.SoftwareDeploymentStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SoftwareAssociations
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SoftwareAssociations> {
    private static final SdkField<String> SOFTWARE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SoftwareName").getter(SoftwareAssociations.getter(SoftwareAssociations::softwareName)).setter(SoftwareAssociations.setter(Builder::softwareName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SoftwareName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(SoftwareAssociations.getter(SoftwareAssociations::statusAsString)).setter(SoftwareAssociations.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<ErrorDetails>> DEPLOYMENT_ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DeploymentError").getter(SoftwareAssociations.getter(SoftwareAssociations::deploymentError)).setter(SoftwareAssociations.setter(Builder::deploymentError)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentError").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ErrorDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOFTWARE_NAME_FIELD, STATUS_FIELD, DEPLOYMENT_ERROR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SoftwareAssociations.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String softwareName;
    private final String status;
    private final List<ErrorDetails> deploymentError;

    private SoftwareAssociations(BuilderImpl builder) {
        this.softwareName = builder.softwareName;
        this.status = builder.status;
        this.deploymentError = builder.deploymentError;
    }

    public final String softwareName() {
        return this.softwareName;
    }

    public final SoftwareDeploymentStatus status() {
        return SoftwareDeploymentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasDeploymentError() {
        return this.deploymentError != null && !(this.deploymentError instanceof SdkAutoConstructList);
    }

    public final List<ErrorDetails> deploymentError() {
        return this.deploymentError;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.softwareName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeploymentError() ? this.deploymentError() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SoftwareAssociations)) {
            return false;
        }
        SoftwareAssociations other = (SoftwareAssociations)obj;
        return Objects.equals(this.softwareName(), other.softwareName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasDeploymentError() == other.hasDeploymentError() && Objects.equals(this.deploymentError(), other.deploymentError());
    }

    public final String toString() {
        return ToString.builder((String)"SoftwareAssociations").add("SoftwareName", (Object)this.softwareName()).add("Status", (Object)this.statusAsString()).add("DeploymentError", this.hasDeploymentError() ? this.deploymentError() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SoftwareName": {
                return Optional.ofNullable(clazz.cast(this.softwareName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "DeploymentError": {
                return Optional.ofNullable(clazz.cast(this.deploymentError()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SoftwareName", SOFTWARE_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("DeploymentError", DEPLOYMENT_ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SoftwareAssociations, T> g) {
        return obj -> g.apply((SoftwareAssociations)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String softwareName;
        private String status;
        private List<ErrorDetails> deploymentError = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SoftwareAssociations model) {
            this.softwareName(model.softwareName);
            this.status(model.status);
            this.deploymentError(model.deploymentError);
        }

        public final String getSoftwareName() {
            return this.softwareName;
        }

        public final void setSoftwareName(String softwareName) {
            this.softwareName = softwareName;
        }

        @Override
        public final Builder softwareName(String softwareName) {
            this.softwareName = softwareName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SoftwareDeploymentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<ErrorDetails.Builder> getDeploymentError() {
            List<ErrorDetails.Builder> result = ErrorDetailsListCopier.copyToBuilder(this.deploymentError);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeploymentError(Collection<ErrorDetails.BuilderImpl> deploymentError) {
            this.deploymentError = ErrorDetailsListCopier.copyFromBuilder(deploymentError);
        }

        @Override
        public final Builder deploymentError(Collection<ErrorDetails> deploymentError) {
            this.deploymentError = ErrorDetailsListCopier.copy(deploymentError);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentError(ErrorDetails ... deploymentError) {
            this.deploymentError(Arrays.asList(deploymentError));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentError(Consumer<ErrorDetails.Builder> ... deploymentError) {
            this.deploymentError(Stream.of(deploymentError).map(c -> (ErrorDetails)((ErrorDetails.Builder)ErrorDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SoftwareAssociations build() {
            return new SoftwareAssociations(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SoftwareAssociations> {
        public Builder softwareName(String var1);

        public Builder status(String var1);

        public Builder status(SoftwareDeploymentStatus var1);

        public Builder deploymentError(Collection<ErrorDetails> var1);

        public Builder deploymentError(ErrorDetails ... var1);

        public Builder deploymentError(Consumer<ErrorDetails.Builder> ... var1);
    }
}

