/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StorageConnectorType {
    HOMEFOLDERS("HOMEFOLDERS"),
    GOOGLE_DRIVE("GOOGLE_DRIVE"),
    ONE_DRIVE("ONE_DRIVE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StorageConnectorType> VALUE_MAP;
    private final String value;

    private StorageConnectorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StorageConnectorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StorageConnectorType> knownValues() {
        EnumSet<StorageConnectorType> knownValues = EnumSet.allOf(StorageConnectorType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StorageConnectorType.class, StorageConnectorType::toString);
    }
}

