/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appstream.model.AppStreamRequest;
import software.amazon.awssdk.services.appstream.model.S3Location;
import software.amazon.awssdk.services.appstream.model.ThemeAttribute;
import software.amazon.awssdk.services.appstream.model.ThemeAttributesCopier;
import software.amazon.awssdk.services.appstream.model.ThemeFooterLink;
import software.amazon.awssdk.services.appstream.model.ThemeFooterLinksCopier;
import software.amazon.awssdk.services.appstream.model.ThemeState;
import software.amazon.awssdk.services.appstream.model.ThemeStyling;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateThemeForStackRequest
extends AppStreamRequest
implements ToCopyableBuilder<Builder, UpdateThemeForStackRequest> {
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackName").getter(UpdateThemeForStackRequest.getter(UpdateThemeForStackRequest::stackName)).setter(UpdateThemeForStackRequest.setter(Builder::stackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()}).build();
    private static final SdkField<List<ThemeFooterLink>> FOOTER_LINKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FooterLinks").getter(UpdateThemeForStackRequest.getter(UpdateThemeForStackRequest::footerLinks)).setter(UpdateThemeForStackRequest.setter(Builder::footerLinks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FooterLinks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ThemeFooterLink::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TITLE_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TitleText").getter(UpdateThemeForStackRequest.getter(UpdateThemeForStackRequest::titleText)).setter(UpdateThemeForStackRequest.setter(Builder::titleText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TitleText").build()}).build();
    private static final SdkField<String> THEME_STYLING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ThemeStyling").getter(UpdateThemeForStackRequest.getter(UpdateThemeForStackRequest::themeStylingAsString)).setter(UpdateThemeForStackRequest.setter(Builder::themeStyling)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThemeStyling").build()}).build();
    private static final SdkField<S3Location> ORGANIZATION_LOGO_S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OrganizationLogoS3Location").getter(UpdateThemeForStackRequest.getter(UpdateThemeForStackRequest::organizationLogoS3Location)).setter(UpdateThemeForStackRequest.setter(Builder::organizationLogoS3Location)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationLogoS3Location").build()}).build();
    private static final SdkField<S3Location> FAVICON_S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FaviconS3Location").getter(UpdateThemeForStackRequest.getter(UpdateThemeForStackRequest::faviconS3Location)).setter(UpdateThemeForStackRequest.setter(Builder::faviconS3Location)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaviconS3Location").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(UpdateThemeForStackRequest.getter(UpdateThemeForStackRequest::stateAsString)).setter(UpdateThemeForStackRequest.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<List<String>> ATTRIBUTES_TO_DELETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttributesToDelete").getter(UpdateThemeForStackRequest.getter(UpdateThemeForStackRequest::attributesToDeleteAsStrings)).setter(UpdateThemeForStackRequest.setter(Builder::attributesToDeleteWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributesToDelete").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_NAME_FIELD, FOOTER_LINKS_FIELD, TITLE_TEXT_FIELD, THEME_STYLING_FIELD, ORGANIZATION_LOGO_S3_LOCATION_FIELD, FAVICON_S3_LOCATION_FIELD, STATE_FIELD, ATTRIBUTES_TO_DELETE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateThemeForStackRequest.memberNameToFieldInitializer();
    private final String stackName;
    private final List<ThemeFooterLink> footerLinks;
    private final String titleText;
    private final String themeStyling;
    private final S3Location organizationLogoS3Location;
    private final S3Location faviconS3Location;
    private final String state;
    private final List<String> attributesToDelete;

    private UpdateThemeForStackRequest(BuilderImpl builder) {
        super(builder);
        this.stackName = builder.stackName;
        this.footerLinks = builder.footerLinks;
        this.titleText = builder.titleText;
        this.themeStyling = builder.themeStyling;
        this.organizationLogoS3Location = builder.organizationLogoS3Location;
        this.faviconS3Location = builder.faviconS3Location;
        this.state = builder.state;
        this.attributesToDelete = builder.attributesToDelete;
    }

    public final String stackName() {
        return this.stackName;
    }

    public final boolean hasFooterLinks() {
        return this.footerLinks != null && !(this.footerLinks instanceof SdkAutoConstructList);
    }

    public final List<ThemeFooterLink> footerLinks() {
        return this.footerLinks;
    }

    public final String titleText() {
        return this.titleText;
    }

    public final ThemeStyling themeStyling() {
        return ThemeStyling.fromValue(this.themeStyling);
    }

    public final String themeStylingAsString() {
        return this.themeStyling;
    }

    public final S3Location organizationLogoS3Location() {
        return this.organizationLogoS3Location;
    }

    public final S3Location faviconS3Location() {
        return this.faviconS3Location;
    }

    public final ThemeState state() {
        return ThemeState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final List<ThemeAttribute> attributesToDelete() {
        return ThemeAttributesCopier.copyStringToEnum(this.attributesToDelete);
    }

    public final boolean hasAttributesToDelete() {
        return this.attributesToDelete != null && !(this.attributesToDelete instanceof SdkAutoConstructList);
    }

    public final List<String> attributesToDeleteAsStrings() {
        return this.attributesToDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFooterLinks() ? this.footerLinks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.titleText());
        hashCode = 31 * hashCode + Objects.hashCode(this.themeStylingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationLogoS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(this.faviconS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributesToDelete() ? this.attributesToDeleteAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateThemeForStackRequest)) {
            return false;
        }
        UpdateThemeForStackRequest other = (UpdateThemeForStackRequest)((Object)obj);
        return Objects.equals(this.stackName(), other.stackName()) && this.hasFooterLinks() == other.hasFooterLinks() && Objects.equals(this.footerLinks(), other.footerLinks()) && Objects.equals(this.titleText(), other.titleText()) && Objects.equals(this.themeStylingAsString(), other.themeStylingAsString()) && Objects.equals(this.organizationLogoS3Location(), other.organizationLogoS3Location()) && Objects.equals(this.faviconS3Location(), other.faviconS3Location()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasAttributesToDelete() == other.hasAttributesToDelete() && Objects.equals(this.attributesToDeleteAsStrings(), other.attributesToDeleteAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateThemeForStackRequest").add("StackName", (Object)this.stackName()).add("FooterLinks", this.hasFooterLinks() ? this.footerLinks() : null).add("TitleText", (Object)this.titleText()).add("ThemeStyling", (Object)this.themeStylingAsString()).add("OrganizationLogoS3Location", (Object)this.organizationLogoS3Location()).add("FaviconS3Location", (Object)this.faviconS3Location()).add("State", (Object)this.stateAsString()).add("AttributesToDelete", this.hasAttributesToDelete() ? this.attributesToDeleteAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackName": {
                return Optional.ofNullable(clazz.cast(this.stackName()));
            }
            case "FooterLinks": {
                return Optional.ofNullable(clazz.cast(this.footerLinks()));
            }
            case "TitleText": {
                return Optional.ofNullable(clazz.cast(this.titleText()));
            }
            case "ThemeStyling": {
                return Optional.ofNullable(clazz.cast(this.themeStylingAsString()));
            }
            case "OrganizationLogoS3Location": {
                return Optional.ofNullable(clazz.cast(this.organizationLogoS3Location()));
            }
            case "FaviconS3Location": {
                return Optional.ofNullable(clazz.cast(this.faviconS3Location()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "AttributesToDelete": {
                return Optional.ofNullable(clazz.cast(this.attributesToDeleteAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StackName", STACK_NAME_FIELD);
        map.put("FooterLinks", FOOTER_LINKS_FIELD);
        map.put("TitleText", TITLE_TEXT_FIELD);
        map.put("ThemeStyling", THEME_STYLING_FIELD);
        map.put("OrganizationLogoS3Location", ORGANIZATION_LOGO_S3_LOCATION_FIELD);
        map.put("FaviconS3Location", FAVICON_S3_LOCATION_FIELD);
        map.put("State", STATE_FIELD);
        map.put("AttributesToDelete", ATTRIBUTES_TO_DELETE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateThemeForStackRequest, T> g) {
        return obj -> g.apply((UpdateThemeForStackRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppStreamRequest.BuilderImpl
    implements Builder {
        private String stackName;
        private List<ThemeFooterLink> footerLinks = DefaultSdkAutoConstructList.getInstance();
        private String titleText;
        private String themeStyling;
        private S3Location organizationLogoS3Location;
        private S3Location faviconS3Location;
        private String state;
        private List<String> attributesToDelete = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateThemeForStackRequest model) {
            super(model);
            this.stackName(model.stackName);
            this.footerLinks(model.footerLinks);
            this.titleText(model.titleText);
            this.themeStyling(model.themeStyling);
            this.organizationLogoS3Location(model.organizationLogoS3Location);
            this.faviconS3Location(model.faviconS3Location);
            this.state(model.state);
            this.attributesToDeleteWithStrings(model.attributesToDelete);
        }

        public final String getStackName() {
            return this.stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final List<ThemeFooterLink.Builder> getFooterLinks() {
            List<ThemeFooterLink.Builder> result = ThemeFooterLinksCopier.copyToBuilder(this.footerLinks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFooterLinks(Collection<ThemeFooterLink.BuilderImpl> footerLinks) {
            this.footerLinks = ThemeFooterLinksCopier.copyFromBuilder(footerLinks);
        }

        @Override
        public final Builder footerLinks(Collection<ThemeFooterLink> footerLinks) {
            this.footerLinks = ThemeFooterLinksCopier.copy(footerLinks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder footerLinks(ThemeFooterLink ... footerLinks) {
            this.footerLinks(Arrays.asList(footerLinks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder footerLinks(Consumer<ThemeFooterLink.Builder> ... footerLinks) {
            this.footerLinks(Stream.of(footerLinks).map(c -> (ThemeFooterLink)((ThemeFooterLink.Builder)ThemeFooterLink.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTitleText() {
            return this.titleText;
        }

        public final void setTitleText(String titleText) {
            this.titleText = titleText;
        }

        @Override
        public final Builder titleText(String titleText) {
            this.titleText = titleText;
            return this;
        }

        public final String getThemeStyling() {
            return this.themeStyling;
        }

        public final void setThemeStyling(String themeStyling) {
            this.themeStyling = themeStyling;
        }

        @Override
        public final Builder themeStyling(String themeStyling) {
            this.themeStyling = themeStyling;
            return this;
        }

        @Override
        public final Builder themeStyling(ThemeStyling themeStyling) {
            this.themeStyling(themeStyling == null ? null : themeStyling.toString());
            return this;
        }

        public final S3Location.Builder getOrganizationLogoS3Location() {
            return this.organizationLogoS3Location != null ? this.organizationLogoS3Location.toBuilder() : null;
        }

        public final void setOrganizationLogoS3Location(S3Location.BuilderImpl organizationLogoS3Location) {
            this.organizationLogoS3Location = organizationLogoS3Location != null ? organizationLogoS3Location.build() : null;
        }

        @Override
        public final Builder organizationLogoS3Location(S3Location organizationLogoS3Location) {
            this.organizationLogoS3Location = organizationLogoS3Location;
            return this;
        }

        public final S3Location.Builder getFaviconS3Location() {
            return this.faviconS3Location != null ? this.faviconS3Location.toBuilder() : null;
        }

        public final void setFaviconS3Location(S3Location.BuilderImpl faviconS3Location) {
            this.faviconS3Location = faviconS3Location != null ? faviconS3Location.build() : null;
        }

        @Override
        public final Builder faviconS3Location(S3Location faviconS3Location) {
            this.faviconS3Location = faviconS3Location;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ThemeState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Collection<String> getAttributesToDelete() {
            if (this.attributesToDelete instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attributesToDelete;
        }

        public final void setAttributesToDelete(Collection<String> attributesToDelete) {
            this.attributesToDelete = ThemeAttributesCopier.copy(attributesToDelete);
        }

        @Override
        public final Builder attributesToDeleteWithStrings(Collection<String> attributesToDelete) {
            this.attributesToDelete = ThemeAttributesCopier.copy(attributesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToDeleteWithStrings(String ... attributesToDelete) {
            this.attributesToDeleteWithStrings(Arrays.asList(attributesToDelete));
            return this;
        }

        @Override
        public final Builder attributesToDelete(Collection<ThemeAttribute> attributesToDelete) {
            this.attributesToDelete = ThemeAttributesCopier.copyEnumToString(attributesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToDelete(ThemeAttribute ... attributesToDelete) {
            this.attributesToDelete(Arrays.asList(attributesToDelete));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateThemeForStackRequest build() {
            return new UpdateThemeForStackRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppStreamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateThemeForStackRequest> {
        public Builder stackName(String var1);

        public Builder footerLinks(Collection<ThemeFooterLink> var1);

        public Builder footerLinks(ThemeFooterLink ... var1);

        public Builder footerLinks(Consumer<ThemeFooterLink.Builder> ... var1);

        public Builder titleText(String var1);

        public Builder themeStyling(String var1);

        public Builder themeStyling(ThemeStyling var1);

        public Builder organizationLogoS3Location(S3Location var1);

        default public Builder organizationLogoS3Location(Consumer<S3Location.Builder> organizationLogoS3Location) {
            return this.organizationLogoS3Location((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(organizationLogoS3Location)).build());
        }

        public Builder faviconS3Location(S3Location var1);

        default public Builder faviconS3Location(Consumer<S3Location.Builder> faviconS3Location) {
            return this.faviconS3Location((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(faviconS3Location)).build());
        }

        public Builder state(String var1);

        public Builder state(ThemeState var1);

        public Builder attributesToDeleteWithStrings(Collection<String> var1);

        public Builder attributesToDeleteWithStrings(String ... var1);

        public Builder attributesToDelete(Collection<ThemeAttribute> var1);

        public Builder attributesToDelete(ThemeAttribute ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

