/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appsync.model.DataSourceLevelMetricsBehavior;
import software.amazon.awssdk.services.appsync.model.OperationLevelMetricsConfig;
import software.amazon.awssdk.services.appsync.model.ResolverLevelMetricsBehavior;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnhancedMetricsConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnhancedMetricsConfig> {
    private static final SdkField<String> RESOLVER_LEVEL_METRICS_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resolverLevelMetricsBehavior").getter(EnhancedMetricsConfig.getter(EnhancedMetricsConfig::resolverLevelMetricsBehaviorAsString)).setter(EnhancedMetricsConfig.setter(Builder::resolverLevelMetricsBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolverLevelMetricsBehavior").build()}).build();
    private static final SdkField<String> DATA_SOURCE_LEVEL_METRICS_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataSourceLevelMetricsBehavior").getter(EnhancedMetricsConfig.getter(EnhancedMetricsConfig::dataSourceLevelMetricsBehaviorAsString)).setter(EnhancedMetricsConfig.setter(Builder::dataSourceLevelMetricsBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceLevelMetricsBehavior").build()}).build();
    private static final SdkField<String> OPERATION_LEVEL_METRICS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operationLevelMetricsConfig").getter(EnhancedMetricsConfig.getter(EnhancedMetricsConfig::operationLevelMetricsConfigAsString)).setter(EnhancedMetricsConfig.setter(Builder::operationLevelMetricsConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationLevelMetricsConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOLVER_LEVEL_METRICS_BEHAVIOR_FIELD, DATA_SOURCE_LEVEL_METRICS_BEHAVIOR_FIELD, OPERATION_LEVEL_METRICS_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resolverLevelMetricsBehavior;
    private final String dataSourceLevelMetricsBehavior;
    private final String operationLevelMetricsConfig;

    private EnhancedMetricsConfig(BuilderImpl builder) {
        this.resolverLevelMetricsBehavior = builder.resolverLevelMetricsBehavior;
        this.dataSourceLevelMetricsBehavior = builder.dataSourceLevelMetricsBehavior;
        this.operationLevelMetricsConfig = builder.operationLevelMetricsConfig;
    }

    public final ResolverLevelMetricsBehavior resolverLevelMetricsBehavior() {
        return ResolverLevelMetricsBehavior.fromValue(this.resolverLevelMetricsBehavior);
    }

    public final String resolverLevelMetricsBehaviorAsString() {
        return this.resolverLevelMetricsBehavior;
    }

    public final DataSourceLevelMetricsBehavior dataSourceLevelMetricsBehavior() {
        return DataSourceLevelMetricsBehavior.fromValue(this.dataSourceLevelMetricsBehavior);
    }

    public final String dataSourceLevelMetricsBehaviorAsString() {
        return this.dataSourceLevelMetricsBehavior;
    }

    public final OperationLevelMetricsConfig operationLevelMetricsConfig() {
        return OperationLevelMetricsConfig.fromValue(this.operationLevelMetricsConfig);
    }

    public final String operationLevelMetricsConfigAsString() {
        return this.operationLevelMetricsConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resolverLevelMetricsBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceLevelMetricsBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationLevelMetricsConfigAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnhancedMetricsConfig)) {
            return false;
        }
        EnhancedMetricsConfig other = (EnhancedMetricsConfig)obj;
        return Objects.equals(this.resolverLevelMetricsBehaviorAsString(), other.resolverLevelMetricsBehaviorAsString()) && Objects.equals(this.dataSourceLevelMetricsBehaviorAsString(), other.dataSourceLevelMetricsBehaviorAsString()) && Objects.equals(this.operationLevelMetricsConfigAsString(), other.operationLevelMetricsConfigAsString());
    }

    public final String toString() {
        return ToString.builder((String)"EnhancedMetricsConfig").add("ResolverLevelMetricsBehavior", (Object)this.resolverLevelMetricsBehaviorAsString()).add("DataSourceLevelMetricsBehavior", (Object)this.dataSourceLevelMetricsBehaviorAsString()).add("OperationLevelMetricsConfig", (Object)this.operationLevelMetricsConfigAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resolverLevelMetricsBehavior": {
                return Optional.ofNullable(clazz.cast(this.resolverLevelMetricsBehaviorAsString()));
            }
            case "dataSourceLevelMetricsBehavior": {
                return Optional.ofNullable(clazz.cast(this.dataSourceLevelMetricsBehaviorAsString()));
            }
            case "operationLevelMetricsConfig": {
                return Optional.ofNullable(clazz.cast(this.operationLevelMetricsConfigAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnhancedMetricsConfig, T> g) {
        return obj -> g.apply((EnhancedMetricsConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resolverLevelMetricsBehavior;
        private String dataSourceLevelMetricsBehavior;
        private String operationLevelMetricsConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(EnhancedMetricsConfig model) {
            this.resolverLevelMetricsBehavior(model.resolverLevelMetricsBehavior);
            this.dataSourceLevelMetricsBehavior(model.dataSourceLevelMetricsBehavior);
            this.operationLevelMetricsConfig(model.operationLevelMetricsConfig);
        }

        public final String getResolverLevelMetricsBehavior() {
            return this.resolverLevelMetricsBehavior;
        }

        public final void setResolverLevelMetricsBehavior(String resolverLevelMetricsBehavior) {
            this.resolverLevelMetricsBehavior = resolverLevelMetricsBehavior;
        }

        @Override
        public final Builder resolverLevelMetricsBehavior(String resolverLevelMetricsBehavior) {
            this.resolverLevelMetricsBehavior = resolverLevelMetricsBehavior;
            return this;
        }

        @Override
        public final Builder resolverLevelMetricsBehavior(ResolverLevelMetricsBehavior resolverLevelMetricsBehavior) {
            this.resolverLevelMetricsBehavior(resolverLevelMetricsBehavior == null ? null : resolverLevelMetricsBehavior.toString());
            return this;
        }

        public final String getDataSourceLevelMetricsBehavior() {
            return this.dataSourceLevelMetricsBehavior;
        }

        public final void setDataSourceLevelMetricsBehavior(String dataSourceLevelMetricsBehavior) {
            this.dataSourceLevelMetricsBehavior = dataSourceLevelMetricsBehavior;
        }

        @Override
        public final Builder dataSourceLevelMetricsBehavior(String dataSourceLevelMetricsBehavior) {
            this.dataSourceLevelMetricsBehavior = dataSourceLevelMetricsBehavior;
            return this;
        }

        @Override
        public final Builder dataSourceLevelMetricsBehavior(DataSourceLevelMetricsBehavior dataSourceLevelMetricsBehavior) {
            this.dataSourceLevelMetricsBehavior(dataSourceLevelMetricsBehavior == null ? null : dataSourceLevelMetricsBehavior.toString());
            return this;
        }

        public final String getOperationLevelMetricsConfig() {
            return this.operationLevelMetricsConfig;
        }

        public final void setOperationLevelMetricsConfig(String operationLevelMetricsConfig) {
            this.operationLevelMetricsConfig = operationLevelMetricsConfig;
        }

        @Override
        public final Builder operationLevelMetricsConfig(String operationLevelMetricsConfig) {
            this.operationLevelMetricsConfig = operationLevelMetricsConfig;
            return this;
        }

        @Override
        public final Builder operationLevelMetricsConfig(OperationLevelMetricsConfig operationLevelMetricsConfig) {
            this.operationLevelMetricsConfig(operationLevelMetricsConfig == null ? null : operationLevelMetricsConfig.toString());
            return this;
        }

        public EnhancedMetricsConfig build() {
            return new EnhancedMetricsConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnhancedMetricsConfig> {
        public Builder resolverLevelMetricsBehavior(String var1);

        public Builder resolverLevelMetricsBehavior(ResolverLevelMetricsBehavior var1);

        public Builder dataSourceLevelMetricsBehavior(String var1);

        public Builder dataSourceLevelMetricsBehavior(DataSourceLevelMetricsBehavior var1);

        public Builder operationLevelMetricsConfig(String var1);

        public Builder operationLevelMetricsConfig(OperationLevelMetricsConfig var1);
    }
}

