/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appsync.model.AppSyncResponse;
import software.amazon.awssdk.services.appsync.model.ErrorDetail;
import software.amazon.awssdk.services.appsync.model.LogsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluateMappingTemplateResponse
extends AppSyncResponse
implements ToCopyableBuilder<Builder, EvaluateMappingTemplateResponse> {
    private static final SdkField<String> EVALUATION_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("evaluationResult").getter(EvaluateMappingTemplateResponse.getter(EvaluateMappingTemplateResponse::evaluationResult)).setter(EvaluateMappingTemplateResponse.setter(Builder::evaluationResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationResult").build()}).build();
    private static final SdkField<ErrorDetail> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("error").getter(EvaluateMappingTemplateResponse.getter(EvaluateMappingTemplateResponse::error)).setter(EvaluateMappingTemplateResponse.setter(Builder::error)).constructor(ErrorDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final SdkField<List<String>> LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("logs").getter(EvaluateMappingTemplateResponse.getter(EvaluateMappingTemplateResponse::logs)).setter(EvaluateMappingTemplateResponse.setter(Builder::logs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stash").getter(EvaluateMappingTemplateResponse.getter(EvaluateMappingTemplateResponse::stash)).setter(EvaluateMappingTemplateResponse.setter(Builder::stash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stash").build()}).build();
    private static final SdkField<String> OUT_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("outErrors").getter(EvaluateMappingTemplateResponse.getter(EvaluateMappingTemplateResponse::outErrors)).setter(EvaluateMappingTemplateResponse.setter(Builder::outErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outErrors").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATION_RESULT_FIELD, ERROR_FIELD, LOGS_FIELD, STASH_FIELD, OUT_ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluateMappingTemplateResponse.memberNameToFieldInitializer();
    private final String evaluationResult;
    private final ErrorDetail error;
    private final List<String> logs;
    private final String stash;
    private final String outErrors;

    private EvaluateMappingTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.evaluationResult = builder.evaluationResult;
        this.error = builder.error;
        this.logs = builder.logs;
        this.stash = builder.stash;
        this.outErrors = builder.outErrors;
    }

    public final String evaluationResult() {
        return this.evaluationResult;
    }

    public final ErrorDetail error() {
        return this.error;
    }

    public final boolean hasLogs() {
        return this.logs != null && !(this.logs instanceof SdkAutoConstructList);
    }

    public final List<String> logs() {
        return this.logs;
    }

    public final String stash() {
        return this.stash;
    }

    public final String outErrors() {
        return this.outErrors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogs() ? this.logs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stash());
        hashCode = 31 * hashCode + Objects.hashCode(this.outErrors());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluateMappingTemplateResponse)) {
            return false;
        }
        EvaluateMappingTemplateResponse other = (EvaluateMappingTemplateResponse)((Object)obj);
        return Objects.equals(this.evaluationResult(), other.evaluationResult()) && Objects.equals(this.error(), other.error()) && this.hasLogs() == other.hasLogs() && Objects.equals(this.logs(), other.logs()) && Objects.equals(this.stash(), other.stash()) && Objects.equals(this.outErrors(), other.outErrors());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluateMappingTemplateResponse").add("EvaluationResult", (Object)this.evaluationResult()).add("Error", (Object)this.error()).add("Logs", this.hasLogs() ? this.logs() : null).add("Stash", (Object)this.stash()).add("OutErrors", (Object)this.outErrors()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "evaluationResult": {
                return Optional.ofNullable(clazz.cast(this.evaluationResult()));
            }
            case "error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "logs": {
                return Optional.ofNullable(clazz.cast(this.logs()));
            }
            case "stash": {
                return Optional.ofNullable(clazz.cast(this.stash()));
            }
            case "outErrors": {
                return Optional.ofNullable(clazz.cast(this.outErrors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("evaluationResult", EVALUATION_RESULT_FIELD);
        map.put("error", ERROR_FIELD);
        map.put("logs", LOGS_FIELD);
        map.put("stash", STASH_FIELD);
        map.put("outErrors", OUT_ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluateMappingTemplateResponse, T> g) {
        return obj -> g.apply((EvaluateMappingTemplateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppSyncResponse.BuilderImpl
    implements Builder {
        private String evaluationResult;
        private ErrorDetail error;
        private List<String> logs = DefaultSdkAutoConstructList.getInstance();
        private String stash;
        private String outErrors;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluateMappingTemplateResponse model) {
            super(model);
            this.evaluationResult(model.evaluationResult);
            this.error(model.error);
            this.logs(model.logs);
            this.stash(model.stash);
            this.outErrors(model.outErrors);
        }

        public final String getEvaluationResult() {
            return this.evaluationResult;
        }

        public final void setEvaluationResult(String evaluationResult) {
            this.evaluationResult = evaluationResult;
        }

        @Override
        public final Builder evaluationResult(String evaluationResult) {
            this.evaluationResult = evaluationResult;
            return this;
        }

        public final ErrorDetail.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        public final void setError(ErrorDetail.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorDetail error) {
            this.error = error;
            return this;
        }

        public final Collection<String> getLogs() {
            if (this.logs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.logs;
        }

        public final void setLogs(Collection<String> logs) {
            this.logs = LogsCopier.copy(logs);
        }

        @Override
        public final Builder logs(Collection<String> logs) {
            this.logs = LogsCopier.copy(logs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logs(String ... logs) {
            this.logs(Arrays.asList(logs));
            return this;
        }

        public final String getStash() {
            return this.stash;
        }

        public final void setStash(String stash) {
            this.stash = stash;
        }

        @Override
        public final Builder stash(String stash) {
            this.stash = stash;
            return this;
        }

        public final String getOutErrors() {
            return this.outErrors;
        }

        public final void setOutErrors(String outErrors) {
            this.outErrors = outErrors;
        }

        @Override
        public final Builder outErrors(String outErrors) {
            this.outErrors = outErrors;
            return this;
        }

        @Override
        public EvaluateMappingTemplateResponse build() {
            return new EvaluateMappingTemplateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppSyncResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, EvaluateMappingTemplateResponse> {
        public Builder evaluationResult(String var1);

        public Builder error(ErrorDetail var1);

        default public Builder error(Consumer<ErrorDetail.Builder> error) {
            return this.error((ErrorDetail)((ErrorDetail.Builder)ErrorDetail.builder().applyMutation(error)).build());
        }

        public Builder logs(Collection<String> var1);

        public Builder logs(String ... var1);

        public Builder stash(String var1);

        public Builder outErrors(String var1);
    }
}

