/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appsync.model.FieldLogLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LogConfig> {
    private static final SdkField<String> FIELD_LOG_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fieldLogLevel").getter(LogConfig.getter(LogConfig::fieldLogLevelAsString)).setter(LogConfig.setter(Builder::fieldLogLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldLogLevel").build()}).build();
    private static final SdkField<String> CLOUD_WATCH_LOGS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cloudWatchLogsRoleArn").getter(LogConfig.getter(LogConfig::cloudWatchLogsRoleArn)).setter(LogConfig.setter(Builder::cloudWatchLogsRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchLogsRoleArn").build()}).build();
    private static final SdkField<Boolean> EXCLUDE_VERBOSE_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("excludeVerboseContent").getter(LogConfig.getter(LogConfig::excludeVerboseContent)).setter(LogConfig.setter(Builder::excludeVerboseContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excludeVerboseContent").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_LOG_LEVEL_FIELD, CLOUD_WATCH_LOGS_ROLE_ARN_FIELD, EXCLUDE_VERBOSE_CONTENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LogConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String fieldLogLevel;
    private final String cloudWatchLogsRoleArn;
    private final Boolean excludeVerboseContent;

    private LogConfig(BuilderImpl builder) {
        this.fieldLogLevel = builder.fieldLogLevel;
        this.cloudWatchLogsRoleArn = builder.cloudWatchLogsRoleArn;
        this.excludeVerboseContent = builder.excludeVerboseContent;
    }

    public final FieldLogLevel fieldLogLevel() {
        return FieldLogLevel.fromValue(this.fieldLogLevel);
    }

    public final String fieldLogLevelAsString() {
        return this.fieldLogLevel;
    }

    public final String cloudWatchLogsRoleArn() {
        return this.cloudWatchLogsRoleArn;
    }

    public final Boolean excludeVerboseContent() {
        return this.excludeVerboseContent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldLogLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogsRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.excludeVerboseContent());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogConfig)) {
            return false;
        }
        LogConfig other = (LogConfig)obj;
        return Objects.equals(this.fieldLogLevelAsString(), other.fieldLogLevelAsString()) && Objects.equals(this.cloudWatchLogsRoleArn(), other.cloudWatchLogsRoleArn()) && Objects.equals(this.excludeVerboseContent(), other.excludeVerboseContent());
    }

    public final String toString() {
        return ToString.builder((String)"LogConfig").add("FieldLogLevel", (Object)this.fieldLogLevelAsString()).add("CloudWatchLogsRoleArn", (Object)this.cloudWatchLogsRoleArn()).add("ExcludeVerboseContent", (Object)this.excludeVerboseContent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fieldLogLevel": {
                return Optional.ofNullable(clazz.cast(this.fieldLogLevelAsString()));
            }
            case "cloudWatchLogsRoleArn": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogsRoleArn()));
            }
            case "excludeVerboseContent": {
                return Optional.ofNullable(clazz.cast(this.excludeVerboseContent()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fieldLogLevel", FIELD_LOG_LEVEL_FIELD);
        map.put("cloudWatchLogsRoleArn", CLOUD_WATCH_LOGS_ROLE_ARN_FIELD);
        map.put("excludeVerboseContent", EXCLUDE_VERBOSE_CONTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LogConfig, T> g) {
        return obj -> g.apply((LogConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fieldLogLevel;
        private String cloudWatchLogsRoleArn;
        private Boolean excludeVerboseContent;

        private BuilderImpl() {
        }

        private BuilderImpl(LogConfig model) {
            this.fieldLogLevel(model.fieldLogLevel);
            this.cloudWatchLogsRoleArn(model.cloudWatchLogsRoleArn);
            this.excludeVerboseContent(model.excludeVerboseContent);
        }

        public final String getFieldLogLevel() {
            return this.fieldLogLevel;
        }

        public final void setFieldLogLevel(String fieldLogLevel) {
            this.fieldLogLevel = fieldLogLevel;
        }

        @Override
        public final Builder fieldLogLevel(String fieldLogLevel) {
            this.fieldLogLevel = fieldLogLevel;
            return this;
        }

        @Override
        public final Builder fieldLogLevel(FieldLogLevel fieldLogLevel) {
            this.fieldLogLevel(fieldLogLevel == null ? null : fieldLogLevel.toString());
            return this;
        }

        public final String getCloudWatchLogsRoleArn() {
            return this.cloudWatchLogsRoleArn;
        }

        public final void setCloudWatchLogsRoleArn(String cloudWatchLogsRoleArn) {
            this.cloudWatchLogsRoleArn = cloudWatchLogsRoleArn;
        }

        @Override
        public final Builder cloudWatchLogsRoleArn(String cloudWatchLogsRoleArn) {
            this.cloudWatchLogsRoleArn = cloudWatchLogsRoleArn;
            return this;
        }

        public final Boolean getExcludeVerboseContent() {
            return this.excludeVerboseContent;
        }

        public final void setExcludeVerboseContent(Boolean excludeVerboseContent) {
            this.excludeVerboseContent = excludeVerboseContent;
        }

        @Override
        public final Builder excludeVerboseContent(Boolean excludeVerboseContent) {
            this.excludeVerboseContent = excludeVerboseContent;
            return this;
        }

        public LogConfig build() {
            return new LogConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LogConfig> {
        public Builder fieldLogLevel(String var1);

        public Builder fieldLogLevel(FieldLogLevel var1);

        public Builder cloudWatchLogsRoleArn(String var1);

        public Builder excludeVerboseContent(Boolean var1);
    }
}

