/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataCatalogType {
    LAMBDA("LAMBDA"),
    GLUE("GLUE"),
    HIVE("HIVE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataCatalogType> VALUE_MAP;
    private final String value;

    private DataCatalogType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataCatalogType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataCatalogType> knownValues() {
        EnumSet<DataCatalogType> knownValues = EnumSet.allOf(DataCatalogType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataCatalogType.class, DataCatalogType::toString);
    }
}

