/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.athena.model.EncryptionConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SessionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SessionConfiguration> {
    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRole").getter(SessionConfiguration.getter(SessionConfiguration::executionRole)).setter(SessionConfiguration.setter(Builder::executionRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRole").build()}).build();
    private static final SdkField<String> WORKING_DIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkingDirectory").getter(SessionConfiguration.getter(SessionConfiguration::workingDirectory)).setter(SessionConfiguration.setter(Builder::workingDirectory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkingDirectory").build()}).build();
    private static final SdkField<Long> IDLE_TIMEOUT_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("IdleTimeoutSeconds").getter(SessionConfiguration.getter(SessionConfiguration::idleTimeoutSeconds)).setter(SessionConfiguration.setter(Builder::idleTimeoutSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdleTimeoutSeconds").build()}).build();
    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionConfiguration").getter(SessionConfiguration.getter(SessionConfiguration::encryptionConfiguration)).setter(SessionConfiguration.setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ROLE_FIELD, WORKING_DIRECTORY_FIELD, IDLE_TIMEOUT_SECONDS_FIELD, ENCRYPTION_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String executionRole;
    private final String workingDirectory;
    private final Long idleTimeoutSeconds;
    private final EncryptionConfiguration encryptionConfiguration;

    private SessionConfiguration(BuilderImpl builder) {
        this.executionRole = builder.executionRole;
        this.workingDirectory = builder.workingDirectory;
        this.idleTimeoutSeconds = builder.idleTimeoutSeconds;
        this.encryptionConfiguration = builder.encryptionConfiguration;
    }

    public final String executionRole() {
        return this.executionRole;
    }

    public final String workingDirectory() {
        return this.workingDirectory;
    }

    public final Long idleTimeoutSeconds() {
        return this.idleTimeoutSeconds;
    }

    public final EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.workingDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.idleTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionConfiguration)) {
            return false;
        }
        SessionConfiguration other = (SessionConfiguration)obj;
        return Objects.equals(this.executionRole(), other.executionRole()) && Objects.equals(this.workingDirectory(), other.workingDirectory()) && Objects.equals(this.idleTimeoutSeconds(), other.idleTimeoutSeconds()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"SessionConfiguration").add("ExecutionRole", (Object)this.executionRole()).add("WorkingDirectory", (Object)this.workingDirectory()).add("IdleTimeoutSeconds", (Object)this.idleTimeoutSeconds()).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExecutionRole": {
                return Optional.ofNullable(clazz.cast(this.executionRole()));
            }
            case "WorkingDirectory": {
                return Optional.ofNullable(clazz.cast(this.workingDirectory()));
            }
            case "IdleTimeoutSeconds": {
                return Optional.ofNullable(clazz.cast(this.idleTimeoutSeconds()));
            }
            case "EncryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SessionConfiguration, T> g) {
        return obj -> g.apply((SessionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String executionRole;
        private String workingDirectory;
        private Long idleTimeoutSeconds;
        private EncryptionConfiguration encryptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(SessionConfiguration model) {
            this.executionRole(model.executionRole);
            this.workingDirectory(model.workingDirectory);
            this.idleTimeoutSeconds(model.idleTimeoutSeconds);
            this.encryptionConfiguration(model.encryptionConfiguration);
        }

        public final String getExecutionRole() {
            return this.executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final String getWorkingDirectory() {
            return this.workingDirectory;
        }

        public final void setWorkingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
        }

        @Override
        public final Builder workingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public final Long getIdleTimeoutSeconds() {
            return this.idleTimeoutSeconds;
        }

        public final void setIdleTimeoutSeconds(Long idleTimeoutSeconds) {
            this.idleTimeoutSeconds = idleTimeoutSeconds;
        }

        @Override
        public final Builder idleTimeoutSeconds(Long idleTimeoutSeconds) {
            this.idleTimeoutSeconds = idleTimeoutSeconds;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public SessionConfiguration build() {
            return new SessionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SessionConfiguration> {
        public Builder executionRole(String var1);

        public Builder workingDirectory(String var1);

        public Builder idleTimeoutSeconds(Long var1);

        public Builder encryptionConfiguration(EncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((EncryptionConfiguration)((EncryptionConfiguration.Builder)EncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }
    }
}

