/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.athena.AthenaAsyncClient;
import software.amazon.awssdk.services.athena.internal.UserAgentUtils;
import software.amazon.awssdk.services.athena.model.ListQueryExecutionsRequest;
import software.amazon.awssdk.services.athena.model.ListQueryExecutionsResponse;

public class ListQueryExecutionsPublisher
implements SdkPublisher<ListQueryExecutionsResponse> {
    private final AthenaAsyncClient client;
    private final ListQueryExecutionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListQueryExecutionsPublisher(AthenaAsyncClient client, ListQueryExecutionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListQueryExecutionsPublisher(AthenaAsyncClient client, ListQueryExecutionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListQueryExecutionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListQueryExecutionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListQueryExecutionsResponseFetcher
    implements AsyncPageFetcher<ListQueryExecutionsResponse> {
        private ListQueryExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListQueryExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListQueryExecutionsResponse> nextPage(ListQueryExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListQueryExecutionsPublisher.this.client.listQueryExecutions(ListQueryExecutionsPublisher.this.firstRequest);
            }
            return ListQueryExecutionsPublisher.this.client.listQueryExecutions((ListQueryExecutionsRequest)((Object)ListQueryExecutionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

