/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.auditmanager.model.AssessmentReportDestinationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssessmentReportsDestination
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssessmentReportsDestination> {
    private static final SdkField<String> DESTINATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationType").getter(AssessmentReportsDestination.getter(AssessmentReportsDestination::destinationTypeAsString)).setter(AssessmentReportsDestination.setter(Builder::destinationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationType").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destination").getter(AssessmentReportsDestination.getter(AssessmentReportsDestination::destination)).setter(AssessmentReportsDestination.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_TYPE_FIELD, DESTINATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String destinationType;
    private final String destination;

    private AssessmentReportsDestination(BuilderImpl builder) {
        this.destinationType = builder.destinationType;
        this.destination = builder.destination;
    }

    public final AssessmentReportDestinationType destinationType() {
        return AssessmentReportDestinationType.fromValue(this.destinationType);
    }

    public final String destinationTypeAsString() {
        return this.destinationType;
    }

    public final String destination() {
        return this.destination;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentReportsDestination)) {
            return false;
        }
        AssessmentReportsDestination other = (AssessmentReportsDestination)obj;
        return Objects.equals(this.destinationTypeAsString(), other.destinationTypeAsString()) && Objects.equals(this.destination(), other.destination());
    }

    public final String toString() {
        return ToString.builder((String)"AssessmentReportsDestination").add("DestinationType", (Object)this.destinationTypeAsString()).add("Destination", (Object)this.destination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "destinationType": {
                return Optional.ofNullable(clazz.cast(this.destinationTypeAsString()));
            }
            case "destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssessmentReportsDestination, T> g) {
        return obj -> g.apply((AssessmentReportsDestination)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String destinationType;
        private String destination;

        private BuilderImpl() {
        }

        private BuilderImpl(AssessmentReportsDestination model) {
            this.destinationType(model.destinationType);
            this.destination(model.destination);
        }

        public final String getDestinationType() {
            return this.destinationType;
        }

        public final void setDestinationType(String destinationType) {
            this.destinationType = destinationType;
        }

        @Override
        public final Builder destinationType(String destinationType) {
            this.destinationType = destinationType;
            return this;
        }

        @Override
        public final Builder destinationType(AssessmentReportDestinationType destinationType) {
            this.destinationType(destinationType == null ? null : destinationType.toString());
            return this;
        }

        public final String getDestination() {
            return this.destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public AssessmentReportsDestination build() {
            return new AssessmentReportsDestination(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssessmentReportsDestination> {
        public Builder destinationType(String var1);

        public Builder destinationType(AssessmentReportDestinationType var1);

        public Builder destination(String var1);
    }
}

