/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.autoscaling.AutoScalingAsyncClient;
import software.amazon.awssdk.services.autoscaling.internal.UserAgentUtils;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingInstanceDetails;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesResponse;

public class DescribeAutoScalingInstancesPublisher
implements SdkPublisher<DescribeAutoScalingInstancesResponse> {
    private final AutoScalingAsyncClient client;
    private final DescribeAutoScalingInstancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeAutoScalingInstancesPublisher(AutoScalingAsyncClient client, DescribeAutoScalingInstancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeAutoScalingInstancesPublisher(AutoScalingAsyncClient client, DescribeAutoScalingInstancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeAutoScalingInstancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeAutoScalingInstancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AutoScalingInstanceDetails> autoScalingInstances() {
        Function<DescribeAutoScalingInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.autoScalingInstances() != null) {
                return response.autoScalingInstances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeAutoScalingInstancesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeAutoScalingInstancesResponseFetcher
    implements AsyncPageFetcher<DescribeAutoScalingInstancesResponse> {
        private DescribeAutoScalingInstancesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAutoScalingInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeAutoScalingInstancesResponse> nextPage(DescribeAutoScalingInstancesResponse previousPage) {
            if (previousPage == null) {
                return DescribeAutoScalingInstancesPublisher.this.client.describeAutoScalingInstances(DescribeAutoScalingInstancesPublisher.this.firstRequest);
            }
            return DescribeAutoScalingInstancesPublisher.this.client.describeAutoScalingInstances((DescribeAutoScalingInstancesRequest)((Object)DescribeAutoScalingInstancesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

