/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.b2bi.model.B2BiRequest;
import software.amazon.awssdk.services.b2bi.model.CapabilityConfiguration;
import software.amazon.awssdk.services.b2bi.model.InstructionsDocumentsCopier;
import software.amazon.awssdk.services.b2bi.model.S3Location;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCapabilityRequest
extends B2BiRequest
implements ToCopyableBuilder<Builder, UpdateCapabilityRequest> {
    private static final SdkField<String> CAPABILITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("capabilityId").getter(UpdateCapabilityRequest.getter(UpdateCapabilityRequest::capabilityId)).setter(UpdateCapabilityRequest.setter(Builder::capabilityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilityId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateCapabilityRequest.getter(UpdateCapabilityRequest::name)).setter(UpdateCapabilityRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<CapabilityConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(UpdateCapabilityRequest.getter(UpdateCapabilityRequest::configuration)).setter(UpdateCapabilityRequest.setter(Builder::configuration)).constructor(CapabilityConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<List<S3Location>> INSTRUCTIONS_DOCUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("instructionsDocuments").getter(UpdateCapabilityRequest.getter(UpdateCapabilityRequest::instructionsDocuments)).setter(UpdateCapabilityRequest.setter(Builder::instructionsDocuments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instructionsDocuments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPABILITY_ID_FIELD, NAME_FIELD, CONFIGURATION_FIELD, INSTRUCTIONS_DOCUMENTS_FIELD));
    private final String capabilityId;
    private final String name;
    private final CapabilityConfiguration configuration;
    private final List<S3Location> instructionsDocuments;

    private UpdateCapabilityRequest(BuilderImpl builder) {
        super(builder);
        this.capabilityId = builder.capabilityId;
        this.name = builder.name;
        this.configuration = builder.configuration;
        this.instructionsDocuments = builder.instructionsDocuments;
    }

    public final String capabilityId() {
        return this.capabilityId;
    }

    public final String name() {
        return this.name;
    }

    public final CapabilityConfiguration configuration() {
        return this.configuration;
    }

    public final boolean hasInstructionsDocuments() {
        return this.instructionsDocuments != null && !(this.instructionsDocuments instanceof SdkAutoConstructList);
    }

    public final List<S3Location> instructionsDocuments() {
        return this.instructionsDocuments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstructionsDocuments() ? this.instructionsDocuments() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCapabilityRequest)) {
            return false;
        }
        UpdateCapabilityRequest other = (UpdateCapabilityRequest)((Object)obj);
        return Objects.equals(this.capabilityId(), other.capabilityId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.configuration(), other.configuration()) && this.hasInstructionsDocuments() == other.hasInstructionsDocuments() && Objects.equals(this.instructionsDocuments(), other.instructionsDocuments());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateCapabilityRequest").add("CapabilityId", (Object)this.capabilityId()).add("Name", (Object)this.name()).add("Configuration", (Object)this.configuration()).add("InstructionsDocuments", this.hasInstructionsDocuments() ? this.instructionsDocuments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "capabilityId": {
                return Optional.ofNullable(clazz.cast(this.capabilityId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "instructionsDocuments": {
                return Optional.ofNullable(clazz.cast(this.instructionsDocuments()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCapabilityRequest, T> g) {
        return obj -> g.apply((UpdateCapabilityRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends B2BiRequest.BuilderImpl
    implements Builder {
        private String capabilityId;
        private String name;
        private CapabilityConfiguration configuration;
        private List<S3Location> instructionsDocuments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCapabilityRequest model) {
            super(model);
            this.capabilityId(model.capabilityId);
            this.name(model.name);
            this.configuration(model.configuration);
            this.instructionsDocuments(model.instructionsDocuments);
        }

        public final String getCapabilityId() {
            return this.capabilityId;
        }

        public final void setCapabilityId(String capabilityId) {
            this.capabilityId = capabilityId;
        }

        @Override
        public final Builder capabilityId(String capabilityId) {
            this.capabilityId = capabilityId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final CapabilityConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(CapabilityConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(CapabilityConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final List<S3Location.Builder> getInstructionsDocuments() {
            List<S3Location.Builder> result = InstructionsDocumentsCopier.copyToBuilder(this.instructionsDocuments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstructionsDocuments(Collection<S3Location.BuilderImpl> instructionsDocuments) {
            this.instructionsDocuments = InstructionsDocumentsCopier.copyFromBuilder(instructionsDocuments);
        }

        @Override
        public final Builder instructionsDocuments(Collection<S3Location> instructionsDocuments) {
            this.instructionsDocuments = InstructionsDocumentsCopier.copy(instructionsDocuments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instructionsDocuments(S3Location ... instructionsDocuments) {
            this.instructionsDocuments(Arrays.asList(instructionsDocuments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instructionsDocuments(Consumer<S3Location.Builder> ... instructionsDocuments) {
            this.instructionsDocuments(Stream.of(instructionsDocuments).map(c -> (S3Location)((S3Location.Builder)S3Location.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCapabilityRequest build() {
            return new UpdateCapabilityRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends B2BiRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateCapabilityRequest> {
        public Builder capabilityId(String var1);

        public Builder name(String var1);

        public Builder configuration(CapabilityConfiguration var1);

        default public Builder configuration(Consumer<CapabilityConfiguration.Builder> configuration) {
            return this.configuration((CapabilityConfiguration)((CapabilityConfiguration.Builder)CapabilityConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder instructionsDocuments(Collection<S3Location> var1);

        public Builder instructionsDocuments(S3Location ... var1);

        public Builder instructionsDocuments(Consumer<S3Location.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

