/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.b2bi.B2BiAsyncClient;
import software.amazon.awssdk.services.b2bi.internal.UserAgentUtils;
import software.amazon.awssdk.services.b2bi.model.ListProfilesRequest;
import software.amazon.awssdk.services.b2bi.model.ListProfilesResponse;
import software.amazon.awssdk.services.b2bi.model.ProfileSummary;

public class ListProfilesPublisher
implements SdkPublisher<ListProfilesResponse> {
    private final B2BiAsyncClient client;
    private final ListProfilesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProfilesPublisher(B2BiAsyncClient client, ListProfilesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProfilesPublisher(B2BiAsyncClient client, ListProfilesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProfilesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProfilesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ProfileSummary> profiles() {
        Function<ListProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.profiles() != null) {
                return response.profiles().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListProfilesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListProfilesResponseFetcher
    implements AsyncPageFetcher<ListProfilesResponse> {
        private ListProfilesResponseFetcher() {
        }

        public boolean hasNextPage(ListProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListProfilesResponse> nextPage(ListProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListProfilesPublisher.this.client.listProfiles(ListProfilesPublisher.this.firstRequest);
            }
            return ListProfilesPublisher.this.client.listProfiles((ListProfilesRequest)((Object)ListProfilesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

