/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.AdvancedBackupSetting;
import software.amazon.awssdk.services.backup.model.AdvancedBackupSettingsCopier;
import software.amazon.awssdk.services.backup.model.BackupRule;
import software.amazon.awssdk.services.backup.model.BackupRulesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BackupPlan
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BackupPlan> {
    private static final SdkField<String> BACKUP_PLAN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupPlanName").getter(BackupPlan.getter(BackupPlan::backupPlanName)).setter(BackupPlan.setter(Builder::backupPlanName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanName").build()}).build();
    private static final SdkField<List<BackupRule>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Rules").getter(BackupPlan.getter(BackupPlan::rules)).setter(BackupPlan.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BackupRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AdvancedBackupSetting>> ADVANCED_BACKUP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdvancedBackupSettings").getter(BackupPlan.getter(BackupPlan::advancedBackupSettings)).setter(BackupPlan.setter(Builder::advancedBackupSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedBackupSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AdvancedBackupSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_PLAN_NAME_FIELD, RULES_FIELD, ADVANCED_BACKUP_SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String backupPlanName;
    private final List<BackupRule> rules;
    private final List<AdvancedBackupSetting> advancedBackupSettings;

    private BackupPlan(BuilderImpl builder) {
        this.backupPlanName = builder.backupPlanName;
        this.rules = builder.rules;
        this.advancedBackupSettings = builder.advancedBackupSettings;
    }

    public final String backupPlanName() {
        return this.backupPlanName;
    }

    public final boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public final List<BackupRule> rules() {
        return this.rules;
    }

    public final boolean hasAdvancedBackupSettings() {
        return this.advancedBackupSettings != null && !(this.advancedBackupSettings instanceof SdkAutoConstructList);
    }

    public final List<AdvancedBackupSetting> advancedBackupSettings() {
        return this.advancedBackupSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.backupPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRules() ? this.rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdvancedBackupSettings() ? this.advancedBackupSettings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackupPlan)) {
            return false;
        }
        BackupPlan other = (BackupPlan)obj;
        return Objects.equals(this.backupPlanName(), other.backupPlanName()) && this.hasRules() == other.hasRules() && Objects.equals(this.rules(), other.rules()) && this.hasAdvancedBackupSettings() == other.hasAdvancedBackupSettings() && Objects.equals(this.advancedBackupSettings(), other.advancedBackupSettings());
    }

    public final String toString() {
        return ToString.builder((String)"BackupPlan").add("BackupPlanName", (Object)this.backupPlanName()).add("Rules", this.hasRules() ? this.rules() : null).add("AdvancedBackupSettings", this.hasAdvancedBackupSettings() ? this.advancedBackupSettings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupPlanName": {
                return Optional.ofNullable(clazz.cast(this.backupPlanName()));
            }
            case "Rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
            case "AdvancedBackupSettings": {
                return Optional.ofNullable(clazz.cast(this.advancedBackupSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BackupPlan, T> g) {
        return obj -> g.apply((BackupPlan)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String backupPlanName;
        private List<BackupRule> rules = DefaultSdkAutoConstructList.getInstance();
        private List<AdvancedBackupSetting> advancedBackupSettings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BackupPlan model) {
            this.backupPlanName(model.backupPlanName);
            this.rules(model.rules);
            this.advancedBackupSettings(model.advancedBackupSettings);
        }

        public final String getBackupPlanName() {
            return this.backupPlanName;
        }

        public final void setBackupPlanName(String backupPlanName) {
            this.backupPlanName = backupPlanName;
        }

        @Override
        public final Builder backupPlanName(String backupPlanName) {
            this.backupPlanName = backupPlanName;
            return this;
        }

        public final List<BackupRule.Builder> getRules() {
            List<BackupRule.Builder> result = BackupRulesCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<BackupRule.BuilderImpl> rules) {
            this.rules = BackupRulesCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<BackupRule> rules) {
            this.rules = BackupRulesCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(BackupRule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<BackupRule.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (BackupRule)((BackupRule.Builder)BackupRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AdvancedBackupSetting.Builder> getAdvancedBackupSettings() {
            List<AdvancedBackupSetting.Builder> result = AdvancedBackupSettingsCopier.copyToBuilder(this.advancedBackupSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdvancedBackupSettings(Collection<AdvancedBackupSetting.BuilderImpl> advancedBackupSettings) {
            this.advancedBackupSettings = AdvancedBackupSettingsCopier.copyFromBuilder(advancedBackupSettings);
        }

        @Override
        public final Builder advancedBackupSettings(Collection<AdvancedBackupSetting> advancedBackupSettings) {
            this.advancedBackupSettings = AdvancedBackupSettingsCopier.copy(advancedBackupSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder advancedBackupSettings(AdvancedBackupSetting ... advancedBackupSettings) {
            this.advancedBackupSettings(Arrays.asList(advancedBackupSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder advancedBackupSettings(Consumer<AdvancedBackupSetting.Builder> ... advancedBackupSettings) {
            this.advancedBackupSettings(Stream.of(advancedBackupSettings).map(c -> (AdvancedBackupSetting)((AdvancedBackupSetting.Builder)AdvancedBackupSetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public BackupPlan build() {
            return new BackupPlan(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BackupPlan> {
        public Builder backupPlanName(String var1);

        public Builder rules(Collection<BackupRule> var1);

        public Builder rules(BackupRule ... var1);

        public Builder rules(Consumer<BackupRule.Builder> ... var1);

        public Builder advancedBackupSettings(Collection<AdvancedBackupSetting> var1);

        public Builder advancedBackupSettings(AdvancedBackupSetting ... var1);

        public Builder advancedBackupSettings(Consumer<AdvancedBackupSetting.Builder> ... var1);
    }
}

