/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupClient;
import software.amazon.awssdk.services.backup.internal.UserAgentUtils;
import software.amazon.awssdk.services.backup.model.ListReportPlansRequest;
import software.amazon.awssdk.services.backup.model.ListReportPlansResponse;

public class ListReportPlansIterable
implements SdkIterable<ListReportPlansResponse> {
    private final BackupClient client;
    private final ListReportPlansRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListReportPlansIterable(BackupClient client, ListReportPlansRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListReportPlansResponseFetcher();
    }

    public Iterator<ListReportPlansResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListReportPlansResponseFetcher
    implements SyncPageFetcher<ListReportPlansResponse> {
        private ListReportPlansResponseFetcher() {
        }

        public boolean hasNextPage(ListReportPlansResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListReportPlansResponse nextPage(ListReportPlansResponse previousPage) {
            if (previousPage == null) {
                return ListReportPlansIterable.this.client.listReportPlans(ListReportPlansIterable.this.firstRequest);
            }
            return ListReportPlansIterable.this.client.listReportPlans((ListReportPlansRequest)((Object)ListReportPlansIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

