/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConditionType {
    STRINGEQUALS("STRINGEQUALS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConditionType> VALUE_MAP;
    private final String value;

    private ConditionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConditionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConditionType> knownValues() {
        EnumSet<ConditionType> knownValues = EnumSet.allOf(ConditionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConditionType.class, ConditionType::toString);
    }
}

