/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.BackupPlansListCopier;
import software.amazon.awssdk.services.backup.model.BackupPlansListMember;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBackupPlansResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, ListBackupPlansResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListBackupPlansResponse.getter(ListBackupPlansResponse::nextToken)).setter(ListBackupPlansResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<BackupPlansListMember>> BACKUP_PLANS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BackupPlansList").getter(ListBackupPlansResponse.getter(ListBackupPlansResponse::backupPlansList)).setter(ListBackupPlansResponse.setter(Builder::backupPlansList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlansList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BackupPlansListMember::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, BACKUP_PLANS_LIST_FIELD));
    private final String nextToken;
    private final List<BackupPlansListMember> backupPlansList;

    private ListBackupPlansResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.backupPlansList = builder.backupPlansList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasBackupPlansList() {
        return this.backupPlansList != null && !(this.backupPlansList instanceof SdkAutoConstructList);
    }

    public final List<BackupPlansListMember> backupPlansList() {
        return this.backupPlansList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBackupPlansList() ? this.backupPlansList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBackupPlansResponse)) {
            return false;
        }
        ListBackupPlansResponse other = (ListBackupPlansResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasBackupPlansList() == other.hasBackupPlansList() && Objects.equals(this.backupPlansList(), other.backupPlansList());
    }

    public final String toString() {
        return ToString.builder((String)"ListBackupPlansResponse").add("NextToken", (Object)this.nextToken()).add("BackupPlansList", this.hasBackupPlansList() ? this.backupPlansList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "BackupPlansList": {
                return Optional.ofNullable(clazz.cast(this.backupPlansList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBackupPlansResponse, T> g) {
        return obj -> g.apply((ListBackupPlansResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<BackupPlansListMember> backupPlansList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListBackupPlansResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.backupPlansList(model.backupPlansList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<BackupPlansListMember.Builder> getBackupPlansList() {
            List<BackupPlansListMember.Builder> result = BackupPlansListCopier.copyToBuilder(this.backupPlansList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBackupPlansList(Collection<BackupPlansListMember.BuilderImpl> backupPlansList) {
            this.backupPlansList = BackupPlansListCopier.copyFromBuilder(backupPlansList);
        }

        @Override
        public final Builder backupPlansList(Collection<BackupPlansListMember> backupPlansList) {
            this.backupPlansList = BackupPlansListCopier.copy(backupPlansList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backupPlansList(BackupPlansListMember ... backupPlansList) {
            this.backupPlansList(Arrays.asList(backupPlansList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backupPlansList(Consumer<BackupPlansListMember.Builder> ... backupPlansList) {
            this.backupPlansList(Stream.of(backupPlansList).map(c -> (BackupPlansListMember)((BackupPlansListMember.Builder)BackupPlansListMember.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListBackupPlansResponse build() {
            return new ListBackupPlansResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBackupPlansResponse> {
        public Builder nextToken(String var1);

        public Builder backupPlansList(Collection<BackupPlansListMember> var1);

        public Builder backupPlansList(BackupPlansListMember ... var1);

        public Builder backupPlansList(Consumer<BackupPlansListMember.Builder> ... var1);
    }
}

