/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupClient;
import software.amazon.awssdk.services.backup.internal.UserAgentUtils;
import software.amazon.awssdk.services.backup.model.ListProtectedResourcesRequest;
import software.amazon.awssdk.services.backup.model.ListProtectedResourcesResponse;
import software.amazon.awssdk.services.backup.model.ProtectedResource;

public class ListProtectedResourcesIterable
implements SdkIterable<ListProtectedResourcesResponse> {
    private final BackupClient client;
    private final ListProtectedResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProtectedResourcesIterable(BackupClient client, ListProtectedResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListProtectedResourcesResponseFetcher();
    }

    public Iterator<ListProtectedResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProtectedResource> results() {
        Function<ListProtectedResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.results() != null) {
                return response.results().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListProtectedResourcesResponseFetcher
    implements SyncPageFetcher<ListProtectedResourcesResponse> {
        private ListProtectedResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListProtectedResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProtectedResourcesResponse nextPage(ListProtectedResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListProtectedResourcesIterable.this.client.listProtectedResources(ListProtectedResourcesIterable.this.firstRequest);
            }
            return ListProtectedResourcesIterable.this.client.listProtectedResources((ListProtectedResourcesRequest)((Object)ListProtectedResourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

