/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProtectedResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProtectedResource> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(ProtectedResource.getter(ProtectedResource::resourceArn)).setter(ProtectedResource.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(ProtectedResource.getter(ProtectedResource::resourceType)).setter(ProtectedResource.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<Instant> LAST_BACKUP_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastBackupTime").getter(ProtectedResource.getter(ProtectedResource::lastBackupTime)).setter(ProtectedResource.setter(Builder::lastBackupTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastBackupTime").build()}).build();
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceName").getter(ProtectedResource.getter(ProtectedResource::resourceName)).setter(ProtectedResource.setter(Builder::resourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceName").build()}).build();
    private static final SdkField<String> LAST_BACKUP_VAULT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastBackupVaultArn").getter(ProtectedResource.getter(ProtectedResource::lastBackupVaultArn)).setter(ProtectedResource.setter(Builder::lastBackupVaultArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastBackupVaultArn").build()}).build();
    private static final SdkField<String> LAST_RECOVERY_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastRecoveryPointArn").getter(ProtectedResource.getter(ProtectedResource::lastRecoveryPointArn)).setter(ProtectedResource.setter(Builder::lastRecoveryPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRecoveryPointArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, RESOURCE_TYPE_FIELD, LAST_BACKUP_TIME_FIELD, RESOURCE_NAME_FIELD, LAST_BACKUP_VAULT_ARN_FIELD, LAST_RECOVERY_POINT_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProtectedResource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String resourceArn;
    private final String resourceType;
    private final Instant lastBackupTime;
    private final String resourceName;
    private final String lastBackupVaultArn;
    private final String lastRecoveryPointArn;

    private ProtectedResource(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.resourceType = builder.resourceType;
        this.lastBackupTime = builder.lastBackupTime;
        this.resourceName = builder.resourceName;
        this.lastBackupVaultArn = builder.lastBackupVaultArn;
        this.lastRecoveryPointArn = builder.lastRecoveryPointArn;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final Instant lastBackupTime() {
        return this.lastBackupTime;
    }

    public final String resourceName() {
        return this.resourceName;
    }

    public final String lastBackupVaultArn() {
        return this.lastBackupVaultArn;
    }

    public final String lastRecoveryPointArn() {
        return this.lastRecoveryPointArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastBackupTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastBackupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRecoveryPointArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectedResource)) {
            return false;
        }
        ProtectedResource other = (ProtectedResource)obj;
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.lastBackupTime(), other.lastBackupTime()) && Objects.equals(this.resourceName(), other.resourceName()) && Objects.equals(this.lastBackupVaultArn(), other.lastBackupVaultArn()) && Objects.equals(this.lastRecoveryPointArn(), other.lastRecoveryPointArn());
    }

    public final String toString() {
        return ToString.builder((String)"ProtectedResource").add("ResourceArn", (Object)this.resourceArn()).add("ResourceType", (Object)this.resourceType()).add("LastBackupTime", (Object)this.lastBackupTime()).add("ResourceName", (Object)this.resourceName()).add("LastBackupVaultArn", (Object)this.lastBackupVaultArn()).add("LastRecoveryPointArn", (Object)this.lastRecoveryPointArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "LastBackupTime": {
                return Optional.ofNullable(clazz.cast(this.lastBackupTime()));
            }
            case "ResourceName": {
                return Optional.ofNullable(clazz.cast(this.resourceName()));
            }
            case "LastBackupVaultArn": {
                return Optional.ofNullable(clazz.cast(this.lastBackupVaultArn()));
            }
            case "LastRecoveryPointArn": {
                return Optional.ofNullable(clazz.cast(this.lastRecoveryPointArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("LastBackupTime", LAST_BACKUP_TIME_FIELD);
        map.put("ResourceName", RESOURCE_NAME_FIELD);
        map.put("LastBackupVaultArn", LAST_BACKUP_VAULT_ARN_FIELD);
        map.put("LastRecoveryPointArn", LAST_RECOVERY_POINT_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProtectedResource, T> g) {
        return obj -> g.apply((ProtectedResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceArn;
        private String resourceType;
        private Instant lastBackupTime;
        private String resourceName;
        private String lastBackupVaultArn;
        private String lastRecoveryPointArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectedResource model) {
            this.resourceArn(model.resourceArn);
            this.resourceType(model.resourceType);
            this.lastBackupTime(model.lastBackupTime);
            this.resourceName(model.resourceName);
            this.lastBackupVaultArn(model.lastBackupVaultArn);
            this.lastRecoveryPointArn(model.lastRecoveryPointArn);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final Instant getLastBackupTime() {
            return this.lastBackupTime;
        }

        public final void setLastBackupTime(Instant lastBackupTime) {
            this.lastBackupTime = lastBackupTime;
        }

        @Override
        public final Builder lastBackupTime(Instant lastBackupTime) {
            this.lastBackupTime = lastBackupTime;
            return this;
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getLastBackupVaultArn() {
            return this.lastBackupVaultArn;
        }

        public final void setLastBackupVaultArn(String lastBackupVaultArn) {
            this.lastBackupVaultArn = lastBackupVaultArn;
        }

        @Override
        public final Builder lastBackupVaultArn(String lastBackupVaultArn) {
            this.lastBackupVaultArn = lastBackupVaultArn;
            return this;
        }

        public final String getLastRecoveryPointArn() {
            return this.lastRecoveryPointArn;
        }

        public final void setLastRecoveryPointArn(String lastRecoveryPointArn) {
            this.lastRecoveryPointArn = lastRecoveryPointArn;
        }

        @Override
        public final Builder lastRecoveryPointArn(String lastRecoveryPointArn) {
            this.lastRecoveryPointArn = lastRecoveryPointArn;
            return this;
        }

        public ProtectedResource build() {
            return new ProtectedResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProtectedResource> {
        public Builder resourceArn(String var1);

        public Builder resourceType(String var1);

        public Builder lastBackupTime(Instant var1);

        public Builder resourceName(String var1);

        public Builder lastBackupVaultArn(String var1);

        public Builder lastRecoveryPointArn(String var1);
    }
}

