/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.ResourceSelection;
import software.amazon.awssdk.services.backup.model.ResourceSelectionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TieringConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TieringConfiguration> {
    private static final SdkField<String> TIERING_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TieringConfigurationName").getter(TieringConfiguration.getter(TieringConfiguration::tieringConfigurationName)).setter(TieringConfiguration.setter(Builder::tieringConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TieringConfigurationName").build()}).build();
    private static final SdkField<String> TIERING_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TieringConfigurationArn").getter(TieringConfiguration.getter(TieringConfiguration::tieringConfigurationArn)).setter(TieringConfiguration.setter(Builder::tieringConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TieringConfigurationArn").build()}).build();
    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupVaultName").getter(TieringConfiguration.getter(TieringConfiguration::backupVaultName)).setter(TieringConfiguration.setter(Builder::backupVaultName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultName").build()}).build();
    private static final SdkField<List<ResourceSelection>> RESOURCE_SELECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceSelection").getter(TieringConfiguration.getter(TieringConfiguration::resourceSelection)).setter(TieringConfiguration.setter(Builder::resourceSelection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSelection").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceSelection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatorRequestId").getter(TieringConfiguration.getter(TieringConfiguration::creatorRequestId)).setter(TieringConfiguration.setter(Builder::creatorRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(TieringConfiguration.getter(TieringConfiguration::creationTime)).setter(TieringConfiguration.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(TieringConfiguration.getter(TieringConfiguration::lastUpdatedTime)).setter(TieringConfiguration.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIERING_CONFIGURATION_NAME_FIELD, TIERING_CONFIGURATION_ARN_FIELD, BACKUP_VAULT_NAME_FIELD, RESOURCE_SELECTION_FIELD, CREATOR_REQUEST_ID_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TieringConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String tieringConfigurationName;
    private final String tieringConfigurationArn;
    private final String backupVaultName;
    private final List<ResourceSelection> resourceSelection;
    private final String creatorRequestId;
    private final Instant creationTime;
    private final Instant lastUpdatedTime;

    private TieringConfiguration(BuilderImpl builder) {
        this.tieringConfigurationName = builder.tieringConfigurationName;
        this.tieringConfigurationArn = builder.tieringConfigurationArn;
        this.backupVaultName = builder.backupVaultName;
        this.resourceSelection = builder.resourceSelection;
        this.creatorRequestId = builder.creatorRequestId;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    public final String tieringConfigurationName() {
        return this.tieringConfigurationName;
    }

    public final String tieringConfigurationArn() {
        return this.tieringConfigurationArn;
    }

    public final String backupVaultName() {
        return this.backupVaultName;
    }

    public final boolean hasResourceSelection() {
        return this.resourceSelection != null && !(this.resourceSelection instanceof SdkAutoConstructList);
    }

    public final List<ResourceSelection> resourceSelection() {
        return this.resourceSelection;
    }

    public final String creatorRequestId() {
        return this.creatorRequestId;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tieringConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tieringConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceSelection() ? this.resourceSelection() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TieringConfiguration)) {
            return false;
        }
        TieringConfiguration other = (TieringConfiguration)obj;
        return Objects.equals(this.tieringConfigurationName(), other.tieringConfigurationName()) && Objects.equals(this.tieringConfigurationArn(), other.tieringConfigurationArn()) && Objects.equals(this.backupVaultName(), other.backupVaultName()) && this.hasResourceSelection() == other.hasResourceSelection() && Objects.equals(this.resourceSelection(), other.resourceSelection()) && Objects.equals(this.creatorRequestId(), other.creatorRequestId()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime());
    }

    public final String toString() {
        return ToString.builder((String)"TieringConfiguration").add("TieringConfigurationName", (Object)this.tieringConfigurationName()).add("TieringConfigurationArn", (Object)this.tieringConfigurationArn()).add("BackupVaultName", (Object)this.backupVaultName()).add("ResourceSelection", this.hasResourceSelection() ? this.resourceSelection() : null).add("CreatorRequestId", (Object)this.creatorRequestId()).add("CreationTime", (Object)this.creationTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TieringConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.tieringConfigurationName()));
            }
            case "TieringConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.tieringConfigurationArn()));
            }
            case "BackupVaultName": {
                return Optional.ofNullable(clazz.cast(this.backupVaultName()));
            }
            case "ResourceSelection": {
                return Optional.ofNullable(clazz.cast(this.resourceSelection()));
            }
            case "CreatorRequestId": {
                return Optional.ofNullable(clazz.cast(this.creatorRequestId()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TieringConfigurationName", TIERING_CONFIGURATION_NAME_FIELD);
        map.put("TieringConfigurationArn", TIERING_CONFIGURATION_ARN_FIELD);
        map.put("BackupVaultName", BACKUP_VAULT_NAME_FIELD);
        map.put("ResourceSelection", RESOURCE_SELECTION_FIELD);
        map.put("CreatorRequestId", CREATOR_REQUEST_ID_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TieringConfiguration, T> g) {
        return obj -> g.apply((TieringConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tieringConfigurationName;
        private String tieringConfigurationArn;
        private String backupVaultName;
        private List<ResourceSelection> resourceSelection = DefaultSdkAutoConstructList.getInstance();
        private String creatorRequestId;
        private Instant creationTime;
        private Instant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(TieringConfiguration model) {
            this.tieringConfigurationName(model.tieringConfigurationName);
            this.tieringConfigurationArn(model.tieringConfigurationArn);
            this.backupVaultName(model.backupVaultName);
            this.resourceSelection(model.resourceSelection);
            this.creatorRequestId(model.creatorRequestId);
            this.creationTime(model.creationTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
        }

        public final String getTieringConfigurationName() {
            return this.tieringConfigurationName;
        }

        public final void setTieringConfigurationName(String tieringConfigurationName) {
            this.tieringConfigurationName = tieringConfigurationName;
        }

        @Override
        public final Builder tieringConfigurationName(String tieringConfigurationName) {
            this.tieringConfigurationName = tieringConfigurationName;
            return this;
        }

        public final String getTieringConfigurationArn() {
            return this.tieringConfigurationArn;
        }

        public final void setTieringConfigurationArn(String tieringConfigurationArn) {
            this.tieringConfigurationArn = tieringConfigurationArn;
        }

        @Override
        public final Builder tieringConfigurationArn(String tieringConfigurationArn) {
            this.tieringConfigurationArn = tieringConfigurationArn;
            return this;
        }

        public final String getBackupVaultName() {
            return this.backupVaultName;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final List<ResourceSelection.Builder> getResourceSelection() {
            List<ResourceSelection.Builder> result = ResourceSelectionsCopier.copyToBuilder(this.resourceSelection);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceSelection(Collection<ResourceSelection.BuilderImpl> resourceSelection) {
            this.resourceSelection = ResourceSelectionsCopier.copyFromBuilder(resourceSelection);
        }

        @Override
        public final Builder resourceSelection(Collection<ResourceSelection> resourceSelection) {
            this.resourceSelection = ResourceSelectionsCopier.copy(resourceSelection);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceSelection(ResourceSelection ... resourceSelection) {
            this.resourceSelection(Arrays.asList(resourceSelection));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceSelection(Consumer<ResourceSelection.Builder> ... resourceSelection) {
            this.resourceSelection(Stream.of(resourceSelection).map(c -> (ResourceSelection)((ResourceSelection.Builder)ResourceSelection.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCreatorRequestId() {
            return this.creatorRequestId;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public TieringConfiguration build() {
            return new TieringConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TieringConfiguration> {
        public Builder tieringConfigurationName(String var1);

        public Builder tieringConfigurationArn(String var1);

        public Builder backupVaultName(String var1);

        public Builder resourceSelection(Collection<ResourceSelection> var1);

        public Builder resourceSelection(ResourceSelection ... var1);

        public Builder resourceSelection(Consumer<ResourceSelection.Builder> ... var1);

        public Builder creatorRequestId(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);
    }
}

