/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFrameworkResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, UpdateFrameworkResponse> {
    private static final SdkField<String> FRAMEWORK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FrameworkName").getter(UpdateFrameworkResponse.getter(UpdateFrameworkResponse::frameworkName)).setter(UpdateFrameworkResponse.setter(Builder::frameworkName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkName").build()}).build();
    private static final SdkField<String> FRAMEWORK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FrameworkArn").getter(UpdateFrameworkResponse.getter(UpdateFrameworkResponse::frameworkArn)).setter(UpdateFrameworkResponse.setter(Builder::frameworkArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(UpdateFrameworkResponse.getter(UpdateFrameworkResponse::creationTime)).setter(UpdateFrameworkResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAMEWORK_NAME_FIELD, FRAMEWORK_ARN_FIELD, CREATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateFrameworkResponse.memberNameToFieldInitializer();
    private final String frameworkName;
    private final String frameworkArn;
    private final Instant creationTime;

    private UpdateFrameworkResponse(BuilderImpl builder) {
        super(builder);
        this.frameworkName = builder.frameworkName;
        this.frameworkArn = builder.frameworkArn;
        this.creationTime = builder.creationTime;
    }

    public final String frameworkName() {
        return this.frameworkName;
    }

    public final String frameworkArn() {
        return this.frameworkArn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.frameworkName());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameworkArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFrameworkResponse)) {
            return false;
        }
        UpdateFrameworkResponse other = (UpdateFrameworkResponse)((Object)obj);
        return Objects.equals(this.frameworkName(), other.frameworkName()) && Objects.equals(this.frameworkArn(), other.frameworkArn()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFrameworkResponse").add("FrameworkName", (Object)this.frameworkName()).add("FrameworkArn", (Object)this.frameworkArn()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FrameworkName": {
                return Optional.ofNullable(clazz.cast(this.frameworkName()));
            }
            case "FrameworkArn": {
                return Optional.ofNullable(clazz.cast(this.frameworkArn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FrameworkName", FRAMEWORK_NAME_FIELD);
        map.put("FrameworkArn", FRAMEWORK_ARN_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateFrameworkResponse, T> g) {
        return obj -> g.apply((UpdateFrameworkResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private String frameworkName;
        private String frameworkArn;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFrameworkResponse model) {
            super(model);
            this.frameworkName(model.frameworkName);
            this.frameworkArn(model.frameworkArn);
            this.creationTime(model.creationTime);
        }

        public final String getFrameworkName() {
            return this.frameworkName;
        }

        public final void setFrameworkName(String frameworkName) {
            this.frameworkName = frameworkName;
        }

        @Override
        public final Builder frameworkName(String frameworkName) {
            this.frameworkName = frameworkName;
            return this;
        }

        public final String getFrameworkArn() {
            return this.frameworkArn;
        }

        public final void setFrameworkArn(String frameworkArn) {
            this.frameworkArn = frameworkArn;
        }

        @Override
        public final Builder frameworkArn(String frameworkArn) {
            this.frameworkArn = frameworkArn;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public UpdateFrameworkResponse build() {
            return new UpdateFrameworkResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFrameworkResponse> {
        public Builder frameworkName(String var1);

        public Builder frameworkArn(String var1);

        public Builder creationTime(Instant var1);
    }
}

