/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupClient;
import software.amazon.awssdk.services.backup.internal.UserAgentUtils;
import software.amazon.awssdk.services.backup.model.ListRestoreJobsByProtectedResourceRequest;
import software.amazon.awssdk.services.backup.model.ListRestoreJobsByProtectedResourceResponse;
import software.amazon.awssdk.services.backup.model.RestoreJobsListMember;

public class ListRestoreJobsByProtectedResourceIterable
implements SdkIterable<ListRestoreJobsByProtectedResourceResponse> {
    private final BackupClient client;
    private final ListRestoreJobsByProtectedResourceRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRestoreJobsByProtectedResourceIterable(BackupClient client, ListRestoreJobsByProtectedResourceRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRestoreJobsByProtectedResourceResponseFetcher();
    }

    public Iterator<ListRestoreJobsByProtectedResourceResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RestoreJobsListMember> restoreJobs() {
        Function<ListRestoreJobsByProtectedResourceResponse, Iterator> getIterator = response -> {
            if (response != null && response.restoreJobs() != null) {
                return response.restoreJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRestoreJobsByProtectedResourceResponseFetcher
    implements SyncPageFetcher<ListRestoreJobsByProtectedResourceResponse> {
        private ListRestoreJobsByProtectedResourceResponseFetcher() {
        }

        public boolean hasNextPage(ListRestoreJobsByProtectedResourceResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRestoreJobsByProtectedResourceResponse nextPage(ListRestoreJobsByProtectedResourceResponse previousPage) {
            if (previousPage == null) {
                return ListRestoreJobsByProtectedResourceIterable.this.client.listRestoreJobsByProtectedResource(ListRestoreJobsByProtectedResourceIterable.this.firstRequest);
            }
            return ListRestoreJobsByProtectedResourceIterable.this.client.listRestoreJobsByProtectedResource((ListRestoreJobsByProtectedResourceRequest)((Object)ListRestoreJobsByProtectedResourceIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

