/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupClient;
import software.amazon.awssdk.services.backup.internal.UserAgentUtils;
import software.amazon.awssdk.services.backup.model.ListScanJobSummariesRequest;
import software.amazon.awssdk.services.backup.model.ListScanJobSummariesResponse;
import software.amazon.awssdk.services.backup.model.ScanJobSummary;

public class ListScanJobSummariesIterable
implements SdkIterable<ListScanJobSummariesResponse> {
    private final BackupClient client;
    private final ListScanJobSummariesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListScanJobSummariesIterable(BackupClient client, ListScanJobSummariesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListScanJobSummariesResponseFetcher();
    }

    public Iterator<ListScanJobSummariesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ScanJobSummary> scanJobSummaries() {
        Function<ListScanJobSummariesResponse, Iterator> getIterator = response -> {
            if (response != null && response.scanJobSummaries() != null) {
                return response.scanJobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListScanJobSummariesResponseFetcher
    implements SyncPageFetcher<ListScanJobSummariesResponse> {
        private ListScanJobSummariesResponseFetcher() {
        }

        public boolean hasNextPage(ListScanJobSummariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListScanJobSummariesResponse nextPage(ListScanJobSummariesResponse previousPage) {
            if (previousPage == null) {
                return ListScanJobSummariesIterable.this.client.listScanJobSummaries(ListScanJobSummariesIterable.this.firstRequest);
            }
            return ListScanJobSummariesIterable.this.client.listScanJobSummaries((ListScanJobSummariesRequest)((Object)ListScanJobSummariesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

