/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupstorage.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class NotifyObjectCompleteRequest extends BackupStorageRequest implements
        ToCopyableBuilder<NotifyObjectCompleteRequest.Builder, NotifyObjectCompleteRequest> {
    private static final SdkField<String> BACKUP_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupJobId").getter(getter(NotifyObjectCompleteRequest::backupJobId))
            .setter(setter(Builder::backupJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()).build();

    private static final SdkField<String> UPLOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UploadId").getter(getter(NotifyObjectCompleteRequest::uploadId)).setter(setter(Builder::uploadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("uploadId").build()).build();

    private static final SdkField<String> OBJECT_CHECKSUM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectChecksum").getter(getter(NotifyObjectCompleteRequest::objectChecksum))
            .setter(setter(Builder::objectChecksum))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("checksum").build()).build();

    private static final SdkField<String> OBJECT_CHECKSUM_ALGORITHM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectChecksumAlgorithm").getter(getter(NotifyObjectCompleteRequest::objectChecksumAlgorithmAsString))
            .setter(setter(Builder::objectChecksumAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("checksum-algorithm").build())
            .build();

    private static final SdkField<String> METADATA_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetadataString").getter(getter(NotifyObjectCompleteRequest::metadataString))
            .setter(setter(Builder::metadataString))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("metadata-string").build())
            .build();

    private static final SdkField<Long> METADATA_BLOB_LENGTH_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("MetadataBlobLength").getter(getter(NotifyObjectCompleteRequest::metadataBlobLength))
            .setter(setter(Builder::metadataBlobLength))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("metadata-blob-length").build())
            .build();

    private static final SdkField<String> METADATA_BLOB_CHECKSUM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetadataBlobChecksum").getter(getter(NotifyObjectCompleteRequest::metadataBlobChecksum))
            .setter(setter(Builder::metadataBlobChecksum))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("metadata-checksum").build())
            .build();

    private static final SdkField<String> METADATA_BLOB_CHECKSUM_ALGORITHM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MetadataBlobChecksumAlgorithm")
            .getter(getter(NotifyObjectCompleteRequest::metadataBlobChecksumAlgorithmAsString))
            .setter(setter(Builder::metadataBlobChecksumAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("metadata-checksum-algorithm")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_JOB_ID_FIELD,
            UPLOAD_ID_FIELD, OBJECT_CHECKSUM_FIELD, OBJECT_CHECKSUM_ALGORITHM_FIELD, METADATA_STRING_FIELD,
            METADATA_BLOB_LENGTH_FIELD, METADATA_BLOB_CHECKSUM_FIELD, METADATA_BLOB_CHECKSUM_ALGORITHM_FIELD));

    private final String backupJobId;

    private final String uploadId;

    private final String objectChecksum;

    private final String objectChecksumAlgorithm;

    private final String metadataString;

    private final Long metadataBlobLength;

    private final String metadataBlobChecksum;

    private final String metadataBlobChecksumAlgorithm;

    private NotifyObjectCompleteRequest(BuilderImpl builder) {
        super(builder);
        this.backupJobId = builder.backupJobId;
        this.uploadId = builder.uploadId;
        this.objectChecksum = builder.objectChecksum;
        this.objectChecksumAlgorithm = builder.objectChecksumAlgorithm;
        this.metadataString = builder.metadataString;
        this.metadataBlobLength = builder.metadataBlobLength;
        this.metadataBlobChecksum = builder.metadataBlobChecksum;
        this.metadataBlobChecksumAlgorithm = builder.metadataBlobChecksumAlgorithm;
    }

    /**
     * Backup job Id for the in-progress backup
     * 
     * @return Backup job Id for the in-progress backup
     */
    public final String backupJobId() {
        return backupJobId;
    }

    /**
     * Upload Id for the in-progress upload
     * 
     * @return Upload Id for the in-progress upload
     */
    public final String uploadId() {
        return uploadId;
    }

    /**
     * Object checksum
     * 
     * @return Object checksum
     */
    public final String objectChecksum() {
        return objectChecksum;
    }

    /**
     * Checksum algorithm
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #objectChecksumAlgorithm} will return {@link SummaryChecksumAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #objectChecksumAlgorithmAsString}.
     * </p>
     * 
     * @return Checksum algorithm
     * @see SummaryChecksumAlgorithm
     */
    public final SummaryChecksumAlgorithm objectChecksumAlgorithm() {
        return SummaryChecksumAlgorithm.fromValue(objectChecksumAlgorithm);
    }

    /**
     * Checksum algorithm
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #objectChecksumAlgorithm} will return {@link SummaryChecksumAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #objectChecksumAlgorithmAsString}.
     * </p>
     * 
     * @return Checksum algorithm
     * @see SummaryChecksumAlgorithm
     */
    public final String objectChecksumAlgorithmAsString() {
        return objectChecksumAlgorithm;
    }

    /**
     * Optional metadata associated with an Object. Maximum string length is 256 bytes.
     * 
     * @return Optional metadata associated with an Object. Maximum string length is 256 bytes.
     */
    public final String metadataString() {
        return metadataString;
    }

    /**
     * The size of MetadataBlob.
     * 
     * @return The size of MetadataBlob.
     */
    public final Long metadataBlobLength() {
        return metadataBlobLength;
    }

    /**
     * Checksum of MetadataBlob.
     * 
     * @return Checksum of MetadataBlob.
     */
    public final String metadataBlobChecksum() {
        return metadataBlobChecksum;
    }

    /**
     * Checksum algorithm.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #metadataBlobChecksumAlgorithm} will return {@link DataChecksumAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #metadataBlobChecksumAlgorithmAsString}.
     * </p>
     * 
     * @return Checksum algorithm.
     * @see DataChecksumAlgorithm
     */
    public final DataChecksumAlgorithm metadataBlobChecksumAlgorithm() {
        return DataChecksumAlgorithm.fromValue(metadataBlobChecksumAlgorithm);
    }

    /**
     * Checksum algorithm.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #metadataBlobChecksumAlgorithm} will return {@link DataChecksumAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #metadataBlobChecksumAlgorithmAsString}.
     * </p>
     * 
     * @return Checksum algorithm.
     * @see DataChecksumAlgorithm
     */
    public final String metadataBlobChecksumAlgorithmAsString() {
        return metadataBlobChecksumAlgorithm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backupJobId());
        hashCode = 31 * hashCode + Objects.hashCode(uploadId());
        hashCode = 31 * hashCode + Objects.hashCode(objectChecksum());
        hashCode = 31 * hashCode + Objects.hashCode(objectChecksumAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(metadataString());
        hashCode = 31 * hashCode + Objects.hashCode(metadataBlobLength());
        hashCode = 31 * hashCode + Objects.hashCode(metadataBlobChecksum());
        hashCode = 31 * hashCode + Objects.hashCode(metadataBlobChecksumAlgorithmAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotifyObjectCompleteRequest)) {
            return false;
        }
        NotifyObjectCompleteRequest other = (NotifyObjectCompleteRequest) obj;
        return Objects.equals(backupJobId(), other.backupJobId()) && Objects.equals(uploadId(), other.uploadId())
                && Objects.equals(objectChecksum(), other.objectChecksum())
                && Objects.equals(objectChecksumAlgorithmAsString(), other.objectChecksumAlgorithmAsString())
                && Objects.equals(metadataString(), other.metadataString())
                && Objects.equals(metadataBlobLength(), other.metadataBlobLength())
                && Objects.equals(metadataBlobChecksum(), other.metadataBlobChecksum())
                && Objects.equals(metadataBlobChecksumAlgorithmAsString(), other.metadataBlobChecksumAlgorithmAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NotifyObjectCompleteRequest").add("BackupJobId", backupJobId()).add("UploadId", uploadId())
                .add("ObjectChecksum", objectChecksum()).add("ObjectChecksumAlgorithm", objectChecksumAlgorithmAsString())
                .add("MetadataString", metadataString()).add("MetadataBlobLength", metadataBlobLength())
                .add("MetadataBlobChecksum", metadataBlobChecksum())
                .add("MetadataBlobChecksumAlgorithm", metadataBlobChecksumAlgorithmAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupJobId":
            return Optional.ofNullable(clazz.cast(backupJobId()));
        case "UploadId":
            return Optional.ofNullable(clazz.cast(uploadId()));
        case "ObjectChecksum":
            return Optional.ofNullable(clazz.cast(objectChecksum()));
        case "ObjectChecksumAlgorithm":
            return Optional.ofNullable(clazz.cast(objectChecksumAlgorithmAsString()));
        case "MetadataString":
            return Optional.ofNullable(clazz.cast(metadataString()));
        case "MetadataBlobLength":
            return Optional.ofNullable(clazz.cast(metadataBlobLength()));
        case "MetadataBlobChecksum":
            return Optional.ofNullable(clazz.cast(metadataBlobChecksum()));
        case "MetadataBlobChecksumAlgorithm":
            return Optional.ofNullable(clazz.cast(metadataBlobChecksumAlgorithmAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NotifyObjectCompleteRequest, T> g) {
        return obj -> g.apply((NotifyObjectCompleteRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupStorageRequest.Builder, SdkPojo, CopyableBuilder<Builder, NotifyObjectCompleteRequest> {
        /**
         * Backup job Id for the in-progress backup
         * 
         * @param backupJobId
         *        Backup job Id for the in-progress backup
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupJobId(String backupJobId);

        /**
         * Upload Id for the in-progress upload
         * 
         * @param uploadId
         *        Upload Id for the in-progress upload
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadId(String uploadId);

        /**
         * Object checksum
         * 
         * @param objectChecksum
         *        Object checksum
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectChecksum(String objectChecksum);

        /**
         * Checksum algorithm
         * 
         * @param objectChecksumAlgorithm
         *        Checksum algorithm
         * @see SummaryChecksumAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SummaryChecksumAlgorithm
         */
        Builder objectChecksumAlgorithm(String objectChecksumAlgorithm);

        /**
         * Checksum algorithm
         * 
         * @param objectChecksumAlgorithm
         *        Checksum algorithm
         * @see SummaryChecksumAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SummaryChecksumAlgorithm
         */
        Builder objectChecksumAlgorithm(SummaryChecksumAlgorithm objectChecksumAlgorithm);

        /**
         * Optional metadata associated with an Object. Maximum string length is 256 bytes.
         * 
         * @param metadataString
         *        Optional metadata associated with an Object. Maximum string length is 256 bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataString(String metadataString);

        /**
         * The size of MetadataBlob.
         * 
         * @param metadataBlobLength
         *        The size of MetadataBlob.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataBlobLength(Long metadataBlobLength);

        /**
         * Checksum of MetadataBlob.
         * 
         * @param metadataBlobChecksum
         *        Checksum of MetadataBlob.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataBlobChecksum(String metadataBlobChecksum);

        /**
         * Checksum algorithm.
         * 
         * @param metadataBlobChecksumAlgorithm
         *        Checksum algorithm.
         * @see DataChecksumAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataChecksumAlgorithm
         */
        Builder metadataBlobChecksumAlgorithm(String metadataBlobChecksumAlgorithm);

        /**
         * Checksum algorithm.
         * 
         * @param metadataBlobChecksumAlgorithm
         *        Checksum algorithm.
         * @see DataChecksumAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataChecksumAlgorithm
         */
        Builder metadataBlobChecksumAlgorithm(DataChecksumAlgorithm metadataBlobChecksumAlgorithm);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupStorageRequest.BuilderImpl implements Builder {
        private String backupJobId;

        private String uploadId;

        private String objectChecksum;

        private String objectChecksumAlgorithm;

        private String metadataString;

        private Long metadataBlobLength;

        private String metadataBlobChecksum;

        private String metadataBlobChecksumAlgorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(NotifyObjectCompleteRequest model) {
            super(model);
            backupJobId(model.backupJobId);
            uploadId(model.uploadId);
            objectChecksum(model.objectChecksum);
            objectChecksumAlgorithm(model.objectChecksumAlgorithm);
            metadataString(model.metadataString);
            metadataBlobLength(model.metadataBlobLength);
            metadataBlobChecksum(model.metadataBlobChecksum);
            metadataBlobChecksumAlgorithm(model.metadataBlobChecksumAlgorithm);
        }

        public final String getBackupJobId() {
            return backupJobId;
        }

        public final void setBackupJobId(String backupJobId) {
            this.backupJobId = backupJobId;
        }

        @Override
        public final Builder backupJobId(String backupJobId) {
            this.backupJobId = backupJobId;
            return this;
        }

        public final String getUploadId() {
            return uploadId;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final String getObjectChecksum() {
            return objectChecksum;
        }

        public final void setObjectChecksum(String objectChecksum) {
            this.objectChecksum = objectChecksum;
        }

        @Override
        public final Builder objectChecksum(String objectChecksum) {
            this.objectChecksum = objectChecksum;
            return this;
        }

        public final String getObjectChecksumAlgorithm() {
            return objectChecksumAlgorithm;
        }

        public final void setObjectChecksumAlgorithm(String objectChecksumAlgorithm) {
            this.objectChecksumAlgorithm = objectChecksumAlgorithm;
        }

        @Override
        public final Builder objectChecksumAlgorithm(String objectChecksumAlgorithm) {
            this.objectChecksumAlgorithm = objectChecksumAlgorithm;
            return this;
        }

        @Override
        public final Builder objectChecksumAlgorithm(SummaryChecksumAlgorithm objectChecksumAlgorithm) {
            this.objectChecksumAlgorithm(objectChecksumAlgorithm == null ? null : objectChecksumAlgorithm.toString());
            return this;
        }

        public final String getMetadataString() {
            return metadataString;
        }

        public final void setMetadataString(String metadataString) {
            this.metadataString = metadataString;
        }

        @Override
        public final Builder metadataString(String metadataString) {
            this.metadataString = metadataString;
            return this;
        }

        public final Long getMetadataBlobLength() {
            return metadataBlobLength;
        }

        public final void setMetadataBlobLength(Long metadataBlobLength) {
            this.metadataBlobLength = metadataBlobLength;
        }

        @Override
        public final Builder metadataBlobLength(Long metadataBlobLength) {
            this.metadataBlobLength = metadataBlobLength;
            return this;
        }

        public final String getMetadataBlobChecksum() {
            return metadataBlobChecksum;
        }

        public final void setMetadataBlobChecksum(String metadataBlobChecksum) {
            this.metadataBlobChecksum = metadataBlobChecksum;
        }

        @Override
        public final Builder metadataBlobChecksum(String metadataBlobChecksum) {
            this.metadataBlobChecksum = metadataBlobChecksum;
            return this;
        }

        public final String getMetadataBlobChecksumAlgorithm() {
            return metadataBlobChecksumAlgorithm;
        }

        public final void setMetadataBlobChecksumAlgorithm(String metadataBlobChecksumAlgorithm) {
            this.metadataBlobChecksumAlgorithm = metadataBlobChecksumAlgorithm;
        }

        @Override
        public final Builder metadataBlobChecksumAlgorithm(String metadataBlobChecksumAlgorithm) {
            this.metadataBlobChecksumAlgorithm = metadataBlobChecksumAlgorithm;
            return this;
        }

        @Override
        public final Builder metadataBlobChecksumAlgorithm(DataChecksumAlgorithm metadataBlobChecksumAlgorithm) {
            this.metadataBlobChecksumAlgorithm(metadataBlobChecksumAlgorithm == null ? null : metadataBlobChecksumAlgorithm
                    .toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public NotifyObjectCompleteRequest build() {
            return new NotifyObjectCompleteRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
