/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupstorage.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backupstorage.model.BackupStorageResponse;
import software.amazon.awssdk.services.backupstorage.model.DataChecksumAlgorithm;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetChunkResponse
extends BackupStorageResponse
implements ToCopyableBuilder<Builder, GetChunkResponse> {
    private static final SdkField<Long> LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Length").getter(GetChunkResponse.getter(GetChunkResponse::length)).setter(GetChunkResponse.setter(Builder::length)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-length").build()}).build();
    private static final SdkField<String> CHECKSUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Checksum").getter(GetChunkResponse.getter(GetChunkResponse::checksum)).setter(GetChunkResponse.setter(Builder::checksum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-checksum").build()}).build();
    private static final SdkField<String> CHECKSUM_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChecksumAlgorithm").getter(GetChunkResponse.getter(GetChunkResponse::checksumAlgorithmAsString)).setter(GetChunkResponse.setter(Builder::checksumAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-checksum-algorithm").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LENGTH_FIELD, CHECKSUM_FIELD, CHECKSUM_ALGORITHM_FIELD));
    private final Long length;
    private final String checksum;
    private final String checksumAlgorithm;

    private GetChunkResponse(BuilderImpl builder) {
        super(builder);
        this.length = builder.length;
        this.checksum = builder.checksum;
        this.checksumAlgorithm = builder.checksumAlgorithm;
    }

    public final Long length() {
        return this.length;
    }

    public final String checksum() {
        return this.checksum;
    }

    public final DataChecksumAlgorithm checksumAlgorithm() {
        return DataChecksumAlgorithm.fromValue(this.checksumAlgorithm);
    }

    public final String checksumAlgorithmAsString() {
        return this.checksumAlgorithm;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.length());
        hashCode = 31 * hashCode + Objects.hashCode(this.checksum());
        hashCode = 31 * hashCode + Objects.hashCode(this.checksumAlgorithmAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetChunkResponse)) {
            return false;
        }
        GetChunkResponse other = (GetChunkResponse)((Object)obj);
        return Objects.equals(this.length(), other.length()) && Objects.equals(this.checksum(), other.checksum()) && Objects.equals(this.checksumAlgorithmAsString(), other.checksumAlgorithmAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetChunkResponse").add("Length", (Object)this.length()).add("Checksum", (Object)this.checksum()).add("ChecksumAlgorithm", (Object)this.checksumAlgorithmAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Length": {
                return Optional.ofNullable(clazz.cast(this.length()));
            }
            case "Checksum": {
                return Optional.ofNullable(clazz.cast(this.checksum()));
            }
            case "ChecksumAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.checksumAlgorithmAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetChunkResponse, T> g) {
        return obj -> g.apply((GetChunkResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupStorageResponse.BuilderImpl
    implements Builder {
        private Long length;
        private String checksum;
        private String checksumAlgorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(GetChunkResponse model) {
            super(model);
            this.length(model.length);
            this.checksum(model.checksum);
            this.checksumAlgorithm(model.checksumAlgorithm);
        }

        public final Long getLength() {
            return this.length;
        }

        public final void setLength(Long length) {
            this.length = length;
        }

        @Override
        public final Builder length(Long length) {
            this.length = length;
            return this;
        }

        public final String getChecksum() {
            return this.checksum;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final String getChecksumAlgorithm() {
            return this.checksumAlgorithm;
        }

        public final void setChecksumAlgorithm(String checksumAlgorithm) {
            this.checksumAlgorithm = checksumAlgorithm;
        }

        @Override
        public final Builder checksumAlgorithm(String checksumAlgorithm) {
            this.checksumAlgorithm = checksumAlgorithm;
            return this;
        }

        @Override
        public final Builder checksumAlgorithm(DataChecksumAlgorithm checksumAlgorithm) {
            this.checksumAlgorithm(checksumAlgorithm == null ? null : checksumAlgorithm.toString());
            return this;
        }

        @Override
        public GetChunkResponse build() {
            return new GetChunkResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupStorageResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetChunkResponse> {
        public Builder length(Long var1);

        public Builder checksum(String var1);

        public Builder checksumAlgorithm(String var1);

        public Builder checksumAlgorithm(DataChecksumAlgorithm var1);
    }
}

