/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupstorage.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backupstorage.model.BackupObject;
import software.amazon.awssdk.services.backupstorage.model.BackupStorageResponse;
import software.amazon.awssdk.services.backupstorage.model.ObjectListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListObjectsResponse
extends BackupStorageResponse
implements ToCopyableBuilder<Builder, ListObjectsResponse> {
    private static final SdkField<List<BackupObject>> OBJECT_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ObjectList").getter(ListObjectsResponse.getter(ListObjectsResponse::objectList)).setter(ListObjectsResponse.setter(Builder::objectList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BackupObject::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListObjectsResponse.getter(ListObjectsResponse::nextToken)).setter(ListObjectsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<BackupObject> objectList;
    private final String nextToken;

    private ListObjectsResponse(BuilderImpl builder) {
        super(builder);
        this.objectList = builder.objectList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasObjectList() {
        return this.objectList != null && !(this.objectList instanceof SdkAutoConstructList);
    }

    public final List<BackupObject> objectList() {
        return this.objectList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasObjectList() ? this.objectList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListObjectsResponse)) {
            return false;
        }
        ListObjectsResponse other = (ListObjectsResponse)((Object)obj);
        return this.hasObjectList() == other.hasObjectList() && Objects.equals(this.objectList(), other.objectList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListObjectsResponse").add("ObjectList", this.hasObjectList() ? this.objectList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ObjectList": {
                return Optional.ofNullable(clazz.cast(this.objectList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListObjectsResponse, T> g) {
        return obj -> g.apply((ListObjectsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupStorageResponse.BuilderImpl
    implements Builder {
        private List<BackupObject> objectList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListObjectsResponse model) {
            super(model);
            this.objectList(model.objectList);
            this.nextToken(model.nextToken);
        }

        public final List<BackupObject.Builder> getObjectList() {
            List<BackupObject.Builder> result = ObjectListCopier.copyToBuilder(this.objectList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setObjectList(Collection<BackupObject.BuilderImpl> objectList) {
            this.objectList = ObjectListCopier.copyFromBuilder(objectList);
        }

        @Override
        public final Builder objectList(Collection<BackupObject> objectList) {
            this.objectList = ObjectListCopier.copy(objectList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectList(BackupObject ... objectList) {
            this.objectList(Arrays.asList(objectList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectList(Consumer<BackupObject.Builder> ... objectList) {
            this.objectList(Stream.of(objectList).map(c -> (BackupObject)((BackupObject.Builder)BackupObject.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListObjectsResponse build() {
            return new ListObjectsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupStorageResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListObjectsResponse> {
        public Builder objectList(Collection<BackupObject> var1);

        public Builder objectList(BackupObject ... var1);

        public Builder objectList(Consumer<BackupObject.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

