/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupstorage.auth.scheme.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.services.backupstorage.auth.scheme.BackupStorageAuthSchemeParams;
import software.amazon.awssdk.services.backupstorage.auth.scheme.BackupStorageAuthSchemeProvider;

@SdkInternalApi
public final class DefaultBackupStorageAuthSchemeProvider
implements BackupStorageAuthSchemeProvider {
    private static final DefaultBackupStorageAuthSchemeProvider DEFAULT = new DefaultBackupStorageAuthSchemeProvider();

    private DefaultBackupStorageAuthSchemeProvider() {
    }

    public static DefaultBackupStorageAuthSchemeProvider create() {
        return DEFAULT;
    }

    @Override
    public List<AuthSchemeOption> resolveAuthScheme(BackupStorageAuthSchemeParams params) {
        ArrayList<AuthSchemeOption> options = new ArrayList<AuthSchemeOption>();
        switch (params.operation()) {
            case "NotifyObjectComplete": 
            case "PutChunk": 
            case "PutObject": {
                options.add((AuthSchemeOption)AuthSchemeOption.builder().schemeId("aws.auth#sigv4").putSignerProperty(AwsV4HttpSigner.SERVICE_SIGNING_NAME, (Object)"backup-storage").putSignerProperty(AwsV4HttpSigner.REGION_NAME, (Object)params.region().id()).putSignerProperty(AwsV4HttpSigner.PAYLOAD_SIGNING_ENABLED, (Object)false).build());
                break;
            }
            default: {
                options.add((AuthSchemeOption)AuthSchemeOption.builder().schemeId("aws.auth#sigv4").putSignerProperty(AwsV4HttpSigner.SERVICE_SIGNING_NAME, (Object)"backup-storage").putSignerProperty(AwsV4HttpSigner.REGION_NAME, (Object)params.region().id()).build());
            }
        }
        return Collections.unmodifiableList(options);
    }
}

