/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.batch.model.BatchResponse;
import software.amazon.awssdk.services.batch.model.LatestServiceJobAttempt;
import software.amazon.awssdk.services.batch.model.ServiceJobAttemptDetail;
import software.amazon.awssdk.services.batch.model.ServiceJobAttemptDetailsCopier;
import software.amazon.awssdk.services.batch.model.ServiceJobRetryStrategy;
import software.amazon.awssdk.services.batch.model.ServiceJobStatus;
import software.amazon.awssdk.services.batch.model.ServiceJobTimeout;
import software.amazon.awssdk.services.batch.model.ServiceJobType;
import software.amazon.awssdk.services.batch.model.TagrisTagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeServiceJobResponse
extends BatchResponse
implements ToCopyableBuilder<Builder, DescribeServiceJobResponse> {
    private static final SdkField<List<ServiceJobAttemptDetail>> ATTEMPTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("attempts").getter(DescribeServiceJobResponse.getter(DescribeServiceJobResponse::attempts)).setter(DescribeServiceJobResponse.setter(Builder::attempts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attempts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceJobAttemptDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("createdAt").getter(DescribeServiceJobResponse.getter(DescribeServiceJobResponse::createdAt)).setter(DescribeServiceJobResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Boolean> IS_TERMINATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isTerminated").getter(DescribeServiceJobResponse.getter(DescribeServiceJobResponse::isTerminated)).setter(DescribeServiceJobResponse.setter(Builder::isTerminated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isTerminated").build()}).build();
    private static final SdkField<String> JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobArn").getter(DescribeServiceJobResponse.getter(DescribeServiceJobResponse::jobArn)).setter(DescribeServiceJobResponse.setter(Builder::jobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(DescribeServiceJobResponse.getter(DescribeServiceJobResponse::jobId)).setter(DescribeServiceJobResponse.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobName").getter(DescribeServiceJobResponse.getter(DescribeServiceJobResponse::jobName)).setter(DescribeServiceJobResponse.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()}).build();
    private static final SdkField<String> JOB_QUEUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobQueue").getter(DescribeServiceJobResponse.getter(DescribeServiceJobResponse::jobQueue)).setter(DescribeServiceJobResponse.setter(Builder::jobQueue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobQueue").build()}).build();
    private static final SdkField<LatestServiceJobAttempt> LATEST_ATTEMPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("latestAttempt").getter(DescribeServiceJobResponse.getter(DescribeServiceJobResponse::latestAttempt)).setter(DescribeServiceJobResponse.setter(Builder::latestAttempt)).constructor(LatestServiceJobAttempt::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestAttempt").build()}).build();
    private static final SdkField<ServiceJobRetryStrategy> RETRY_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("retryStrategy").getter(DescribeServiceJobResponse.getter(DescribeServiceJobResponse::retryStrategy)).setter(DescribeServiceJobResponse.setter(Builder::retryStrategy)).constructor(ServiceJobRetryStrategy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retryStrategy").build()}).build();
    private static final SdkField<Integer> SCHEDULING_PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("schedulingPriority").getter(DescribeServiceJobResponse.getter(DescribeServiceJobResponse::schedulingPriority)).setter(DescribeServiceJobResponse.setter(Builder::schedulingPriority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedulingPriority").build()}).build();
    private static final SdkField<String> SERVICE_REQUEST_PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceRequestPayload").getter(DescribeServiceJobResponse.getter(DescribeServiceJobResponse::serviceRequestPayload)).setter(DescribeServiceJobResponse.setter(Builder::serviceRequestPayload)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRequestPayload").build()}).build();
    private static final SdkField<String> SERVICE_JOB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceJobType").getter(DescribeServiceJobResponse.getter(DescribeServiceJobResponse::serviceJobTypeAsString)).setter(DescribeServiceJobResponse.setter(Builder::serviceJobType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceJobType").build()}).build();
    private static final SdkField<String> SHARE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("shareIdentifier").getter(DescribeServiceJobResponse.getter(DescribeServiceJobResponse::shareIdentifier)).setter(DescribeServiceJobResponse.setter(Builder::shareIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shareIdentifier").build()}).build();
    private static final SdkField<Long> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("startedAt").getter(DescribeServiceJobResponse.getter(DescribeServiceJobResponse::startedAt)).setter(DescribeServiceJobResponse.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DescribeServiceJobResponse.getter(DescribeServiceJobResponse::statusAsString)).setter(DescribeServiceJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(DescribeServiceJobResponse.getter(DescribeServiceJobResponse::statusReason)).setter(DescribeServiceJobResponse.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<Long> STOPPED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("stoppedAt").getter(DescribeServiceJobResponse.getter(DescribeServiceJobResponse::stoppedAt)).setter(DescribeServiceJobResponse.setter(Builder::stoppedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stoppedAt").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(DescribeServiceJobResponse.getter(DescribeServiceJobResponse::tags)).setter(DescribeServiceJobResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<ServiceJobTimeout> TIMEOUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("timeoutConfig").getter(DescribeServiceJobResponse.getter(DescribeServiceJobResponse::timeoutConfig)).setter(DescribeServiceJobResponse.setter(Builder::timeoutConfig)).constructor(ServiceJobTimeout::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTEMPTS_FIELD, CREATED_AT_FIELD, IS_TERMINATED_FIELD, JOB_ARN_FIELD, JOB_ID_FIELD, JOB_NAME_FIELD, JOB_QUEUE_FIELD, LATEST_ATTEMPT_FIELD, RETRY_STRATEGY_FIELD, SCHEDULING_PRIORITY_FIELD, SERVICE_REQUEST_PAYLOAD_FIELD, SERVICE_JOB_TYPE_FIELD, SHARE_IDENTIFIER_FIELD, STARTED_AT_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, STOPPED_AT_FIELD, TAGS_FIELD, TIMEOUT_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeServiceJobResponse.memberNameToFieldInitializer();
    private final List<ServiceJobAttemptDetail> attempts;
    private final Long createdAt;
    private final Boolean isTerminated;
    private final String jobArn;
    private final String jobId;
    private final String jobName;
    private final String jobQueue;
    private final LatestServiceJobAttempt latestAttempt;
    private final ServiceJobRetryStrategy retryStrategy;
    private final Integer schedulingPriority;
    private final String serviceRequestPayload;
    private final String serviceJobType;
    private final String shareIdentifier;
    private final Long startedAt;
    private final String status;
    private final String statusReason;
    private final Long stoppedAt;
    private final Map<String, String> tags;
    private final ServiceJobTimeout timeoutConfig;

    private DescribeServiceJobResponse(BuilderImpl builder) {
        super(builder);
        this.attempts = builder.attempts;
        this.createdAt = builder.createdAt;
        this.isTerminated = builder.isTerminated;
        this.jobArn = builder.jobArn;
        this.jobId = builder.jobId;
        this.jobName = builder.jobName;
        this.jobQueue = builder.jobQueue;
        this.latestAttempt = builder.latestAttempt;
        this.retryStrategy = builder.retryStrategy;
        this.schedulingPriority = builder.schedulingPriority;
        this.serviceRequestPayload = builder.serviceRequestPayload;
        this.serviceJobType = builder.serviceJobType;
        this.shareIdentifier = builder.shareIdentifier;
        this.startedAt = builder.startedAt;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.stoppedAt = builder.stoppedAt;
        this.tags = builder.tags;
        this.timeoutConfig = builder.timeoutConfig;
    }

    public final boolean hasAttempts() {
        return this.attempts != null && !(this.attempts instanceof SdkAutoConstructList);
    }

    public final List<ServiceJobAttemptDetail> attempts() {
        return this.attempts;
    }

    public final Long createdAt() {
        return this.createdAt;
    }

    public final Boolean isTerminated() {
        return this.isTerminated;
    }

    public final String jobArn() {
        return this.jobArn;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final String jobQueue() {
        return this.jobQueue;
    }

    public final LatestServiceJobAttempt latestAttempt() {
        return this.latestAttempt;
    }

    public final ServiceJobRetryStrategy retryStrategy() {
        return this.retryStrategy;
    }

    public final Integer schedulingPriority() {
        return this.schedulingPriority;
    }

    public final String serviceRequestPayload() {
        return this.serviceRequestPayload;
    }

    public final ServiceJobType serviceJobType() {
        return ServiceJobType.fromValue(this.serviceJobType);
    }

    public final String serviceJobTypeAsString() {
        return this.serviceJobType;
    }

    public final String shareIdentifier() {
        return this.shareIdentifier;
    }

    public final Long startedAt() {
        return this.startedAt;
    }

    public final ServiceJobStatus status() {
        return ServiceJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final Long stoppedAt() {
        return this.stoppedAt;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final ServiceJobTimeout timeoutConfig() {
        return this.timeoutConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttempts() ? this.attempts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTerminated());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobQueue());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestAttempt());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedulingPriority());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRequestPayload());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceJobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.shareIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServiceJobResponse)) {
            return false;
        }
        DescribeServiceJobResponse other = (DescribeServiceJobResponse)((Object)obj);
        return this.hasAttempts() == other.hasAttempts() && Objects.equals(this.attempts(), other.attempts()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.isTerminated(), other.isTerminated()) && Objects.equals(this.jobArn(), other.jobArn()) && Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.jobQueue(), other.jobQueue()) && Objects.equals(this.latestAttempt(), other.latestAttempt()) && Objects.equals(this.retryStrategy(), other.retryStrategy()) && Objects.equals(this.schedulingPriority(), other.schedulingPriority()) && Objects.equals(this.serviceRequestPayload(), other.serviceRequestPayload()) && Objects.equals(this.serviceJobTypeAsString(), other.serviceJobTypeAsString()) && Objects.equals(this.shareIdentifier(), other.shareIdentifier()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.stoppedAt(), other.stoppedAt()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.timeoutConfig(), other.timeoutConfig());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeServiceJobResponse").add("Attempts", this.hasAttempts() ? this.attempts() : null).add("CreatedAt", (Object)this.createdAt()).add("IsTerminated", (Object)this.isTerminated()).add("JobArn", (Object)this.jobArn()).add("JobId", (Object)this.jobId()).add("JobName", (Object)this.jobName()).add("JobQueue", (Object)this.jobQueue()).add("LatestAttempt", (Object)this.latestAttempt()).add("RetryStrategy", (Object)this.retryStrategy()).add("SchedulingPriority", (Object)this.schedulingPriority()).add("ServiceRequestPayload", (Object)this.serviceRequestPayload()).add("ServiceJobType", (Object)this.serviceJobTypeAsString()).add("ShareIdentifier", (Object)this.shareIdentifier()).add("StartedAt", (Object)this.startedAt()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("StoppedAt", (Object)this.stoppedAt()).add("Tags", this.hasTags() ? this.tags() : null).add("TimeoutConfig", (Object)this.timeoutConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "attempts": {
                return Optional.ofNullable(clazz.cast(this.attempts()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "isTerminated": {
                return Optional.ofNullable(clazz.cast(this.isTerminated()));
            }
            case "jobArn": {
                return Optional.ofNullable(clazz.cast(this.jobArn()));
            }
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "jobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "jobQueue": {
                return Optional.ofNullable(clazz.cast(this.jobQueue()));
            }
            case "latestAttempt": {
                return Optional.ofNullable(clazz.cast(this.latestAttempt()));
            }
            case "retryStrategy": {
                return Optional.ofNullable(clazz.cast(this.retryStrategy()));
            }
            case "schedulingPriority": {
                return Optional.ofNullable(clazz.cast(this.schedulingPriority()));
            }
            case "serviceRequestPayload": {
                return Optional.ofNullable(clazz.cast(this.serviceRequestPayload()));
            }
            case "serviceJobType": {
                return Optional.ofNullable(clazz.cast(this.serviceJobTypeAsString()));
            }
            case "shareIdentifier": {
                return Optional.ofNullable(clazz.cast(this.shareIdentifier()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "stoppedAt": {
                return Optional.ofNullable(clazz.cast(this.stoppedAt()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "timeoutConfig": {
                return Optional.ofNullable(clazz.cast(this.timeoutConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("attempts", ATTEMPTS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("isTerminated", IS_TERMINATED_FIELD);
        map.put("jobArn", JOB_ARN_FIELD);
        map.put("jobId", JOB_ID_FIELD);
        map.put("jobName", JOB_NAME_FIELD);
        map.put("jobQueue", JOB_QUEUE_FIELD);
        map.put("latestAttempt", LATEST_ATTEMPT_FIELD);
        map.put("retryStrategy", RETRY_STRATEGY_FIELD);
        map.put("schedulingPriority", SCHEDULING_PRIORITY_FIELD);
        map.put("serviceRequestPayload", SERVICE_REQUEST_PAYLOAD_FIELD);
        map.put("serviceJobType", SERVICE_JOB_TYPE_FIELD);
        map.put("shareIdentifier", SHARE_IDENTIFIER_FIELD);
        map.put("startedAt", STARTED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("stoppedAt", STOPPED_AT_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("timeoutConfig", TIMEOUT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeServiceJobResponse, T> g) {
        return obj -> g.apply((DescribeServiceJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BatchResponse.BuilderImpl
    implements Builder {
        private List<ServiceJobAttemptDetail> attempts = DefaultSdkAutoConstructList.getInstance();
        private Long createdAt;
        private Boolean isTerminated;
        private String jobArn;
        private String jobId;
        private String jobName;
        private String jobQueue;
        private LatestServiceJobAttempt latestAttempt;
        private ServiceJobRetryStrategy retryStrategy;
        private Integer schedulingPriority;
        private String serviceRequestPayload;
        private String serviceJobType;
        private String shareIdentifier;
        private Long startedAt;
        private String status;
        private String statusReason;
        private Long stoppedAt;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private ServiceJobTimeout timeoutConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServiceJobResponse model) {
            super(model);
            this.attempts(model.attempts);
            this.createdAt(model.createdAt);
            this.isTerminated(model.isTerminated);
            this.jobArn(model.jobArn);
            this.jobId(model.jobId);
            this.jobName(model.jobName);
            this.jobQueue(model.jobQueue);
            this.latestAttempt(model.latestAttempt);
            this.retryStrategy(model.retryStrategy);
            this.schedulingPriority(model.schedulingPriority);
            this.serviceRequestPayload(model.serviceRequestPayload);
            this.serviceJobType(model.serviceJobType);
            this.shareIdentifier(model.shareIdentifier);
            this.startedAt(model.startedAt);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.stoppedAt(model.stoppedAt);
            this.tags(model.tags);
            this.timeoutConfig(model.timeoutConfig);
        }

        public final List<ServiceJobAttemptDetail.Builder> getAttempts() {
            List<ServiceJobAttemptDetail.Builder> result = ServiceJobAttemptDetailsCopier.copyToBuilder(this.attempts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttempts(Collection<ServiceJobAttemptDetail.BuilderImpl> attempts) {
            this.attempts = ServiceJobAttemptDetailsCopier.copyFromBuilder(attempts);
        }

        @Override
        public final Builder attempts(Collection<ServiceJobAttemptDetail> attempts) {
            this.attempts = ServiceJobAttemptDetailsCopier.copy(attempts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attempts(ServiceJobAttemptDetail ... attempts) {
            this.attempts(Arrays.asList(attempts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attempts(Consumer<ServiceJobAttemptDetail.Builder> ... attempts) {
            this.attempts(Stream.of(attempts).map(c -> (ServiceJobAttemptDetail)((ServiceJobAttemptDetail.Builder)ServiceJobAttemptDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Long getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Long createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Long createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Boolean getIsTerminated() {
            return this.isTerminated;
        }

        public final void setIsTerminated(Boolean isTerminated) {
            this.isTerminated = isTerminated;
        }

        @Override
        public final Builder isTerminated(Boolean isTerminated) {
            this.isTerminated = isTerminated;
            return this;
        }

        public final String getJobArn() {
            return this.jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobQueue() {
            return this.jobQueue;
        }

        public final void setJobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
        }

        @Override
        public final Builder jobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
            return this;
        }

        public final LatestServiceJobAttempt.Builder getLatestAttempt() {
            return this.latestAttempt != null ? this.latestAttempt.toBuilder() : null;
        }

        public final void setLatestAttempt(LatestServiceJobAttempt.BuilderImpl latestAttempt) {
            this.latestAttempt = latestAttempt != null ? latestAttempt.build() : null;
        }

        @Override
        public final Builder latestAttempt(LatestServiceJobAttempt latestAttempt) {
            this.latestAttempt = latestAttempt;
            return this;
        }

        public final ServiceJobRetryStrategy.Builder getRetryStrategy() {
            return this.retryStrategy != null ? this.retryStrategy.toBuilder() : null;
        }

        public final void setRetryStrategy(ServiceJobRetryStrategy.BuilderImpl retryStrategy) {
            this.retryStrategy = retryStrategy != null ? retryStrategy.build() : null;
        }

        @Override
        public final Builder retryStrategy(ServiceJobRetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        public final Integer getSchedulingPriority() {
            return this.schedulingPriority;
        }

        public final void setSchedulingPriority(Integer schedulingPriority) {
            this.schedulingPriority = schedulingPriority;
        }

        @Override
        public final Builder schedulingPriority(Integer schedulingPriority) {
            this.schedulingPriority = schedulingPriority;
            return this;
        }

        public final String getServiceRequestPayload() {
            return this.serviceRequestPayload;
        }

        public final void setServiceRequestPayload(String serviceRequestPayload) {
            this.serviceRequestPayload = serviceRequestPayload;
        }

        @Override
        public final Builder serviceRequestPayload(String serviceRequestPayload) {
            this.serviceRequestPayload = serviceRequestPayload;
            return this;
        }

        public final String getServiceJobType() {
            return this.serviceJobType;
        }

        public final void setServiceJobType(String serviceJobType) {
            this.serviceJobType = serviceJobType;
        }

        @Override
        public final Builder serviceJobType(String serviceJobType) {
            this.serviceJobType = serviceJobType;
            return this;
        }

        @Override
        public final Builder serviceJobType(ServiceJobType serviceJobType) {
            this.serviceJobType(serviceJobType == null ? null : serviceJobType.toString());
            return this;
        }

        public final String getShareIdentifier() {
            return this.shareIdentifier;
        }

        public final void setShareIdentifier(String shareIdentifier) {
            this.shareIdentifier = shareIdentifier;
        }

        @Override
        public final Builder shareIdentifier(String shareIdentifier) {
            this.shareIdentifier = shareIdentifier;
            return this;
        }

        public final Long getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Long startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Long startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ServiceJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Long getStoppedAt() {
            return this.stoppedAt;
        }

        public final void setStoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
        }

        @Override
        public final Builder stoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
            return this;
        }

        public final ServiceJobTimeout.Builder getTimeoutConfig() {
            return this.timeoutConfig != null ? this.timeoutConfig.toBuilder() : null;
        }

        public final void setTimeoutConfig(ServiceJobTimeout.BuilderImpl timeoutConfig) {
            this.timeoutConfig = timeoutConfig != null ? timeoutConfig.build() : null;
        }

        @Override
        public final Builder timeoutConfig(ServiceJobTimeout timeoutConfig) {
            this.timeoutConfig = timeoutConfig;
            return this;
        }

        @Override
        public DescribeServiceJobResponse build() {
            return new DescribeServiceJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BatchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeServiceJobResponse> {
        public Builder attempts(Collection<ServiceJobAttemptDetail> var1);

        public Builder attempts(ServiceJobAttemptDetail ... var1);

        public Builder attempts(Consumer<ServiceJobAttemptDetail.Builder> ... var1);

        public Builder createdAt(Long var1);

        public Builder isTerminated(Boolean var1);

        public Builder jobArn(String var1);

        public Builder jobId(String var1);

        public Builder jobName(String var1);

        public Builder jobQueue(String var1);

        public Builder latestAttempt(LatestServiceJobAttempt var1);

        default public Builder latestAttempt(Consumer<LatestServiceJobAttempt.Builder> latestAttempt) {
            return this.latestAttempt((LatestServiceJobAttempt)((LatestServiceJobAttempt.Builder)LatestServiceJobAttempt.builder().applyMutation(latestAttempt)).build());
        }

        public Builder retryStrategy(ServiceJobRetryStrategy var1);

        default public Builder retryStrategy(Consumer<ServiceJobRetryStrategy.Builder> retryStrategy) {
            return this.retryStrategy((ServiceJobRetryStrategy)((ServiceJobRetryStrategy.Builder)ServiceJobRetryStrategy.builder().applyMutation(retryStrategy)).build());
        }

        public Builder schedulingPriority(Integer var1);

        public Builder serviceRequestPayload(String var1);

        public Builder serviceJobType(String var1);

        public Builder serviceJobType(ServiceJobType var1);

        public Builder shareIdentifier(String var1);

        public Builder startedAt(Long var1);

        public Builder status(String var1);

        public Builder status(ServiceJobStatus var1);

        public Builder statusReason(String var1);

        public Builder stoppedAt(Long var1);

        public Builder tags(Map<String, String> var1);

        public Builder timeoutConfig(ServiceJobTimeout var1);

        default public Builder timeoutConfig(Consumer<ServiceJobTimeout.Builder> timeoutConfig) {
            return this.timeoutConfig((ServiceJobTimeout)((ServiceJobTimeout.Builder)ServiceJobTimeout.builder().applyMutation(timeoutConfig)).build());
        }
    }
}

