/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.batch.BatchClient;
import software.amazon.awssdk.services.batch.internal.UserAgentUtils;
import software.amazon.awssdk.services.batch.model.ListJobsByConsumableResourceRequest;
import software.amazon.awssdk.services.batch.model.ListJobsByConsumableResourceResponse;
import software.amazon.awssdk.services.batch.model.ListJobsByConsumableResourceSummary;

public class ListJobsByConsumableResourceIterable
implements SdkIterable<ListJobsByConsumableResourceResponse> {
    private final BatchClient client;
    private final ListJobsByConsumableResourceRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListJobsByConsumableResourceIterable(BatchClient client, ListJobsByConsumableResourceRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListJobsByConsumableResourceResponseFetcher();
    }

    public Iterator<ListJobsByConsumableResourceResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListJobsByConsumableResourceSummary> jobs() {
        Function<ListJobsByConsumableResourceResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobs() != null) {
                return response.jobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListJobsByConsumableResourceResponseFetcher
    implements SyncPageFetcher<ListJobsByConsumableResourceResponse> {
        private ListJobsByConsumableResourceResponseFetcher() {
        }

        public boolean hasNextPage(ListJobsByConsumableResourceResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListJobsByConsumableResourceResponse nextPage(ListJobsByConsumableResourceResponse previousPage) {
            if (previousPage == null) {
                return ListJobsByConsumableResourceIterable.this.client.listJobsByConsumableResource(ListJobsByConsumableResourceIterable.this.firstRequest);
            }
            return ListJobsByConsumableResourceIterable.this.client.listJobsByConsumableResource((ListJobsByConsumableResourceRequest)((Object)ListJobsByConsumableResourceIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

