/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmdataexports.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FormatOption {
    TEXT_OR_CSV("TEXT_OR_CSV"),
    PARQUET("PARQUET"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FormatOption> VALUE_MAP;
    private final String value;

    private FormatOption(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FormatOption fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FormatOption> knownValues() {
        EnumSet<FormatOption> knownValues = EnumSet.allOf(FormatOption.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FormatOption.class, FormatOption::toString);
    }
}

