/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrock.model.BedrockRequest;
import software.amazon.awssdk.services.bedrock.model.CustomizationType;
import software.amazon.awssdk.services.bedrock.model.ModelCustomizationHyperParametersCopier;
import software.amazon.awssdk.services.bedrock.model.OutputDataConfig;
import software.amazon.awssdk.services.bedrock.model.Tag;
import software.amazon.awssdk.services.bedrock.model.TagListCopier;
import software.amazon.awssdk.services.bedrock.model.TrainingDataConfig;
import software.amazon.awssdk.services.bedrock.model.ValidationDataConfig;
import software.amazon.awssdk.services.bedrock.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateModelCustomizationJobRequest
extends BedrockRequest
implements ToCopyableBuilder<Builder, CreateModelCustomizationJobRequest> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobName").getter(CreateModelCustomizationJobRequest.getter(CreateModelCustomizationJobRequest::jobName)).setter(CreateModelCustomizationJobRequest.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()}).build();
    private static final SdkField<String> CUSTOM_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customModelName").getter(CreateModelCustomizationJobRequest.getter(CreateModelCustomizationJobRequest::customModelName)).setter(CreateModelCustomizationJobRequest.setter(Builder::customModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customModelName").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(CreateModelCustomizationJobRequest.getter(CreateModelCustomizationJobRequest::roleArn)).setter(CreateModelCustomizationJobRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(CreateModelCustomizationJobRequest.getter(CreateModelCustomizationJobRequest::clientRequestToken)).setter(CreateModelCustomizationJobRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> BASE_MODEL_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("baseModelIdentifier").getter(CreateModelCustomizationJobRequest.getter(CreateModelCustomizationJobRequest::baseModelIdentifier)).setter(CreateModelCustomizationJobRequest.setter(Builder::baseModelIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseModelIdentifier").build()}).build();
    private static final SdkField<String> CUSTOMIZATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customizationType").getter(CreateModelCustomizationJobRequest.getter(CreateModelCustomizationJobRequest::customizationTypeAsString)).setter(CreateModelCustomizationJobRequest.setter(Builder::customizationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customizationType").build()}).build();
    private static final SdkField<String> CUSTOM_MODEL_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customModelKmsKeyId").getter(CreateModelCustomizationJobRequest.getter(CreateModelCustomizationJobRequest::customModelKmsKeyId)).setter(CreateModelCustomizationJobRequest.setter(Builder::customModelKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customModelKmsKeyId").build()}).build();
    private static final SdkField<List<Tag>> JOB_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("jobTags").getter(CreateModelCustomizationJobRequest.getter(CreateModelCustomizationJobRequest::jobTags)).setter(CreateModelCustomizationJobRequest.setter(Builder::jobTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> CUSTOM_MODEL_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("customModelTags").getter(CreateModelCustomizationJobRequest.getter(CreateModelCustomizationJobRequest::customModelTags)).setter(CreateModelCustomizationJobRequest.setter(Builder::customModelTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customModelTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TrainingDataConfig> TRAINING_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("trainingDataConfig").getter(CreateModelCustomizationJobRequest.getter(CreateModelCustomizationJobRequest::trainingDataConfig)).setter(CreateModelCustomizationJobRequest.setter(Builder::trainingDataConfig)).constructor(TrainingDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDataConfig").build()}).build();
    private static final SdkField<ValidationDataConfig> VALIDATION_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("validationDataConfig").getter(CreateModelCustomizationJobRequest.getter(CreateModelCustomizationJobRequest::validationDataConfig)).setter(CreateModelCustomizationJobRequest.setter(Builder::validationDataConfig)).constructor(ValidationDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationDataConfig").build()}).build();
    private static final SdkField<OutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputDataConfig").getter(CreateModelCustomizationJobRequest.getter(CreateModelCustomizationJobRequest::outputDataConfig)).setter(CreateModelCustomizationJobRequest.setter(Builder::outputDataConfig)).constructor(OutputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputDataConfig").build()}).build();
    private static final SdkField<Map<String, String>> HYPER_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("hyperParameters").getter(CreateModelCustomizationJobRequest.getter(CreateModelCustomizationJobRequest::hyperParameters)).setter(CreateModelCustomizationJobRequest.setter(Builder::hyperParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hyperParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vpcConfig").getter(CreateModelCustomizationJobRequest.getter(CreateModelCustomizationJobRequest::vpcConfig)).setter(CreateModelCustomizationJobRequest.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD, CUSTOM_MODEL_NAME_FIELD, ROLE_ARN_FIELD, CLIENT_REQUEST_TOKEN_FIELD, BASE_MODEL_IDENTIFIER_FIELD, CUSTOMIZATION_TYPE_FIELD, CUSTOM_MODEL_KMS_KEY_ID_FIELD, JOB_TAGS_FIELD, CUSTOM_MODEL_TAGS_FIELD, TRAINING_DATA_CONFIG_FIELD, VALIDATION_DATA_CONFIG_FIELD, OUTPUT_DATA_CONFIG_FIELD, HYPER_PARAMETERS_FIELD, VPC_CONFIG_FIELD));
    private final String jobName;
    private final String customModelName;
    private final String roleArn;
    private final String clientRequestToken;
    private final String baseModelIdentifier;
    private final String customizationType;
    private final String customModelKmsKeyId;
    private final List<Tag> jobTags;
    private final List<Tag> customModelTags;
    private final TrainingDataConfig trainingDataConfig;
    private final ValidationDataConfig validationDataConfig;
    private final OutputDataConfig outputDataConfig;
    private final Map<String, String> hyperParameters;
    private final VpcConfig vpcConfig;

    private CreateModelCustomizationJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.customModelName = builder.customModelName;
        this.roleArn = builder.roleArn;
        this.clientRequestToken = builder.clientRequestToken;
        this.baseModelIdentifier = builder.baseModelIdentifier;
        this.customizationType = builder.customizationType;
        this.customModelKmsKeyId = builder.customModelKmsKeyId;
        this.jobTags = builder.jobTags;
        this.customModelTags = builder.customModelTags;
        this.trainingDataConfig = builder.trainingDataConfig;
        this.validationDataConfig = builder.validationDataConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.hyperParameters = builder.hyperParameters;
        this.vpcConfig = builder.vpcConfig;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final String customModelName() {
        return this.customModelName;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final String baseModelIdentifier() {
        return this.baseModelIdentifier;
    }

    public final CustomizationType customizationType() {
        return CustomizationType.fromValue(this.customizationType);
    }

    public final String customizationTypeAsString() {
        return this.customizationType;
    }

    public final String customModelKmsKeyId() {
        return this.customModelKmsKeyId;
    }

    public final boolean hasJobTags() {
        return this.jobTags != null && !(this.jobTags instanceof SdkAutoConstructList);
    }

    public final List<Tag> jobTags() {
        return this.jobTags;
    }

    public final boolean hasCustomModelTags() {
        return this.customModelTags != null && !(this.customModelTags instanceof SdkAutoConstructList);
    }

    public final List<Tag> customModelTags() {
        return this.customModelTags;
    }

    public final TrainingDataConfig trainingDataConfig() {
        return this.trainingDataConfig;
    }

    public final ValidationDataConfig validationDataConfig() {
        return this.validationDataConfig;
    }

    public final OutputDataConfig outputDataConfig() {
        return this.outputDataConfig;
    }

    public final boolean hasHyperParameters() {
        return this.hyperParameters != null && !(this.hyperParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> hyperParameters() {
        return this.hyperParameters;
    }

    public final VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.customModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseModelIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.customizationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.customModelKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobTags() ? this.jobTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomModelTags() ? this.customModelTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHyperParameters() ? this.hyperParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateModelCustomizationJobRequest)) {
            return false;
        }
        CreateModelCustomizationJobRequest other = (CreateModelCustomizationJobRequest)((Object)obj);
        return Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.customModelName(), other.customModelName()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.baseModelIdentifier(), other.baseModelIdentifier()) && Objects.equals(this.customizationTypeAsString(), other.customizationTypeAsString()) && Objects.equals(this.customModelKmsKeyId(), other.customModelKmsKeyId()) && this.hasJobTags() == other.hasJobTags() && Objects.equals(this.jobTags(), other.jobTags()) && this.hasCustomModelTags() == other.hasCustomModelTags() && Objects.equals(this.customModelTags(), other.customModelTags()) && Objects.equals(this.trainingDataConfig(), other.trainingDataConfig()) && Objects.equals(this.validationDataConfig(), other.validationDataConfig()) && Objects.equals(this.outputDataConfig(), other.outputDataConfig()) && this.hasHyperParameters() == other.hasHyperParameters() && Objects.equals(this.hyperParameters(), other.hyperParameters()) && Objects.equals(this.vpcConfig(), other.vpcConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CreateModelCustomizationJobRequest").add("JobName", (Object)this.jobName()).add("CustomModelName", (Object)this.customModelName()).add("RoleArn", (Object)this.roleArn()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("BaseModelIdentifier", (Object)this.baseModelIdentifier()).add("CustomizationType", (Object)this.customizationTypeAsString()).add("CustomModelKmsKeyId", (Object)this.customModelKmsKeyId()).add("JobTags", this.hasJobTags() ? this.jobTags() : null).add("CustomModelTags", this.hasCustomModelTags() ? this.customModelTags() : null).add("TrainingDataConfig", (Object)this.trainingDataConfig()).add("ValidationDataConfig", (Object)this.validationDataConfig()).add("OutputDataConfig", (Object)this.outputDataConfig()).add("HyperParameters", this.hasHyperParameters() ? this.hyperParameters() : null).add("VpcConfig", (Object)this.vpcConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "customModelName": {
                return Optional.ofNullable(clazz.cast(this.customModelName()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "baseModelIdentifier": {
                return Optional.ofNullable(clazz.cast(this.baseModelIdentifier()));
            }
            case "customizationType": {
                return Optional.ofNullable(clazz.cast(this.customizationTypeAsString()));
            }
            case "customModelKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.customModelKmsKeyId()));
            }
            case "jobTags": {
                return Optional.ofNullable(clazz.cast(this.jobTags()));
            }
            case "customModelTags": {
                return Optional.ofNullable(clazz.cast(this.customModelTags()));
            }
            case "trainingDataConfig": {
                return Optional.ofNullable(clazz.cast(this.trainingDataConfig()));
            }
            case "validationDataConfig": {
                return Optional.ofNullable(clazz.cast(this.validationDataConfig()));
            }
            case "outputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.outputDataConfig()));
            }
            case "hyperParameters": {
                return Optional.ofNullable(clazz.cast(this.hyperParameters()));
            }
            case "vpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateModelCustomizationJobRequest, T> g) {
        return obj -> g.apply((CreateModelCustomizationJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRequest.BuilderImpl
    implements Builder {
        private String jobName;
        private String customModelName;
        private String roleArn;
        private String clientRequestToken;
        private String baseModelIdentifier;
        private String customizationType;
        private String customModelKmsKeyId;
        private List<Tag> jobTags = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> customModelTags = DefaultSdkAutoConstructList.getInstance();
        private TrainingDataConfig trainingDataConfig;
        private ValidationDataConfig validationDataConfig;
        private OutputDataConfig outputDataConfig;
        private Map<String, String> hyperParameters = DefaultSdkAutoConstructMap.getInstance();
        private VpcConfig vpcConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateModelCustomizationJobRequest model) {
            super(model);
            this.jobName(model.jobName);
            this.customModelName(model.customModelName);
            this.roleArn(model.roleArn);
            this.clientRequestToken(model.clientRequestToken);
            this.baseModelIdentifier(model.baseModelIdentifier);
            this.customizationType(model.customizationType);
            this.customModelKmsKeyId(model.customModelKmsKeyId);
            this.jobTags(model.jobTags);
            this.customModelTags(model.customModelTags);
            this.trainingDataConfig(model.trainingDataConfig);
            this.validationDataConfig(model.validationDataConfig);
            this.outputDataConfig(model.outputDataConfig);
            this.hyperParameters(model.hyperParameters);
            this.vpcConfig(model.vpcConfig);
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getCustomModelName() {
            return this.customModelName;
        }

        public final void setCustomModelName(String customModelName) {
            this.customModelName = customModelName;
        }

        @Override
        public final Builder customModelName(String customModelName) {
            this.customModelName = customModelName;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getBaseModelIdentifier() {
            return this.baseModelIdentifier;
        }

        public final void setBaseModelIdentifier(String baseModelIdentifier) {
            this.baseModelIdentifier = baseModelIdentifier;
        }

        @Override
        public final Builder baseModelIdentifier(String baseModelIdentifier) {
            this.baseModelIdentifier = baseModelIdentifier;
            return this;
        }

        public final String getCustomizationType() {
            return this.customizationType;
        }

        public final void setCustomizationType(String customizationType) {
            this.customizationType = customizationType;
        }

        @Override
        public final Builder customizationType(String customizationType) {
            this.customizationType = customizationType;
            return this;
        }

        @Override
        public final Builder customizationType(CustomizationType customizationType) {
            this.customizationType(customizationType == null ? null : customizationType.toString());
            return this;
        }

        public final String getCustomModelKmsKeyId() {
            return this.customModelKmsKeyId;
        }

        public final void setCustomModelKmsKeyId(String customModelKmsKeyId) {
            this.customModelKmsKeyId = customModelKmsKeyId;
        }

        @Override
        public final Builder customModelKmsKeyId(String customModelKmsKeyId) {
            this.customModelKmsKeyId = customModelKmsKeyId;
            return this;
        }

        public final List<Tag.Builder> getJobTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.jobTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setJobTags(Collection<Tag.BuilderImpl> jobTags) {
            this.jobTags = TagListCopier.copyFromBuilder(jobTags);
        }

        @Override
        public final Builder jobTags(Collection<Tag> jobTags) {
            this.jobTags = TagListCopier.copy(jobTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobTags(Tag ... jobTags) {
            this.jobTags(Arrays.asList(jobTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobTags(Consumer<Tag.Builder> ... jobTags) {
            this.jobTags(Stream.of(jobTags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getCustomModelTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.customModelTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomModelTags(Collection<Tag.BuilderImpl> customModelTags) {
            this.customModelTags = TagListCopier.copyFromBuilder(customModelTags);
        }

        @Override
        public final Builder customModelTags(Collection<Tag> customModelTags) {
            this.customModelTags = TagListCopier.copy(customModelTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customModelTags(Tag ... customModelTags) {
            this.customModelTags(Arrays.asList(customModelTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customModelTags(Consumer<Tag.Builder> ... customModelTags) {
            this.customModelTags(Stream.of(customModelTags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final TrainingDataConfig.Builder getTrainingDataConfig() {
            return this.trainingDataConfig != null ? this.trainingDataConfig.toBuilder() : null;
        }

        public final void setTrainingDataConfig(TrainingDataConfig.BuilderImpl trainingDataConfig) {
            this.trainingDataConfig = trainingDataConfig != null ? trainingDataConfig.build() : null;
        }

        @Override
        public final Builder trainingDataConfig(TrainingDataConfig trainingDataConfig) {
            this.trainingDataConfig = trainingDataConfig;
            return this;
        }

        public final ValidationDataConfig.Builder getValidationDataConfig() {
            return this.validationDataConfig != null ? this.validationDataConfig.toBuilder() : null;
        }

        public final void setValidationDataConfig(ValidationDataConfig.BuilderImpl validationDataConfig) {
            this.validationDataConfig = validationDataConfig != null ? validationDataConfig.build() : null;
        }

        @Override
        public final Builder validationDataConfig(ValidationDataConfig validationDataConfig) {
            this.validationDataConfig = validationDataConfig;
            return this;
        }

        public final OutputDataConfig.Builder getOutputDataConfig() {
            return this.outputDataConfig != null ? this.outputDataConfig.toBuilder() : null;
        }

        public final void setOutputDataConfig(OutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        @Override
        public final Builder outputDataConfig(OutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final Map<String, String> getHyperParameters() {
            if (this.hyperParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.hyperParameters;
        }

        public final void setHyperParameters(Map<String, String> hyperParameters) {
            this.hyperParameters = ModelCustomizationHyperParametersCopier.copy(hyperParameters);
        }

        @Override
        public final Builder hyperParameters(Map<String, String> hyperParameters) {
            this.hyperParameters = ModelCustomizationHyperParametersCopier.copy(hyperParameters);
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateModelCustomizationJobRequest build() {
            return new CreateModelCustomizationJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BedrockRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateModelCustomizationJobRequest> {
        public Builder jobName(String var1);

        public Builder customModelName(String var1);

        public Builder roleArn(String var1);

        public Builder clientRequestToken(String var1);

        public Builder baseModelIdentifier(String var1);

        public Builder customizationType(String var1);

        public Builder customizationType(CustomizationType var1);

        public Builder customModelKmsKeyId(String var1);

        public Builder jobTags(Collection<Tag> var1);

        public Builder jobTags(Tag ... var1);

        public Builder jobTags(Consumer<Tag.Builder> ... var1);

        public Builder customModelTags(Collection<Tag> var1);

        public Builder customModelTags(Tag ... var1);

        public Builder customModelTags(Consumer<Tag.Builder> ... var1);

        public Builder trainingDataConfig(TrainingDataConfig var1);

        default public Builder trainingDataConfig(Consumer<TrainingDataConfig.Builder> trainingDataConfig) {
            return this.trainingDataConfig((TrainingDataConfig)((TrainingDataConfig.Builder)TrainingDataConfig.builder().applyMutation(trainingDataConfig)).build());
        }

        public Builder validationDataConfig(ValidationDataConfig var1);

        default public Builder validationDataConfig(Consumer<ValidationDataConfig.Builder> validationDataConfig) {
            return this.validationDataConfig((ValidationDataConfig)((ValidationDataConfig.Builder)ValidationDataConfig.builder().applyMutation(validationDataConfig)).build());
        }

        public Builder outputDataConfig(OutputDataConfig var1);

        default public Builder outputDataConfig(Consumer<OutputDataConfig.Builder> outputDataConfig) {
            return this.outputDataConfig((OutputDataConfig)((OutputDataConfig.Builder)OutputDataConfig.builder().applyMutation(outputDataConfig)).build());
        }

        public Builder hyperParameters(Map<String, String> var1);

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

