/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.BedrockRequest;
import software.amazon.awssdk.services.bedrock.model.Tag;
import software.amazon.awssdk.services.bedrock.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAutomatedReasoningPolicyVersionRequest
extends BedrockRequest
implements ToCopyableBuilder<Builder, CreateAutomatedReasoningPolicyVersionRequest> {
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyArn").getter(CreateAutomatedReasoningPolicyVersionRequest.getter(CreateAutomatedReasoningPolicyVersionRequest::policyArn)).setter(CreateAutomatedReasoningPolicyVersionRequest.setter(Builder::policyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("policyArn").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(CreateAutomatedReasoningPolicyVersionRequest.getter(CreateAutomatedReasoningPolicyVersionRequest::clientRequestToken)).setter(CreateAutomatedReasoningPolicyVersionRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> LAST_UPDATED_DEFINITION_HASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastUpdatedDefinitionHash").getter(CreateAutomatedReasoningPolicyVersionRequest.getter(CreateAutomatedReasoningPolicyVersionRequest::lastUpdatedDefinitionHash)).setter(CreateAutomatedReasoningPolicyVersionRequest.setter(Builder::lastUpdatedDefinitionHash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDefinitionHash").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateAutomatedReasoningPolicyVersionRequest.getter(CreateAutomatedReasoningPolicyVersionRequest::tags)).setter(CreateAutomatedReasoningPolicyVersionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ARN_FIELD, CLIENT_REQUEST_TOKEN_FIELD, LAST_UPDATED_DEFINITION_HASH_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAutomatedReasoningPolicyVersionRequest.memberNameToFieldInitializer();
    private final String policyArn;
    private final String clientRequestToken;
    private final String lastUpdatedDefinitionHash;
    private final List<Tag> tags;

    private CreateAutomatedReasoningPolicyVersionRequest(BuilderImpl builder) {
        super(builder);
        this.policyArn = builder.policyArn;
        this.clientRequestToken = builder.clientRequestToken;
        this.lastUpdatedDefinitionHash = builder.lastUpdatedDefinitionHash;
        this.tags = builder.tags;
    }

    public final String policyArn() {
        return this.policyArn;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final String lastUpdatedDefinitionHash() {
        return this.lastUpdatedDefinitionHash;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDefinitionHash());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAutomatedReasoningPolicyVersionRequest)) {
            return false;
        }
        CreateAutomatedReasoningPolicyVersionRequest other = (CreateAutomatedReasoningPolicyVersionRequest)((Object)obj);
        return Objects.equals(this.policyArn(), other.policyArn()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.lastUpdatedDefinitionHash(), other.lastUpdatedDefinitionHash()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAutomatedReasoningPolicyVersionRequest").add("PolicyArn", (Object)this.policyArn()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("LastUpdatedDefinitionHash", (Object)this.lastUpdatedDefinitionHash()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyArn": {
                return Optional.ofNullable(clazz.cast(this.policyArn()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "lastUpdatedDefinitionHash": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDefinitionHash()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("policyArn", POLICY_ARN_FIELD);
        map.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("lastUpdatedDefinitionHash", LAST_UPDATED_DEFINITION_HASH_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAutomatedReasoningPolicyVersionRequest, T> g) {
        return obj -> g.apply((CreateAutomatedReasoningPolicyVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRequest.BuilderImpl
    implements Builder {
        private String policyArn;
        private String clientRequestToken;
        private String lastUpdatedDefinitionHash;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAutomatedReasoningPolicyVersionRequest model) {
            super(model);
            this.policyArn(model.policyArn);
            this.clientRequestToken(model.clientRequestToken);
            this.lastUpdatedDefinitionHash(model.lastUpdatedDefinitionHash);
            this.tags(model.tags);
        }

        public final String getPolicyArn() {
            return this.policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getLastUpdatedDefinitionHash() {
            return this.lastUpdatedDefinitionHash;
        }

        public final void setLastUpdatedDefinitionHash(String lastUpdatedDefinitionHash) {
            this.lastUpdatedDefinitionHash = lastUpdatedDefinitionHash;
        }

        @Override
        public final Builder lastUpdatedDefinitionHash(String lastUpdatedDefinitionHash) {
            this.lastUpdatedDefinitionHash = lastUpdatedDefinitionHash;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAutomatedReasoningPolicyVersionRequest build() {
            return new CreateAutomatedReasoningPolicyVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAutomatedReasoningPolicyVersionRequest> {
        public Builder policyArn(String var1);

        public Builder clientRequestToken(String var1);

        public Builder lastUpdatedDefinitionHash(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

