/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntitiesConfigCopier;
import software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityConfig;
import software.amazon.awssdk.services.bedrock.model.GuardrailRegexConfig;
import software.amazon.awssdk.services.bedrock.model.GuardrailRegexesConfigCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GuardrailSensitiveInformationPolicyConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GuardrailSensitiveInformationPolicyConfig> {
    private static final SdkField<List<GuardrailPiiEntityConfig>> PII_ENTITIES_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("piiEntitiesConfig").getter(GuardrailSensitiveInformationPolicyConfig.getter(GuardrailSensitiveInformationPolicyConfig::piiEntitiesConfig)).setter(GuardrailSensitiveInformationPolicyConfig.setter(Builder::piiEntitiesConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("piiEntitiesConfig").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GuardrailPiiEntityConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<GuardrailRegexConfig>> REGEXES_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("regexesConfig").getter(GuardrailSensitiveInformationPolicyConfig.getter(GuardrailSensitiveInformationPolicyConfig::regexesConfig)).setter(GuardrailSensitiveInformationPolicyConfig.setter(Builder::regexesConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regexesConfig").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GuardrailRegexConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PII_ENTITIES_CONFIG_FIELD, REGEXES_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GuardrailSensitiveInformationPolicyConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<GuardrailPiiEntityConfig> piiEntitiesConfig;
    private final List<GuardrailRegexConfig> regexesConfig;

    private GuardrailSensitiveInformationPolicyConfig(BuilderImpl builder) {
        this.piiEntitiesConfig = builder.piiEntitiesConfig;
        this.regexesConfig = builder.regexesConfig;
    }

    public final boolean hasPiiEntitiesConfig() {
        return this.piiEntitiesConfig != null && !(this.piiEntitiesConfig instanceof SdkAutoConstructList);
    }

    public final List<GuardrailPiiEntityConfig> piiEntitiesConfig() {
        return this.piiEntitiesConfig;
    }

    public final boolean hasRegexesConfig() {
        return this.regexesConfig != null && !(this.regexesConfig instanceof SdkAutoConstructList);
    }

    public final List<GuardrailRegexConfig> regexesConfig() {
        return this.regexesConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPiiEntitiesConfig() ? this.piiEntitiesConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegexesConfig() ? this.regexesConfig() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailSensitiveInformationPolicyConfig)) {
            return false;
        }
        GuardrailSensitiveInformationPolicyConfig other = (GuardrailSensitiveInformationPolicyConfig)obj;
        return this.hasPiiEntitiesConfig() == other.hasPiiEntitiesConfig() && Objects.equals(this.piiEntitiesConfig(), other.piiEntitiesConfig()) && this.hasRegexesConfig() == other.hasRegexesConfig() && Objects.equals(this.regexesConfig(), other.regexesConfig());
    }

    public final String toString() {
        return ToString.builder((String)"GuardrailSensitiveInformationPolicyConfig").add("PiiEntitiesConfig", this.hasPiiEntitiesConfig() ? this.piiEntitiesConfig() : null).add("RegexesConfig", this.hasRegexesConfig() ? this.regexesConfig() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "piiEntitiesConfig": {
                return Optional.ofNullable(clazz.cast(this.piiEntitiesConfig()));
            }
            case "regexesConfig": {
                return Optional.ofNullable(clazz.cast(this.regexesConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("piiEntitiesConfig", PII_ENTITIES_CONFIG_FIELD);
        map.put("regexesConfig", REGEXES_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailSensitiveInformationPolicyConfig, T> g) {
        return obj -> g.apply((GuardrailSensitiveInformationPolicyConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<GuardrailPiiEntityConfig> piiEntitiesConfig = DefaultSdkAutoConstructList.getInstance();
        private List<GuardrailRegexConfig> regexesConfig = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailSensitiveInformationPolicyConfig model) {
            this.piiEntitiesConfig(model.piiEntitiesConfig);
            this.regexesConfig(model.regexesConfig);
        }

        public final List<GuardrailPiiEntityConfig.Builder> getPiiEntitiesConfig() {
            List<GuardrailPiiEntityConfig.Builder> result = GuardrailPiiEntitiesConfigCopier.copyToBuilder(this.piiEntitiesConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPiiEntitiesConfig(Collection<GuardrailPiiEntityConfig.BuilderImpl> piiEntitiesConfig) {
            this.piiEntitiesConfig = GuardrailPiiEntitiesConfigCopier.copyFromBuilder(piiEntitiesConfig);
        }

        @Override
        public final Builder piiEntitiesConfig(Collection<GuardrailPiiEntityConfig> piiEntitiesConfig) {
            this.piiEntitiesConfig = GuardrailPiiEntitiesConfigCopier.copy(piiEntitiesConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder piiEntitiesConfig(GuardrailPiiEntityConfig ... piiEntitiesConfig) {
            this.piiEntitiesConfig(Arrays.asList(piiEntitiesConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder piiEntitiesConfig(Consumer<GuardrailPiiEntityConfig.Builder> ... piiEntitiesConfig) {
            this.piiEntitiesConfig(Stream.of(piiEntitiesConfig).map(c -> (GuardrailPiiEntityConfig)((GuardrailPiiEntityConfig.Builder)GuardrailPiiEntityConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<GuardrailRegexConfig.Builder> getRegexesConfig() {
            List<GuardrailRegexConfig.Builder> result = GuardrailRegexesConfigCopier.copyToBuilder(this.regexesConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegexesConfig(Collection<GuardrailRegexConfig.BuilderImpl> regexesConfig) {
            this.regexesConfig = GuardrailRegexesConfigCopier.copyFromBuilder(regexesConfig);
        }

        @Override
        public final Builder regexesConfig(Collection<GuardrailRegexConfig> regexesConfig) {
            this.regexesConfig = GuardrailRegexesConfigCopier.copy(regexesConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regexesConfig(GuardrailRegexConfig ... regexesConfig) {
            this.regexesConfig(Arrays.asList(regexesConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regexesConfig(Consumer<GuardrailRegexConfig.Builder> ... regexesConfig) {
            this.regexesConfig(Stream.of(regexesConfig).map(c -> (GuardrailRegexConfig)((GuardrailRegexConfig.Builder)GuardrailRegexConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public GuardrailSensitiveInformationPolicyConfig build() {
            return new GuardrailSensitiveInformationPolicyConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GuardrailSensitiveInformationPolicyConfig> {
        public Builder piiEntitiesConfig(Collection<GuardrailPiiEntityConfig> var1);

        public Builder piiEntitiesConfig(GuardrailPiiEntityConfig ... var1);

        public Builder piiEntitiesConfig(Consumer<GuardrailPiiEntityConfig.Builder> ... var1);

        public Builder regexesConfig(Collection<GuardrailRegexConfig> var1);

        public Builder regexesConfig(GuardrailRegexConfig ... var1);

        public Builder regexesConfig(Consumer<GuardrailRegexConfig.Builder> ... var1);
    }
}

