/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InputTags {
    HONOR("HONOR"),
    IGNORE("IGNORE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InputTags> VALUE_MAP;
    private final String value;

    private InputTags(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InputTags fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InputTags> knownValues() {
        EnumSet<InputTags> knownValues = EnumSet.allOf(InputTags.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InputTags.class, InputTags::toString);
    }
}

