/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.ReasoningEffort;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RFTHyperParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RFTHyperParameters> {
    private static final SdkField<Integer> EPOCH_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("epochCount").getter(RFTHyperParameters.getter(RFTHyperParameters::epochCount)).setter(RFTHyperParameters.setter(Builder::epochCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("epochCount").build()}).build();
    private static final SdkField<Integer> BATCH_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("batchSize").getter(RFTHyperParameters.getter(RFTHyperParameters::batchSize)).setter(RFTHyperParameters.setter(Builder::batchSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchSize").build()}).build();
    private static final SdkField<Float> LEARNING_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("learningRate").getter(RFTHyperParameters.getter(RFTHyperParameters::learningRate)).setter(RFTHyperParameters.setter(Builder::learningRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("learningRate").build()}).build();
    private static final SdkField<Integer> MAX_PROMPT_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxPromptLength").getter(RFTHyperParameters.getter(RFTHyperParameters::maxPromptLength)).setter(RFTHyperParameters.setter(Builder::maxPromptLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxPromptLength").build()}).build();
    private static final SdkField<Integer> TRAINING_SAMPLE_PER_PROMPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("trainingSamplePerPrompt").getter(RFTHyperParameters.getter(RFTHyperParameters::trainingSamplePerPrompt)).setter(RFTHyperParameters.setter(Builder::trainingSamplePerPrompt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingSamplePerPrompt").build()}).build();
    private static final SdkField<Integer> INFERENCE_MAX_TOKENS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("inferenceMaxTokens").getter(RFTHyperParameters.getter(RFTHyperParameters::inferenceMaxTokens)).setter(RFTHyperParameters.setter(Builder::inferenceMaxTokens)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceMaxTokens").build()}).build();
    private static final SdkField<String> REASONING_EFFORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reasoningEffort").getter(RFTHyperParameters.getter(RFTHyperParameters::reasoningEffortAsString)).setter(RFTHyperParameters.setter(Builder::reasoningEffort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reasoningEffort").build()}).build();
    private static final SdkField<Integer> EVAL_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("evalInterval").getter(RFTHyperParameters.getter(RFTHyperParameters::evalInterval)).setter(RFTHyperParameters.setter(Builder::evalInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evalInterval").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EPOCH_COUNT_FIELD, BATCH_SIZE_FIELD, LEARNING_RATE_FIELD, MAX_PROMPT_LENGTH_FIELD, TRAINING_SAMPLE_PER_PROMPT_FIELD, INFERENCE_MAX_TOKENS_FIELD, REASONING_EFFORT_FIELD, EVAL_INTERVAL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RFTHyperParameters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer epochCount;
    private final Integer batchSize;
    private final Float learningRate;
    private final Integer maxPromptLength;
    private final Integer trainingSamplePerPrompt;
    private final Integer inferenceMaxTokens;
    private final String reasoningEffort;
    private final Integer evalInterval;

    private RFTHyperParameters(BuilderImpl builder) {
        this.epochCount = builder.epochCount;
        this.batchSize = builder.batchSize;
        this.learningRate = builder.learningRate;
        this.maxPromptLength = builder.maxPromptLength;
        this.trainingSamplePerPrompt = builder.trainingSamplePerPrompt;
        this.inferenceMaxTokens = builder.inferenceMaxTokens;
        this.reasoningEffort = builder.reasoningEffort;
        this.evalInterval = builder.evalInterval;
    }

    public final Integer epochCount() {
        return this.epochCount;
    }

    public final Integer batchSize() {
        return this.batchSize;
    }

    public final Float learningRate() {
        return this.learningRate;
    }

    public final Integer maxPromptLength() {
        return this.maxPromptLength;
    }

    public final Integer trainingSamplePerPrompt() {
        return this.trainingSamplePerPrompt;
    }

    public final Integer inferenceMaxTokens() {
        return this.inferenceMaxTokens;
    }

    public final ReasoningEffort reasoningEffort() {
        return ReasoningEffort.fromValue(this.reasoningEffort);
    }

    public final String reasoningEffortAsString() {
        return this.reasoningEffort;
    }

    public final Integer evalInterval() {
        return this.evalInterval;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.epochCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.learningRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxPromptLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingSamplePerPrompt());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceMaxTokens());
        hashCode = 31 * hashCode + Objects.hashCode(this.reasoningEffortAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.evalInterval());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RFTHyperParameters)) {
            return false;
        }
        RFTHyperParameters other = (RFTHyperParameters)obj;
        return Objects.equals(this.epochCount(), other.epochCount()) && Objects.equals(this.batchSize(), other.batchSize()) && Objects.equals(this.learningRate(), other.learningRate()) && Objects.equals(this.maxPromptLength(), other.maxPromptLength()) && Objects.equals(this.trainingSamplePerPrompt(), other.trainingSamplePerPrompt()) && Objects.equals(this.inferenceMaxTokens(), other.inferenceMaxTokens()) && Objects.equals(this.reasoningEffortAsString(), other.reasoningEffortAsString()) && Objects.equals(this.evalInterval(), other.evalInterval());
    }

    public final String toString() {
        return ToString.builder((String)"RFTHyperParameters").add("EpochCount", (Object)this.epochCount()).add("BatchSize", (Object)this.batchSize()).add("LearningRate", (Object)this.learningRate()).add("MaxPromptLength", (Object)this.maxPromptLength()).add("TrainingSamplePerPrompt", (Object)this.trainingSamplePerPrompt()).add("InferenceMaxTokens", (Object)this.inferenceMaxTokens()).add("ReasoningEffort", (Object)this.reasoningEffortAsString()).add("EvalInterval", (Object)this.evalInterval()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "epochCount": {
                return Optional.ofNullable(clazz.cast(this.epochCount()));
            }
            case "batchSize": {
                return Optional.ofNullable(clazz.cast(this.batchSize()));
            }
            case "learningRate": {
                return Optional.ofNullable(clazz.cast(this.learningRate()));
            }
            case "maxPromptLength": {
                return Optional.ofNullable(clazz.cast(this.maxPromptLength()));
            }
            case "trainingSamplePerPrompt": {
                return Optional.ofNullable(clazz.cast(this.trainingSamplePerPrompt()));
            }
            case "inferenceMaxTokens": {
                return Optional.ofNullable(clazz.cast(this.inferenceMaxTokens()));
            }
            case "reasoningEffort": {
                return Optional.ofNullable(clazz.cast(this.reasoningEffortAsString()));
            }
            case "evalInterval": {
                return Optional.ofNullable(clazz.cast(this.evalInterval()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("epochCount", EPOCH_COUNT_FIELD);
        map.put("batchSize", BATCH_SIZE_FIELD);
        map.put("learningRate", LEARNING_RATE_FIELD);
        map.put("maxPromptLength", MAX_PROMPT_LENGTH_FIELD);
        map.put("trainingSamplePerPrompt", TRAINING_SAMPLE_PER_PROMPT_FIELD);
        map.put("inferenceMaxTokens", INFERENCE_MAX_TOKENS_FIELD);
        map.put("reasoningEffort", REASONING_EFFORT_FIELD);
        map.put("evalInterval", EVAL_INTERVAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RFTHyperParameters, T> g) {
        return obj -> g.apply((RFTHyperParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer epochCount;
        private Integer batchSize;
        private Float learningRate;
        private Integer maxPromptLength;
        private Integer trainingSamplePerPrompt;
        private Integer inferenceMaxTokens;
        private String reasoningEffort;
        private Integer evalInterval;

        private BuilderImpl() {
        }

        private BuilderImpl(RFTHyperParameters model) {
            this.epochCount(model.epochCount);
            this.batchSize(model.batchSize);
            this.learningRate(model.learningRate);
            this.maxPromptLength(model.maxPromptLength);
            this.trainingSamplePerPrompt(model.trainingSamplePerPrompt);
            this.inferenceMaxTokens(model.inferenceMaxTokens);
            this.reasoningEffort(model.reasoningEffort);
            this.evalInterval(model.evalInterval);
        }

        public final Integer getEpochCount() {
            return this.epochCount;
        }

        public final void setEpochCount(Integer epochCount) {
            this.epochCount = epochCount;
        }

        @Override
        public final Builder epochCount(Integer epochCount) {
            this.epochCount = epochCount;
            return this;
        }

        public final Integer getBatchSize() {
            return this.batchSize;
        }

        public final void setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
        }

        @Override
        public final Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public final Float getLearningRate() {
            return this.learningRate;
        }

        public final void setLearningRate(Float learningRate) {
            this.learningRate = learningRate;
        }

        @Override
        public final Builder learningRate(Float learningRate) {
            this.learningRate = learningRate;
            return this;
        }

        public final Integer getMaxPromptLength() {
            return this.maxPromptLength;
        }

        public final void setMaxPromptLength(Integer maxPromptLength) {
            this.maxPromptLength = maxPromptLength;
        }

        @Override
        public final Builder maxPromptLength(Integer maxPromptLength) {
            this.maxPromptLength = maxPromptLength;
            return this;
        }

        public final Integer getTrainingSamplePerPrompt() {
            return this.trainingSamplePerPrompt;
        }

        public final void setTrainingSamplePerPrompt(Integer trainingSamplePerPrompt) {
            this.trainingSamplePerPrompt = trainingSamplePerPrompt;
        }

        @Override
        public final Builder trainingSamplePerPrompt(Integer trainingSamplePerPrompt) {
            this.trainingSamplePerPrompt = trainingSamplePerPrompt;
            return this;
        }

        public final Integer getInferenceMaxTokens() {
            return this.inferenceMaxTokens;
        }

        public final void setInferenceMaxTokens(Integer inferenceMaxTokens) {
            this.inferenceMaxTokens = inferenceMaxTokens;
        }

        @Override
        public final Builder inferenceMaxTokens(Integer inferenceMaxTokens) {
            this.inferenceMaxTokens = inferenceMaxTokens;
            return this;
        }

        public final String getReasoningEffort() {
            return this.reasoningEffort;
        }

        public final void setReasoningEffort(String reasoningEffort) {
            this.reasoningEffort = reasoningEffort;
        }

        @Override
        public final Builder reasoningEffort(String reasoningEffort) {
            this.reasoningEffort = reasoningEffort;
            return this;
        }

        @Override
        public final Builder reasoningEffort(ReasoningEffort reasoningEffort) {
            this.reasoningEffort(reasoningEffort == null ? null : reasoningEffort.toString());
            return this;
        }

        public final Integer getEvalInterval() {
            return this.evalInterval;
        }

        public final void setEvalInterval(Integer evalInterval) {
            this.evalInterval = evalInterval;
        }

        @Override
        public final Builder evalInterval(Integer evalInterval) {
            this.evalInterval = evalInterval;
            return this;
        }

        public RFTHyperParameters build() {
            return new RFTHyperParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RFTHyperParameters> {
        public Builder epochCount(Integer var1);

        public Builder batchSize(Integer var1);

        public Builder learningRate(Float var1);

        public Builder maxPromptLength(Integer var1);

        public Builder trainingSamplePerPrompt(Integer var1);

        public Builder inferenceMaxTokens(Integer var1);

        public Builder reasoningEffort(String var1);

        public Builder reasoningEffort(ReasoningEffort var1);

        public Builder evalInterval(Integer var1);
    }
}

