/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrock.BedrockClient;
import software.amazon.awssdk.services.bedrock.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyBuildWorkflowSummary;
import software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyBuildWorkflowsRequest;
import software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyBuildWorkflowsResponse;

public class ListAutomatedReasoningPolicyBuildWorkflowsIterable
implements SdkIterable<ListAutomatedReasoningPolicyBuildWorkflowsResponse> {
    private final BedrockClient client;
    private final ListAutomatedReasoningPolicyBuildWorkflowsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAutomatedReasoningPolicyBuildWorkflowsIterable(BedrockClient client, ListAutomatedReasoningPolicyBuildWorkflowsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAutomatedReasoningPolicyBuildWorkflowsResponseFetcher();
    }

    public Iterator<ListAutomatedReasoningPolicyBuildWorkflowsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AutomatedReasoningPolicyBuildWorkflowSummary> automatedReasoningPolicyBuildWorkflowSummaries() {
        Function<ListAutomatedReasoningPolicyBuildWorkflowsResponse, Iterator> getIterator = response -> {
            if (response != null && response.automatedReasoningPolicyBuildWorkflowSummaries() != null) {
                return response.automatedReasoningPolicyBuildWorkflowSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAutomatedReasoningPolicyBuildWorkflowsResponseFetcher
    implements SyncPageFetcher<ListAutomatedReasoningPolicyBuildWorkflowsResponse> {
        private ListAutomatedReasoningPolicyBuildWorkflowsResponseFetcher() {
        }

        public boolean hasNextPage(ListAutomatedReasoningPolicyBuildWorkflowsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAutomatedReasoningPolicyBuildWorkflowsResponse nextPage(ListAutomatedReasoningPolicyBuildWorkflowsResponse previousPage) {
            if (previousPage == null) {
                return ListAutomatedReasoningPolicyBuildWorkflowsIterable.this.client.listAutomatedReasoningPolicyBuildWorkflows(ListAutomatedReasoningPolicyBuildWorkflowsIterable.this.firstRequest);
            }
            return ListAutomatedReasoningPolicyBuildWorkflowsIterable.this.client.listAutomatedReasoningPolicyBuildWorkflows((ListAutomatedReasoningPolicyBuildWorkflowsRequest)((Object)ListAutomatedReasoningPolicyBuildWorkflowsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

