/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrock.BedrockAsyncClient;
import software.amazon.awssdk.services.bedrock.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyTestCase;
import software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyTestCasesRequest;
import software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyTestCasesResponse;

public class ListAutomatedReasoningPolicyTestCasesPublisher
implements SdkPublisher<ListAutomatedReasoningPolicyTestCasesResponse> {
    private final BedrockAsyncClient client;
    private final ListAutomatedReasoningPolicyTestCasesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAutomatedReasoningPolicyTestCasesPublisher(BedrockAsyncClient client, ListAutomatedReasoningPolicyTestCasesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAutomatedReasoningPolicyTestCasesPublisher(BedrockAsyncClient client, ListAutomatedReasoningPolicyTestCasesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAutomatedReasoningPolicyTestCasesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAutomatedReasoningPolicyTestCasesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AutomatedReasoningPolicyTestCase> testCases() {
        Function<ListAutomatedReasoningPolicyTestCasesResponse, Iterator> getIterator = response -> {
            if (response != null && response.testCases() != null) {
                return response.testCases().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAutomatedReasoningPolicyTestCasesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAutomatedReasoningPolicyTestCasesResponseFetcher
    implements AsyncPageFetcher<ListAutomatedReasoningPolicyTestCasesResponse> {
        private ListAutomatedReasoningPolicyTestCasesResponseFetcher() {
        }

        public boolean hasNextPage(ListAutomatedReasoningPolicyTestCasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAutomatedReasoningPolicyTestCasesResponse> nextPage(ListAutomatedReasoningPolicyTestCasesResponse previousPage) {
            if (previousPage == null) {
                return ListAutomatedReasoningPolicyTestCasesPublisher.this.client.listAutomatedReasoningPolicyTestCases(ListAutomatedReasoningPolicyTestCasesPublisher.this.firstRequest);
            }
            return ListAutomatedReasoningPolicyTestCasesPublisher.this.client.listAutomatedReasoningPolicyTestCases((ListAutomatedReasoningPolicyTestCasesRequest)((Object)ListAutomatedReasoningPolicyTestCasesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

